/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.imageio.ImageIO;
import net.optifine.Config;
import net.optifine.SmartAnimations;
import net.optifine.TextureAnimation;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.TextureUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class TextureAnimations {
    private static TextureAnimation[] textureAnimations = null;
    private static int countAnimationsActive = 0;
    private static int frameCountAnimations = 0;

    public static void reset() {
        textureAnimations = null;
    }

    public static void update() {
        textureAnimations = null;
        countAnimationsActive = 0;
        asq[] rps = Config.getResourcePacks();
        textureAnimations = TextureAnimations.getTextureAnimations((asq[])rps);
        TextureAnimations.updateAnimations();
    }

    public static void updateAnimations() {
        if (textureAnimations == null || !Config.isAnimatedTextures()) {
            countAnimationsActive = 0;
            return;
        }
        int countActive = 0;
        for (int i = 0; i < textureAnimations.length; ++i) {
            TextureAnimation anim = textureAnimations[i];
            anim.updateTexture();
            if (!anim.isActive()) continue;
            ++countActive;
        }
        int frameCount = Config.getMinecraft().f.getFrameCount();
        if (frameCount != frameCountAnimations) {
            countAnimationsActive = countActive;
            frameCountAnimations = frameCount;
        }
        if (SmartAnimations.isActive()) {
            SmartAnimations.resetTexturesRendered();
        }
    }

    private static TextureAnimation[] getTextureAnimations(asq[] rps) {
        ArrayList<TextureAnimation> list = new ArrayList<TextureAnimation>();
        for (int i = 0; i < rps.length; ++i) {
            asq rp = rps[i];
            TextureAnimation[] tas = TextureAnimations.getTextureAnimations((asq)rp);
            if (tas == null) continue;
            list.addAll(Arrays.asList(tas));
        }
        TextureAnimation[] anims = list.toArray(new TextureAnimation[list.size()]);
        return anims;
    }

    private static TextureAnimation[] getTextureAnimations(asq rp) {
        String[] animPropNames = ResUtils.collectFiles((asq)rp, (String)"optifine/anim/", (String)".properties", null);
        if (animPropNames.length <= 0) {
            return null;
        }
        ArrayList<TextureAnimation> list = new ArrayList<TextureAnimation>();
        for (int i = 0; i < animPropNames.length; ++i) {
            String propName = animPropNames[i];
            Config.dbg((String)("Texture animation: " + propName));
            try {
                akr propLoc = new akr(propName);
                InputStream in = Config.getResourceStream((asq)rp, (ass)ass.a, (akr)propLoc);
                PropertiesOrdered props = new PropertiesOrdered();
                props.load(in);
                in.close();
                TextureAnimation anim = TextureAnimations.makeTextureAnimation((Properties)props, (akr)propLoc);
                if (anim == null) continue;
                akr locDstTex = new akr(anim.getDstTex());
                if (!Config.hasResource((asq)rp, (akr)locDstTex)) {
                    Config.dbg((String)("Skipped: " + propName + ", target texture not loaded from same resource pack"));
                    continue;
                }
                list.add(anim);
                continue;
            }
            catch (FileNotFoundException e) {
                Config.warn((String)("File not found: " + e.getMessage()));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        TextureAnimation[] anims = list.toArray(new TextureAnimation[list.size()]);
        return anims;
    }

    private static TextureAnimation makeTextureAnimation(Properties props, akr propLoc) {
        String texFrom = props.getProperty("from");
        String texTo = props.getProperty("to");
        int x = Config.parseInt((String)props.getProperty("x"), (int)-1);
        int y2 = Config.parseInt((String)props.getProperty("y"), (int)-1);
        int width = Config.parseInt((String)props.getProperty("w"), (int)-1);
        int height = Config.parseInt((String)props.getProperty("h"), (int)-1);
        if (texFrom == null || texTo == null) {
            Config.warn((String)"TextureAnimation: Source or target texture not specified");
            return null;
        }
        if (x < 0 || y2 < 0 || width < 0 || height < 0) {
            Config.warn((String)"TextureAnimation: Invalid coordinates");
            return null;
        }
        texFrom = texFrom.trim();
        texTo = texTo.trim();
        String basePath = TextureUtils.getBasePath((String)propLoc.a());
        texFrom = TextureUtils.fixResourcePath((String)texFrom, (String)basePath);
        texTo = TextureUtils.fixResourcePath((String)texTo, (String)basePath);
        byte[] imageBytes = TextureAnimations.getCustomTextureData((String)texFrom, (int)width);
        if (imageBytes == null) {
            Config.warn((String)("TextureAnimation: Source texture not found: " + texTo));
            return null;
        }
        int countPixels = imageBytes.length / 4;
        int countFrames = countPixels / (width * height);
        int countPixelsAllFrames = countFrames * (width * height);
        if (countPixels != countPixelsAllFrames) {
            Config.warn((String)("TextureAnimation: Source texture has invalid number of frames: " + texFrom + ", frames: " + (float)countPixels / (float)(width * height)));
            return null;
        }
        akr locTexTo = new akr(texTo);
        try {
            InputStream inTexTo = Config.getResourceStream((akr)locTexTo);
            if (inTexTo == null) {
                Config.warn((String)("TextureAnimation: Target texture not found: " + texTo));
                return null;
            }
            BufferedImage imgTexTo = TextureAnimations.readTextureImage((InputStream)inTexTo);
            if (x + width > imgTexTo.getWidth() || y2 + height > imgTexTo.getHeight()) {
                Config.warn((String)("TextureAnimation: Animation coordinates are outside the target texture: " + texTo));
                return null;
            }
            TextureAnimation anim = new TextureAnimation(texFrom, imageBytes, texTo, locTexTo, x, y2, width, height, props);
            return anim;
        }
        catch (IOException e) {
            Config.warn((String)("TextureAnimation: Target texture not found: " + texTo));
            return null;
        }
    }

    private static byte[] getCustomTextureData(String imagePath, int tileWidth) {
        byte[] imageBytes = TextureAnimations.loadImage((String)imagePath, (int)tileWidth);
        if (imageBytes == null) {
            imageBytes = TextureAnimations.loadImage((String)("/anim" + imagePath), (int)tileWidth);
        }
        return imageBytes;
    }

    private static byte[] loadImage(String name, int targetWidth) {
        fgs options = Config.getGameSettings();
        try {
            akr locRes = new akr(name);
            InputStream in = Config.getResourceStream((akr)locRes);
            if (in == null) {
                return null;
            }
            BufferedImage image = TextureAnimations.readTextureImage((InputStream)in);
            in.close();
            if (image == null) {
                return null;
            }
            if (targetWidth > 0 && image.getWidth() != targetWidth) {
                double aspectHW = image.getHeight() / image.getWidth();
                int targetHeight = (int)((double)targetWidth * aspectHW);
                image = TextureAnimations.scaleBufferedImage((BufferedImage)image, (int)targetWidth, (int)targetHeight);
            }
            int width = image.getWidth();
            int height = image.getHeight();
            int[] ai = new int[width * height];
            byte[] byteBuf = new byte[width * height * 4];
            image.getRGB(0, 0, width, height, ai, 0, width);
            for (int l = 0; l < ai.length; ++l) {
                int alpha = ai[l] >> 24 & 0xFF;
                int red = ai[l] >> 16 & 0xFF;
                int green = ai[l] >> 8 & 0xFF;
                int blue = ai[l] & 0xFF;
                byteBuf[l * 4 + 0] = (byte)red;
                byteBuf[l * 4 + 1] = (byte)green;
                byteBuf[l * 4 + 2] = (byte)blue;
                byteBuf[l * 4 + 3] = (byte)alpha;
            }
            return byteBuf;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static BufferedImage readTextureImage(InputStream par1InputStream) throws IOException {
        BufferedImage var2 = ImageIO.read(par1InputStream);
        par1InputStream.close();
        return var2;
    }

    private static BufferedImage scaleBufferedImage(BufferedImage image, int width, int height) {
        BufferedImage scaledImage = new BufferedImage(width, height, 2);
        Graphics2D gr = scaledImage.createGraphics();
        gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        gr.drawImage(image, 0, 0, width, height, null);
        return scaledImage;
    }

    public static int getCountAnimations() {
        if (textureAnimations == null) {
            return 0;
        }
        return textureAnimations.length;
    }

    public static int getCountAnimationsActive() {
        return countAnimationsActive;
    }
}

