/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.optifine.Config;
import net.optifine.config.ConnectedParser;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.shaders.IShaderPack;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.config.MacroProcessor;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.StrUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class EntityAliases {
    private static int[] entityAliases = null;
    private static boolean updateOnResourcesReloaded;

    public static int getEntityAliasId(int entityId) {
        if (entityAliases == null) {
            return -1;
        }
        if (entityId < 0 || entityId >= entityAliases.length) {
            return -1;
        }
        int aliasId = entityAliases[entityId];
        return aliasId;
    }

    public static void resourcesReloaded() {
        if (!updateOnResourcesReloaded) {
            return;
        }
        updateOnResourcesReloaded = false;
        EntityAliases.update((IShaderPack)Shaders.getShaderPack());
    }

    public static void update(IShaderPack shaderPack) {
        EntityAliases.reset();
        if (shaderPack == null) {
            return;
        }
        if (Reflector.ModList.exists() && fgo.Q().ab() == null) {
            Config.dbg((String)"[Shaders] Delayed loading of entity mappings after resources are loaded");
            updateOnResourcesReloaded = true;
            return;
        }
        ArrayList listEntityAliases = new ArrayList();
        String path = "/shaders/entity.properties";
        InputStream in = shaderPack.getResourceAsStream(path);
        if (in != null) {
            EntityAliases.loadEntityAliases((InputStream)in, (String)path, listEntityAliases);
        }
        EntityAliases.loadModEntityAliases(listEntityAliases);
        if (listEntityAliases.size() <= 0) {
            return;
        }
        entityAliases = EntityAliases.toArray(listEntityAliases);
    }

    private static void loadModEntityAliases(List<Integer> listEntityAliases) {
        String[] modIds = ReflectorForge.getForgeModIds();
        for (int i = 0; i < modIds.length; ++i) {
            String modId = modIds[i];
            try {
                akr loc = new akr(modId, "shaders/entity.properties");
                InputStream in = Config.getResourceStream((akr)loc);
                EntityAliases.loadEntityAliases((InputStream)in, (String)loc.toString(), listEntityAliases);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void loadEntityAliases(InputStream in, String path, List<Integer> listEntityAliases) {
        if (in == null) {
            return;
        }
        try {
            in = MacroProcessor.process((InputStream)in, (String)path, (boolean)true);
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            Config.dbg((String)("[Shaders] Parsing entity mappings: " + path));
            ConnectedParser cp = new ConnectedParser("Shaders");
            Set<Object> keys = props.keySet();
            for (String string : keys) {
                String val = props.getProperty(string);
                String prefix = "entity.";
                if (!string.startsWith(prefix)) {
                    Config.warn((String)("[Shaders] Invalid entity ID: " + string));
                    continue;
                }
                String aliasIdStr = StrUtils.removePrefix((String)string, (String)prefix);
                int aliasId = Config.parseInt((String)aliasIdStr, (int)-1);
                if (aliasId < 0) {
                    Config.warn((String)("[Shaders] Invalid entity alias ID: " + aliasId));
                    continue;
                }
                int[] entityIds = cp.parseEntities(val);
                if (entityIds == null || entityIds.length < 1) {
                    Config.warn((String)("[Shaders] Invalid entity ID mapping: " + string + "=" + val));
                    continue;
                }
                for (int i = 0; i < entityIds.length; ++i) {
                    int entityId = entityIds[i];
                    EntityAliases.addToList(listEntityAliases, (int)entityId, (int)aliasId);
                }
            }
        }
        catch (IOException e2) {
            Config.warn((String)("[Shaders] Error reading: " + path));
        }
    }

    private static void addToList(List<Integer> list, int index, int val) {
        while (list.size() <= index) {
            list.add(-1);
        }
        list.set(index, val);
    }

    private static int[] toArray(List<Integer> list) {
        int[] arr = new int[list.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    public static void reset() {
        entityAliases = null;
    }
}

