/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.util.Iterator;
import net.optifine.BlockPosM;
import net.optifine.shaders.IteratorAxis;

public class Iterator3d
implements Iterator<jd> {
    private IteratorAxis iteratorAxis;
    private BlockPosM blockPos = new BlockPosM(0, 0, 0);
    private int axis = 0;
    private int kX;
    private int kY;
    private int kZ;
    private static final int AXIS_X = 0;
    private static final int AXIS_Y = 1;
    private static final int AXIS_Z = 2;

    public Iterator3d(jd posStart, jd posEnd, int width, int height) {
        boolean revX = posStart.u() > posEnd.u();
        boolean revY = posStart.v() > posEnd.v();
        boolean revZ = posStart.w() > posEnd.w();
        posStart = this.reverseCoord(posStart, revX, revY, revZ);
        posEnd = this.reverseCoord(posEnd, revX, revY, revZ);
        this.kX = revX ? -1 : 1;
        this.kY = revY ? -1 : 1;
        this.kZ = revZ ? -1 : 1;
        exc vec = new exc((double)(posEnd.u() - posStart.u()), (double)(posEnd.v() - posStart.v()), (double)(posEnd.w() - posStart.w()));
        exc vecN = vec.d();
        exc vecX = new exc(1.0, 0.0, 0.0);
        double dotX = vecN.b(vecX);
        double dotXabs = Math.abs(dotX);
        exc vecY = new exc(0.0, 1.0, 0.0);
        double dotY = vecN.b(vecY);
        double dotYabs = Math.abs(dotY);
        exc vecZ = new exc(0.0, 0.0, 1.0);
        double dotZ = vecN.b(vecZ);
        double dotZabs = Math.abs(dotZ);
        if (dotZabs >= dotYabs && dotZabs >= dotXabs) {
            this.axis = 2;
            jd pos1 = new jd(posStart.w(), posStart.v() - width, posStart.u() - height);
            jd pos2 = new jd(posEnd.w(), posStart.v() + width + 1, posStart.u() + height + 1);
            int countX = posEnd.w() - posStart.w();
            double deltaY = (double)(posEnd.v() - posStart.v()) / (1.0 * (double)countX);
            double deltaZ = (double)(posEnd.u() - posStart.u()) / (1.0 * (double)countX);
            this.iteratorAxis = new IteratorAxis(pos1, pos2, deltaY, deltaZ);
        } else if (dotYabs >= dotXabs && dotYabs >= dotZabs) {
            this.axis = 1;
            jd pos1 = new jd(posStart.v(), posStart.u() - width, posStart.w() - height);
            jd pos2 = new jd(posEnd.v(), posStart.u() + width + 1, posStart.w() + height + 1);
            int countX = posEnd.v() - posStart.v();
            double deltaY = (double)(posEnd.u() - posStart.u()) / (1.0 * (double)countX);
            double deltaZ = (double)(posEnd.w() - posStart.w()) / (1.0 * (double)countX);
            this.iteratorAxis = new IteratorAxis(pos1, pos2, deltaY, deltaZ);
        } else {
            this.axis = 0;
            jd pos1 = new jd(posStart.u(), posStart.v() - width, posStart.w() - height);
            jd pos2 = new jd(posEnd.u(), posStart.v() + width + 1, posStart.w() + height + 1);
            int countX = posEnd.u() - posStart.u();
            double deltaY = (double)(posEnd.v() - posStart.v()) / (1.0 * (double)countX);
            double deltaZ = (double)(posEnd.w() - posStart.w()) / (1.0 * (double)countX);
            this.iteratorAxis = new IteratorAxis(pos1, pos2, deltaY, deltaZ);
        }
    }

    private jd reverseCoord(jd pos, boolean revX, boolean revY, boolean revZ) {
        if (revX) {
            pos = new jd(-pos.u(), pos.v(), pos.w());
        }
        if (revY) {
            pos = new jd(pos.u(), -pos.v(), pos.w());
        }
        if (revZ) {
            pos = new jd(pos.u(), pos.v(), -pos.w());
        }
        return pos;
    }

    @Override
    public boolean hasNext() {
        return this.iteratorAxis.hasNext();
    }

    @Override
    public jd next() {
        jd pos = this.iteratorAxis.next();
        switch (this.axis) {
            case 0: {
                this.blockPos.setXyz(pos.u() * this.kX, pos.v() * this.kY, pos.w() * this.kZ);
                return this.blockPos;
            }
            case 1: {
                this.blockPos.setXyz(pos.v() * this.kX, pos.u() * this.kY, pos.w() * this.kZ);
                return this.blockPos;
            }
            case 2: {
                this.blockPos.setXyz(pos.w() * this.kX, pos.v() * this.kY, pos.u() * this.kZ);
                return this.blockPos;
            }
        }
        this.blockPos.setXyz(pos.u() * this.kX, pos.v() * this.kY, pos.w() * this.kZ);
        return this.blockPos;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not supported");
    }

    public static void main(String[] args) {
        jd posStart = new jd(10, 20, 30);
        jd posEnd = new jd(30, 40, 20);
        Iterator3d it = new Iterator3d(posStart, posEnd, 1, 1);
        while (it.hasNext()) {
            jd blockPos = it.next();
            System.out.println(String.valueOf(blockPos));
        }
    }
}

