/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.breaker.BlockBreaker;
import com.lothrazar.cyclic.block.cable.energy.TileCableEnergy;
import com.lothrazar.cyclic.capabilities.CustomEnergyStorage;
import com.lothrazar.cyclic.item.datacard.filter.FilterCardItem;
import com.lothrazar.cyclic.net.PacketEnergySync;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilFakePlayer;
import com.lothrazar.cyclic.util.UtilFluid;
import com.lothrazar.cyclic.util.UtilItemStack;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileBlockEntityCyclic
extends BlockEntity
implements Container {
    public static final String NBTINV = "inv";
    public static final String NBTFLUID = "fluid";
    public static final String NBTENERGY = "energy";
    public static final int MENERGY = 64000;
    protected int flowing = 1;
    protected int needsRedstone = 1;
    protected int render = 0;
    protected int timer = 0;

    public TileBlockEntityCyclic(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public int getTimer() {
        return this.timer;
    }

    protected Player getLookingPlayer(int maxRange, boolean mustCrouch) {
        List players = this.f_58857_.m_45976_(Player.class, new AABB((double)(this.f_58858_.m_123341_() - maxRange), (double)(this.f_58858_.m_123342_() - maxRange), (double)(this.f_58858_.m_123343_() - maxRange), (double)(this.f_58858_.m_123341_() + maxRange), (double)(this.f_58858_.m_123342_() + maxRange), (double)(this.f_58858_.m_123343_() + maxRange)));
        for (Player player : players) {
            if (mustCrouch && !player.m_6047_()) continue;
            Vec3 positionEyes = player.m_20299_(1.0f);
            Vec3 look = player.m_20252_(1.0f);
            Vec3 visionWithLength = positionEyes.m_82520_(look.f_82479_ * (double)maxRange, look.f_82480_ * (double)maxRange, look.f_82481_ * (double)maxRange);
            BlockHitResult rayTrace = this.f_58857_.m_45547_(new ClipContext(positionEyes, visionWithLength, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            if (!this.f_58858_.equals((Object)rayTrace.m_82425_())) continue;
            return player;
        }
        return null;
    }

    public void tryDumpFakePlayerInvo(WeakReference<FakePlayer> fp, boolean includeMainHand) {
        int start = includeMainHand ? 0 : 1;
        ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
        for (int i = start; i < ((FakePlayer)fp.get()).m_150109_().f_35974_.size(); ++i) {
            ItemStack s = (ItemStack)((FakePlayer)fp.get()).m_150109_().f_35974_.get(i);
            if (s.m_41619_()) continue;
            toDrop.add(s.m_41777_());
            ((FakePlayer)fp.get()).m_150109_().f_35974_.set(i, (Object)ItemStack.f_41583_);
        }
        UtilItemStack.drop(this.f_58857_, this.f_58858_.m_7494_(), toDrop);
    }

    public static void tryEquipItem(ItemStack item, WeakReference<FakePlayer> fp, InteractionHand hand) {
        if (fp == null) {
            return;
        }
        ((FakePlayer)fp.get()).m_21008_(hand, item);
    }

    public static void syncEquippedItem(LazyOptional<IItemHandler> i, WeakReference<FakePlayer> fp, int slot, InteractionHand hand) {
        if (fp == null) {
            return;
        }
        i.ifPresent(inv -> {
            inv.extractItem(slot, 64, false);
            inv.insertItem(slot, ((FakePlayer)fp.get()).m_21120_(hand), false);
        });
    }

    public static void tryEquipItem(LazyOptional<IItemHandler> i, WeakReference<FakePlayer> fp, int slot, InteractionHand hand) {
        if (fp == null) {
            return;
        }
        i.ifPresent(inv -> {
            ItemStack maybeTool = inv.getStackInSlot(0);
            if (!maybeTool.m_41619_() && maybeTool.m_41613_() <= 0) {
                maybeTool = ItemStack.f_41583_;
            }
            if (!maybeTool.equals(((FakePlayer)fp.get()).m_21120_(hand))) {
                ((FakePlayer)fp.get()).m_21008_(hand, maybeTool);
            }
        });
    }

    public static InteractionResult rightClickBlock(WeakReference<FakePlayer> fakePlayer, Level world, BlockPos targetPos, InteractionHand hand, Direction facing) throws Exception {
        if (fakePlayer == null) {
            return InteractionResult.FAIL;
        }
        Direction placementOn = facing == null ? ((FakePlayer)fakePlayer.get()).m_6374_() : facing;
        BlockHitResult blockraytraceresult = new BlockHitResult(((FakePlayer)fakePlayer.get()).m_20154_(), placementOn, targetPos, true);
        InteractionResult result = ((FakePlayer)fakePlayer.get()).f_8941_.m_7179_((ServerPlayer)fakePlayer.get(), world, ((FakePlayer)fakePlayer.get()).m_21120_(hand), hand, blockraytraceresult);
        return result;
    }

    public static InteractionResult leftClickBlock(WeakReference<FakePlayer> fakePlayer, Level world, BlockPos targetPos, InteractionHand hand, Direction facing) throws Exception {
        if (fakePlayer == null) {
            return InteractionResult.FAIL;
        }
        try {
            ((FakePlayer)fakePlayer.get()).f_8941_.m_7391_(targetPos, ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, facing, world.m_151558_());
            return InteractionResult.SUCCESS;
        }
        catch (Exception e) {
            return InteractionResult.FAIL;
        }
    }

    public static boolean tryHarvestBlock(WeakReference<FakePlayer> fakePlayer, Level world, BlockPos targetPos) {
        if (fakePlayer == null) {
            return false;
        }
        return ((FakePlayer)fakePlayer.get()).f_8941_.m_9280_(targetPos);
    }

    public WeakReference<FakePlayer> setupBeforeTrigger(ServerLevel sw, String name, UUID uuid) {
        WeakReference<FakePlayer> fakePlayer = UtilFakePlayer.initFakePlayer(sw, uuid, name);
        if (fakePlayer == null) {
            ModCyclic.LOGGER.error("Fake player failed to init " + name + " " + uuid);
            return null;
        }
        ((FakePlayer)fakePlayer.get()).m_6034_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_());
        ((FakePlayer)fakePlayer.get()).m_146922_(UtilEntity.getYawFromFacing(this.getCurrentFacing()));
        return fakePlayer;
    }

    public WeakReference<FakePlayer> setupBeforeTrigger(ServerLevel sw, String name) {
        return this.setupBeforeTrigger(sw, name, UUID.randomUUID());
    }

    public void setLitProperty(boolean lit) {
        BlockState st = this.m_58900_();
        if (!st.m_61138_((Property)BlockCyclic.LIT)) {
            return;
        }
        boolean previous = (Boolean)st.m_61143_((Property)BlockBreaker.LIT);
        if (previous != lit) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)st.m_61124_((Property)BlockBreaker.LIT, (Comparable)Boolean.valueOf(lit)));
        }
    }

    public Direction getCurrentFacing() {
        if (this.m_58900_().m_61138_((Property)BlockStateProperties.f_61372_)) {
            return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        }
        if (this.m_58900_().m_61138_((Property)BlockStateProperties.f_61374_)) {
            return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        }
        return null;
    }

    protected BlockPos getCurrentFacingPos(int distance) {
        Direction f = this.getCurrentFacing();
        if (f != null) {
            return this.f_58858_.m_5484_(f, distance);
        }
        return this.f_58858_;
    }

    protected BlockPos getCurrentFacingPos() {
        return this.getCurrentFacingPos(1);
    }

    public CompoundTag m_5995_() {
        CompoundTag syncData = super.m_5995_();
        this.m_183515_(syncData);
        return syncData;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        super.onDataPacket(net, pkt);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean isPowered() {
        return this.m_58904_().m_46753_(this.m_58899_());
    }

    public int getRedstonePower() {
        return this.m_58904_().m_46755_(this.m_58899_());
    }

    public boolean requiresRedstone() {
        return this.needsRedstone == 1;
    }

    public void moveFluids(Direction myFacingDir, BlockPos posTarget, int toFlow, IFluidHandler tank) {
        if (tank == null || tank.getFluidInTank(0).getAmount() <= 0) {
            return;
        }
        Direction themFacingMe = myFacingDir.m_122424_();
        UtilFluid.tryFillPositionFromTank(this.f_58857_, posTarget, themFacingMe, tank, toFlow);
    }

    public void tryExtract(IItemHandler myself, Direction extractSide, int qty, ItemStackHandler nullableFilter) {
        IItemHandler itemHandlerFrom;
        if (extractSide == null) {
            return;
        }
        if (extractSide == null || !myself.getStackInSlot(0).m_41619_()) {
            return;
        }
        BlockPos posTarget = this.f_58858_.m_142300_(extractSide);
        BlockEntity tile = this.f_58857_.m_7702_(posTarget);
        if (tile != null && (itemHandlerFrom = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, extractSide.m_122424_()).orElse(null)) != null) {
            for (int i = 0; i < itemHandlerFrom.getSlots(); ++i) {
                ItemStack itemTarget = itemHandlerFrom.extractItem(i, qty, true);
                if (itemTarget.m_41619_() || nullableFilter != null && !FilterCardItem.filterAllowsExtract(nullableFilter.getStackInSlot(0), itemTarget)) continue;
                itemTarget = itemHandlerFrom.extractItem(i, qty, false);
                ItemStack result = myself.insertItem(0, itemTarget.m_41777_(), false);
                itemTarget.m_41764_(result.m_41613_());
                return;
            }
        }
    }

    public boolean moveItems(Direction myFacingDir, int max, IItemHandler handlerHere) {
        return this.moveItems(myFacingDir, this.f_58858_.m_142300_(myFacingDir), max, handlerHere, 0);
    }

    public boolean moveItems(Direction myFacingDir, BlockPos posTarget, int max, IItemHandler handlerHere, int theslot) {
        if (this.f_58857_.m_5776_()) {
            return false;
        }
        if (handlerHere == null) {
            return false;
        }
        Direction themFacingMe = myFacingDir.m_122424_();
        BlockEntity tileTarget = this.f_58857_.m_7702_(posTarget);
        if (tileTarget == null) {
            return false;
        }
        IItemHandler handlerOutput = (IItemHandler)tileTarget.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, themFacingMe).orElse(null);
        if (handlerOutput == null) {
            return false;
        }
        if (handlerHere != null && handlerOutput != null) {
            int sizeAfter;
            ItemStack drain = handlerHere.extractItem(theslot, max, true);
            int sizeStarted = drain.m_41613_();
            if (!drain.m_41619_()) {
                for (int slot = 0; slot < handlerOutput.getSlots() && !(drain = handlerOutput.insertItem(slot, drain, false)).m_41619_(); ++slot) {
                }
            }
            if ((sizeAfter = sizeStarted - drain.m_41613_()) > 0) {
                handlerHere.extractItem(theslot, sizeAfter, false);
            }
            return sizeAfter > 0;
        }
        return false;
    }

    protected boolean moveEnergy(Direction myFacingDir, int quantity) {
        return this.moveEnergy(myFacingDir, this.f_58858_.m_142300_(myFacingDir), quantity);
    }

    protected boolean moveEnergy(Direction myFacingDir, BlockPos posTarget, int quantity) {
        int drain;
        if (this.f_58857_.f_46443_) {
            return false;
        }
        IEnergyStorage handlerHere = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, myFacingDir).orElse(null);
        if (handlerHere == null || handlerHere.getEnergyStored() == 0) {
            return false;
        }
        if (myFacingDir == null) {
            myFacingDir = Direction.UP;
        }
        Direction themFacingMe = myFacingDir.m_122424_();
        BlockEntity tileTarget = this.f_58857_.m_7702_(posTarget);
        if (tileTarget == null) {
            return false;
        }
        IEnergyStorage handlerOutput = (IEnergyStorage)tileTarget.getCapability(CapabilityEnergy.ENERGY, themFacingMe).orElse(null);
        if (handlerOutput == null) {
            return false;
        }
        if (handlerHere != null && handlerOutput != null && handlerHere.canExtract() && handlerOutput.canReceive() && (drain = handlerHere.extractEnergy(quantity, true)) > 0) {
            int filled = handlerOutput.receiveEnergy(drain, false);
            handlerHere.extractEnergy(filled, false);
            if (filled > 0 && tileTarget instanceof TileCableEnergy) {
                TileCableEnergy cable = (TileCableEnergy)tileTarget;
                cable.updateIncomingEnergyFace(themFacingMe);
            }
            return filled > 0;
        }
        return false;
    }

    public void m_142466_(CompoundTag tag) {
        this.flowing = tag.m_128451_("flowing");
        this.needsRedstone = tag.m_128451_("needsRedstone");
        this.render = tag.m_128451_("renderParticles");
        this.timer = tag.m_128451_("timer");
        super.m_142466_(tag);
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("flowing", this.flowing);
        tag.m_128405_("needsRedstone", this.needsRedstone);
        tag.m_128405_("renderParticles", this.render);
        tag.m_128405_("timer", this.timer);
        super.m_183515_(tag);
    }

    public abstract void setField(int var1, int var2);

    public abstract int getField(int var1);

    public void setNeedsRedstone(int value) {
        this.needsRedstone = value % 2;
    }

    public FluidStack getFluid() {
        return FluidStack.EMPTY;
    }

    public void setFluid(FluidStack fluid) {
    }

    @Deprecated
    public int m_6643_() {
        return 0;
    }

    @Deprecated
    public boolean m_7983_() {
        return true;
    }

    @Deprecated
    public ItemStack m_8020_(int index) {
        return ItemStack.f_41583_;
    }

    @Deprecated
    public ItemStack m_7407_(int index, int count) {
        return ItemStack.f_41583_;
    }

    @Deprecated
    public ItemStack m_8016_(int index) {
        return ItemStack.f_41583_;
    }

    @Deprecated
    public void m_6836_(int index, ItemStack stack) {
    }

    @Deprecated
    public boolean m_6542_(Player player) {
        return false;
    }

    @Deprecated
    public void m_6211_() {
    }

    public void setFieldString(int field, String value) {
    }

    public String getFieldString(int field) {
        return null;
    }

    public int getEnergy() {
        return this.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public void setEnergy(int value) {
        IEnergyStorage energ = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY).orElse(null);
        if (energ != null && energ instanceof CustomEnergyStorage) {
            ((CustomEnergyStorage)energ).setEnergy(value);
        }
    }

    protected void syncEnergy() {
        IEnergyStorage energ;
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 20L == 0L && (energ = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY).orElse(null)) != null) {
            PacketRegistry.sendToAllClients(this.m_58904_(), new PacketEnergySync(this.m_58899_(), energ.getEnergyStored()));
        }
    }

    public void exportEnergyAllSides() {
        List rawList = IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList());
        Collections.shuffle(rawList);
        for (Integer i : rawList) {
            Direction exportToSide = Direction.values()[i];
            this.moveEnergy(exportToSide, 32000);
        }
    }
}

