/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.battery;

import com.lothrazar.cyclic.capabilities.CapabilityProviderEnergyStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemBlockBattery
extends BlockItem {
    public static final String ENERGYTTMAX = "energyttmax";
    public static final String ENERGYTT = "energytt";

    public ItemBlockBattery(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(ENERGYTT);
    }

    public int m_142158_(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(ENERGYTT)) {
            float current = stack.m_41783_().m_128451_(ENERGYTT);
            float max = stack.m_41783_().m_128451_(ENERGYTTMAX);
            return Math.round(13.0f * current / max);
        }
        return 0;
    }

    public int m_142159_(ItemStack stack) {
        return 12192009;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(ENERGYTT)) {
            int current = stack.m_41783_().m_128451_(ENERGYTT);
            int energyttmax = stack.m_41783_().m_128451_(ENERGYTTMAX);
            tooltip.add((Component)new TranslatableComponent(current + "/" + energyttmax).m_130940_(ChatFormatting.RED));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new CapabilityProviderEnergyStack(6400000);
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        if (storage != null) {
            nbt.m_128405_(ENERGYTT, storage.getEnergyStored());
            nbt.m_128405_(ENERGYTTMAX, storage.getMaxEnergyStored());
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, CompoundTag nbt) {
        if (nbt != null) {
            CompoundTag stackTag = stack.m_41784_();
            stackTag.m_128405_(ENERGYTT, nbt.m_128451_(ENERGYTT));
            stackTag.m_128405_(ENERGYTTMAX, nbt.m_128451_(ENERGYTTMAX));
        }
        super.readShareTag(stack, nbt);
    }
}

