/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.hopper;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.hopperfluid.BlockFluidHopper;
import com.lothrazar.cyclic.block.hoppergold.TileGoldHopper;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileSimpleHopper
extends TileBlockEntityCyclic
implements Hopper {
    ItemStackHandler inventory = new ItemStackHandler(1);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public TileSimpleHopper(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.HOPPER.get(), pos, state);
    }

    public TileSimpleHopper(BlockEntityType<TileGoldHopper> t, BlockPos pos, BlockState state) {
        super(t, pos, state);
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileSimpleHopper e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileSimpleHopper e) {
        e.tick();
    }

    public void tick() {
        if (this.isPowered()) {
            return;
        }
        this.tryPullFromWorld(this.f_58858_.m_142300_(Direction.UP));
        this.tryExtract((IItemHandler)this.inventory, Direction.UP, this.getFlow(), null);
        Direction exportToSide = (Direction)this.m_58900_().m_61143_((Property)BlockFluidHopper.FACING);
        this.moveItems(exportToSide, this.getFlow(), (IItemHandler)this.inventory);
    }

    public int getFlow() {
        return 1;
    }

    private int getRadius() {
        return 1;
    }

    private void tryPullFromWorld(BlockPos center) {
        int radius = this.getRadius();
        AABB aabb = new AABB((double)(center.m_123341_() - radius), (double)center.m_123342_(), (double)(center.m_123343_() - radius), (double)(center.m_123341_() + radius + 1), (double)center.m_123342_(), (double)(center.m_123343_() + radius + 1));
        List list = this.f_58857_.m_6443_(ItemEntity.class, aabb, entity -> entity.m_6084_() && !entity.m_32055_().m_41619_());
        if (list.size() > 0) {
            ItemEntity stackEntity = (ItemEntity)list.get(this.f_58857_.f_46441_.nextInt(list.size()));
            ItemStack remainder = stackEntity.m_32055_();
            remainder = this.inventory.insertItem(0, remainder, false);
            stackEntity.m_32045_(remainder);
            if (remainder.m_41619_()) {
                stackEntity.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    public double m_6343_() {
        return this.m_58899_().m_123341_();
    }

    public double m_6358_() {
        return this.m_58899_().m_123342_();
    }

    public double m_6446_() {
        return this.m_58899_().m_123343_();
    }
}

