/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.melter;

import com.google.gson.JsonObject;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.melter.TileMelter;
import com.lothrazar.cyclic.recipe.CyclicRecipe;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.util.UtilRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeMelter<TileEntityBase>
extends CyclicRecipe {
    private NonNullList<Ingredient> ingredients = NonNullList.m_122779_();
    private FluidStack outFluid;
    private final int energy;
    public static final SerializeMelter SERIALMELTER = new SerializeMelter();

    public RecipeMelter(ResourceLocation id, NonNullList<Ingredient> ingredientsIn, FluidStack out, int energyIn) {
        super(id);
        this.ingredients = ingredientsIn;
        if (this.ingredients.size() == 1) {
            this.ingredients.add((Object)Ingredient.f_43901_);
        }
        if (this.ingredients.size() != 2) {
            throw new IllegalArgumentException("Melter recipe must have at most two ingredients");
        }
        this.outFluid = out;
        if (energyIn < 0) {
            energyIn = 0;
        }
        this.energy = energyIn;
    }

    public boolean matches(TileBlockEntityCyclic inv, Level worldIn) {
        try {
            TileMelter tile = (TileMelter)inv;
            boolean matchLeft = this.matches(tile.getStackInputSlot(0), (Ingredient)this.ingredients.get(0));
            boolean matchRight = this.matches(tile.getStackInputSlot(1), (Ingredient)this.ingredients.get(1));
            return matchLeft && matchRight;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean matches(ItemStack current, Ingredient ing) {
        if (ing == Ingredient.f_43901_) {
            return current.m_41619_();
        }
        if (current.m_41619_()) {
            return ing == Ingredient.f_43901_;
        }
        return ing.test(current);
    }

    public ItemStack[] ingredientAt(int slot) {
        Ingredient ing = (Ingredient)this.ingredients.get(slot);
        return ing.m_43908_();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    @Override
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Override
    public FluidStack getRecipeFluid() {
        return this.outFluid.copy();
    }

    public RecipeType<?> m_6671_() {
        return CyclicRecipeType.MELTER;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALMELTER;
    }

    public int getEnergyCost() {
        return this.energy;
    }

    public static class SerializeMelter
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<RecipeMelter<? extends TileBlockEntityCyclic>> {
        SerializeMelter() {
            this.setRegistryName(new ResourceLocation("cyclic", "melter"));
        }

        public RecipeMelter<? extends TileBlockEntityCyclic> fromJson(ResourceLocation recipeId, JsonObject json) {
            RecipeMelter r = null;
            try {
                NonNullList<Ingredient> list = UtilRecipe.getIngredientsArray(json);
                JsonObject result = json.get("result").getAsJsonObject();
                FluidStack fluid = UtilRecipe.getFluid(result);
                int energy = 5000;
                if (json.has("energy")) {
                    energy = json.get("energy").getAsInt();
                }
                r = new RecipeMelter(recipeId, list, fluid, energy);
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Error loading recipe " + recipeId, e);
            }
            return r;
        }

        public RecipeMelter fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            NonNullList ins = NonNullList.m_122779_();
            ins.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            ins.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            return new RecipeMelter(recipeId, (NonNullList<Ingredient>)ins, FluidStack.readFromPacket((FriendlyByteBuf)buffer), buffer.readInt());
        }

        public void toNetwork(FriendlyByteBuf buffer, RecipeMelter recipe) {
            Ingredient zero = (Ingredient)recipe.ingredients.get(0);
            Ingredient one = (Ingredient)recipe.ingredients.get(1);
            zero.m_43923_(buffer);
            one.m_43923_(buffer);
            recipe.outFluid.writeToPacket(buffer);
            buffer.writeInt(recipe.getEnergyCost());
        }
    }
}

