/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.solidifier;

import com.google.gson.JsonObject;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.solidifier.TileSolidifier;
import com.lothrazar.cyclic.recipe.CyclicRecipe;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.recipe.FluidTagIngredient;
import com.lothrazar.cyclic.util.UtilRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeSolidifier<TileEntityBase>
extends CyclicRecipe {
    private ItemStack result = ItemStack.f_41583_;
    private NonNullList<Ingredient> ingredients = NonNullList.m_122779_();
    private final int energy;
    public final FluidTagIngredient fluidIngredient;
    public static final SerializeSolidifier SERIALIZER = new SerializeSolidifier();

    public RecipeSolidifier(ResourceLocation id, NonNullList<Ingredient> inList, FluidTagIngredient fluid, ItemStack result, int energyIn) {
        super(id);
        this.ingredients = inList;
        if (this.ingredients.size() == 2) {
            this.ingredients.add((Object)Ingredient.f_43901_);
        } else if (this.ingredients.size() == 1) {
            this.ingredients.add((Object)Ingredient.f_43901_);
            this.ingredients.add((Object)Ingredient.f_43901_);
        }
        if (this.ingredients.size() != 3) {
            throw new IllegalArgumentException("Solidifier recipe must have at most three ingredients");
        }
        this.fluidIngredient = fluid;
        this.result = result;
        if (energyIn < 0) {
            energyIn = 0;
        }
        this.energy = energyIn;
    }

    @Override
    public FluidStack getRecipeFluid() {
        return this.fluidIngredient.getFluidStack();
    }

    public List<FluidStack> getRecipeFluids() {
        List<Fluid> fluids = this.fluidIngredient.list();
        if (fluids == null) {
            return null;
        }
        ArrayList<FluidStack> me = new ArrayList<FluidStack>();
        for (Fluid f : fluids) {
            me.add(new FluidStack(f, this.fluidIngredient.getFluidStack().getAmount()));
        }
        return me;
    }

    public boolean matches(TileBlockEntityCyclic inv, Level worldIn) {
        try {
            TileSolidifier tile = (TileSolidifier)inv;
            return this.matchItems(tile) && CyclicRecipe.matchFluid(tile.getFluid(), this.fluidIngredient);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private int findMatchingSlot(TileSolidifier tile, Ingredient shapeless, List<Integer> skip) {
        for (int i = 0; i < 3; ++i) {
            if (skip.contains(i) || !shapeless.test(tile.getStackInputSlot(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean matchItems(TileSolidifier tile) {
        Ingredient top = (Ingredient)this.ingredients.get(0);
        Ingredient middle = (Ingredient)this.ingredients.get(1);
        Ingredient bottom = (Ingredient)this.ingredients.get(2);
        ArrayList<Integer> matchingSlots = new ArrayList<Integer>();
        matchingSlots.add(this.findMatchingSlot(tile, top, matchingSlots));
        matchingSlots.add(this.findMatchingSlot(tile, middle, matchingSlots));
        matchingSlots.add(this.findMatchingSlot(tile, bottom, matchingSlots));
        if (matchingSlots.contains(-1)) {
            return false;
        }
        return matchingSlots.contains(0) && matchingSlots.contains(1) && matchingSlots.contains(2);
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public ItemStack[] ingredientAt(int slot) {
        Ingredient ing = (Ingredient)this.ingredients.get(slot);
        return ing.m_43908_();
    }

    @Override
    public ItemStack m_8043_() {
        return this.result.m_41777_();
    }

    public RecipeType<?> m_6671_() {
        return CyclicRecipeType.SOLID;
    }

    public int getEnergyCost() {
        return this.energy;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public static class SerializeSolidifier
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<RecipeSolidifier<? extends TileBlockEntityCyclic>> {
        SerializeSolidifier() {
            this.setRegistryName(new ResourceLocation("cyclic", "solidifier"));
        }

        public RecipeSolidifier<? extends TileBlockEntityCyclic> fromJson(ResourceLocation recipeId, JsonObject json) {
            RecipeSolidifier r = null;
            try {
                NonNullList<Ingredient> list = UtilRecipe.getIngredientsArray(json);
                ItemStack resultStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
                FluidTagIngredient fs = CyclicRecipe.parseFluid(json, "mix");
                int energy = 5000;
                if (json.has("energy")) {
                    energy = json.get("energy").getAsInt();
                }
                r = new RecipeSolidifier(recipeId, list, fs, resultStack, energy);
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Error loading recipe " + recipeId, e);
            }
            return r;
        }

        public RecipeSolidifier fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            NonNullList ins = NonNullList.m_122779_();
            ins.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            ins.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            ins.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            FluidTagIngredient fsi = FluidTagIngredient.readFromPacket(buffer);
            RecipeSolidifier r = new RecipeSolidifier(recipeId, (NonNullList<Ingredient>)ins, fsi, buffer.m_130267_(), buffer.readInt());
            return r;
        }

        public void toNetwork(FriendlyByteBuf buffer, RecipeSolidifier recipe) {
            Ingredient zero = (Ingredient)recipe.ingredients.get(0);
            Ingredient one = (Ingredient)recipe.ingredients.get(1);
            Ingredient two = (Ingredient)recipe.ingredients.get(2);
            zero.m_43923_(buffer);
            one.m_43923_(buffer);
            two.m_43923_(buffer);
            recipe.fluidIngredient.writeToPacket(buffer);
            buffer.m_130055_(recipe.m_8043_());
            buffer.writeInt(recipe.energy);
        }
    }
}

