/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.user;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.user.ContainerUser;
import com.lothrazar.cyclic.capabilities.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileUser
extends TileBlockEntityCyclic
implements MenuProvider {
    public static ForgeConfigSpec.IntValue POWERCONF;
    static final int MAX = 640000;
    ItemStackHandler inventory = new ItemStackHandler(1);
    CustomEnergyStorage energy = new CustomEnergyStorage(640000, 160000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private WeakReference<FakePlayer> fakePlayer;
    private UUID uuid;
    private int timerDelay = 20;
    private boolean useLeftHand = false;

    public TileUser(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.USER.get(), pos, state);
        this.needsRedstone = 1;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileUser e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileUser e) {
        e.tick();
    }

    public void tick() {
        int repair;
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        if (this.f_58857_.f_46443_ || !(this.f_58857_ instanceof ServerLevel)) {
            return;
        }
        if (this.timer > 0) {
            --this.timer;
            return;
        }
        this.timer = this.timerDelay;
        if (this.fakePlayer == null) {
            if (this.uuid == null) {
                this.uuid = UUID.randomUUID();
            }
            this.fakePlayer = this.setupBeforeTrigger((ServerLevel)this.f_58857_, "user", this.uuid);
        }
        if ((repair = ((Integer)POWERCONF.get()).intValue()) > 0) {
            if (this.energy.getEnergyStored() < repair) {
                return;
            }
            this.energy.extractEnergy(repair, false);
        }
        try {
            ItemCooldowns cooldowns = ((FakePlayer)this.fakePlayer.get()).m_36335_();
            Item item = ((FakePlayer)this.fakePlayer.get()).m_21120_(InteractionHand.MAIN_HAND).m_41720_();
            if (cooldowns.m_41519_(item)) {
                cooldowns.m_41527_(item);
            }
            TileBlockEntityCyclic.tryEquipItem(this.inventoryCap, this.fakePlayer, 0, InteractionHand.MAIN_HAND);
            BlockPos target = this.f_58858_.m_142300_(this.getCurrentFacing());
            if (this.useLeftHand) {
                TileBlockEntityCyclic.leftClickBlock(this.fakePlayer, this.f_58857_, target, InteractionHand.MAIN_HAND, this.getCurrentFacing());
            } else {
                TileBlockEntityCyclic.rightClickBlock(this.fakePlayer, this.f_58857_, target, InteractionHand.MAIN_HAND, null);
            }
            TileBlockEntityCyclic.syncEquippedItem(this.inventoryCap, this.fakePlayer, 0, InteractionHand.MAIN_HAND);
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("User action item error", e);
        }
        this.tryDumpFakePlayerInvo(this.fakePlayer, false);
    }

    public boolean isUsingLeftHand() {
        return this.useLeftHand;
    }

    public void setUseLeftHand(boolean useLeftHand) {
        this.useLeftHand = useLeftHand;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TIMER: {
                this.timer = value;
                break;
            }
            case TIMERDEL: {
                this.timerDelay = value;
                break;
            }
            case RENDER: {
                this.render = value % 2;
                break;
            }
            case LEFTHAND: {
                this.useLeftHand = value == 1;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
            case TIMERDEL: {
                return this.timerDelay;
            }
            case RENDER: {
                return this.render;
            }
            case LEFTHAND: {
                return this.isUsingLeftHand() ? 1 : 0;
            }
        }
        return 0;
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        this.energyCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.timerDelay = tag.m_128451_("delay");
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        this.useLeftHand = tag.m_128471_("uselefthand");
        if (tag.m_128441_("uuid")) {
            this.uuid = tag.m_128342_("uuid");
        }
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("delay", this.timerDelay);
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        if (this.uuid != null) {
            tag.m_128362_("uuid", this.uuid);
        }
        tag.m_128379_("uselefthand", this.useLeftHand);
        super.m_183515_(tag);
    }

    public Component m_5446_() {
        return new TextComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerUser(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    static enum Fields {
        REDSTONE,
        TIMER,
        TIMERDEL,
        RENDER,
        LEFTHAND;

    }
}

