/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.compat.jei;

import com.lothrazar.cyclic.block.crusher.RecipeCrusher;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.UtilChat;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class CrusherRecipeCategory
implements IRecipeCategory<RecipeCrusher> {
    private static final int FONT = 0x404040;
    static final ResourceLocation ID = new ResourceLocation(CyclicRecipeType.CRUSHER.toString());
    private IDrawable gui;
    private IDrawable icon;

    public CrusherRecipeCategory(IGuiHelper helper) {
        this.gui = helper.drawableBuilder(new ResourceLocation("cyclic", "textures/jei/crusher.png"), 0, 0, 155, 49).setTextureSize(155, 49).build();
        this.icon = helper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)BlockRegistry.CRUSHER.get()));
    }

    public Component getTitle() {
        return UtilChat.ilang(((Block)BlockRegistry.CRUSHER.get()).m_7705_());
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.gui;
    }

    public Class<? extends RecipeCrusher> getRecipeClass() {
        return RecipeCrusher.class;
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public void setIngredients(RecipeCrusher recipe, IIngredients ingredients) {
        ArrayList in = new ArrayList();
        ArrayList stuff = new ArrayList();
        Collections.addAll(stuff, recipe.ingredientAt(0));
        in.add(stuff);
        ingredients.setInputLists(VanillaTypes.ITEM, in);
        if (recipe.bonus.m_41619_()) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
        } else if (recipe.m_8043_().m_41619_()) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.bonus);
        } else {
            ingredients.setOutputs(VanillaTypes.ITEM, Arrays.asList(recipe.m_8043_(), recipe.bonus));
        }
    }

    public void draw(RecipeCrusher recipe, PoseStack ms, double mouseX, double mouseY) {
        int x = 78;
        if (recipe.getTicks() < 40) {
            Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.getTicks() + " t", (float)x, 6.0f, 0x404040);
        } else {
            int sec = recipe.getTicks() / 20;
            Minecraft.m_91087_().f_91062_.m_92883_(ms, sec + " s", (float)x, 6.0f, 0x404040);
        }
        Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.getRfpertick() + " RF/t", (float)x, 16.0f, 0x404040);
        Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.getRfTotal() + " RF", (float)x, 26.0f, 0x404040);
        if (!recipe.bonus.m_41619_() && recipe.percent > 0) {
            Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.percent + "%", 56.0f, 36.0f, 0x404040);
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, RecipeCrusher recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 2, 13);
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.init(1, false, 34, 5);
        guiItemStacks.set(1, recipe.m_8043_());
        if (!recipe.bonus.m_41619_() && recipe.percent > 0) {
            guiItemStacks.init(2, false, 33, 30);
            guiItemStacks.set(2, recipe.bonus);
        }
    }
}

