/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.compat.jei;

import com.lothrazar.cyclic.block.crusher.ContainerCrusher;
import com.lothrazar.cyclic.block.crusher.ScreenCrusher;
import com.lothrazar.cyclic.block.generatorfluid.ScreenGeneratorFluid;
import com.lothrazar.cyclic.block.generatoritem.ContainerGeneratorDrops;
import com.lothrazar.cyclic.block.generatoritem.ScreenGeneratorDrops;
import com.lothrazar.cyclic.block.melter.ContainerMelter;
import com.lothrazar.cyclic.block.melter.ScreenMelter;
import com.lothrazar.cyclic.block.packager.ScreenPackager;
import com.lothrazar.cyclic.block.solidifier.ContainerSolidifier;
import com.lothrazar.cyclic.block.solidifier.ScreenSolidifier;
import com.lothrazar.cyclic.block.workbench.ContainerWorkbench;
import com.lothrazar.cyclic.compat.jei.CrusherRecipeCategory;
import com.lothrazar.cyclic.compat.jei.GenfluidRecipeCategory;
import com.lothrazar.cyclic.compat.jei.GenitemRecipeCategory;
import com.lothrazar.cyclic.compat.jei.MelterRecipeCategory;
import com.lothrazar.cyclic.compat.jei.PackagerRecipeCategory;
import com.lothrazar.cyclic.compat.jei.SolidifierRecipeCategory;
import com.lothrazar.cyclic.item.crafting.CraftingBagContainer;
import com.lothrazar.cyclic.item.craftingsimple.CraftingStickContainer;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.util.UtilString;
import java.util.Collection;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class CyclicPluginJEI
implements IModPlugin {
    private static final int PLAYER_INV_SIZE = 36;
    private static final ResourceLocation ID = new ResourceLocation("cyclic", "jei");

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new MelterRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SolidifierRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GenitemRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GenfluidRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PackagerRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrusherRecipeCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.PACKAGER.get()), new ResourceLocation[]{PackagerRecipeCategory.ID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.CRAFTER.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ItemRegistry.CRAFTING_BAG.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ItemRegistry.CRAFTING_STICK.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.WORKBENCH.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.MELTER.get()), new ResourceLocation[]{MelterRecipeCategory.ID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.SOLIDIFIER.get()), new ResourceLocation[]{SolidifierRecipeCategory.ID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.GENERATOR_ITEM.get()), new ResourceLocation[]{GenitemRecipeCategory.ID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.GENERATOR_FLUID.get()), new ResourceLocation[]{GenfluidRecipeCategory.ID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.CRUSHER.get()), new ResourceLocation[]{CrusherRecipeCategory.ID});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        ClientLevel world = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        RecipeManager rm = world.m_7465_();
        registry.addRecipes((Collection)rm.m_44013_(RecipeType.f_44107_), PackagerRecipeCategory.ID);
        registry.addRecipes((Collection)rm.m_44013_(CyclicRecipeType.MELTER), MelterRecipeCategory.ID);
        registry.addRecipes((Collection)rm.m_44013_(CyclicRecipeType.SOLID), SolidifierRecipeCategory.ID);
        registry.addRecipes((Collection)rm.m_44013_(CyclicRecipeType.GENERATOR_ITEM), GenitemRecipeCategory.ID);
        registry.addRecipes((Collection)rm.m_44013_(CyclicRecipeType.GENERATOR_FLUID), GenfluidRecipeCategory.ID);
        registry.addRecipes((Collection)rm.m_44013_(CyclicRecipeType.CRUSHER), CrusherRecipeCategory.ID);
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            ItemStack st = new ItemStack((ItemLike)item);
            if (st.m_41619_() || st.m_41720_() instanceof BucketItem || !UtilString.isCyclic(item.getRegistryName())) continue;
            registry.addIngredientInfo((Object)st, VanillaTypes.ITEM, new Component[]{new TranslatableComponent(item.m_5524_() + ".guide")});
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(ScreenMelter.class, 75, 20, 40, 26, new ResourceLocation[]{MelterRecipeCategory.ID});
        registry.addRecipeClickArea(ScreenSolidifier.class, 75, 20, 40, 26, new ResourceLocation[]{SolidifierRecipeCategory.ID});
        registry.addRecipeClickArea(ScreenGeneratorDrops.class, 10, 10, 40, 66, new ResourceLocation[]{GenitemRecipeCategory.ID});
        registry.addRecipeClickArea(ScreenGeneratorFluid.class, 50, 8, 20, 20, new ResourceLocation[]{GenfluidRecipeCategory.ID});
        registry.addRecipeClickArea(ScreenPackager.class, 60, 0, 60, 30, new ResourceLocation[]{PackagerRecipeCategory.ID});
        registry.addRecipeClickArea(ScreenCrusher.class, 50, 0, 40, 30, new ResourceLocation[]{CrusherRecipeCategory.ID});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        registry.addRecipeTransferHandler(ContainerMelter.class, MelterRecipeCategory.ID, 0, 2, 2, 36);
        registry.addRecipeTransferHandler(ContainerSolidifier.class, SolidifierRecipeCategory.ID, 0, 3, 4, 36);
        registry.addRecipeTransferHandler(CraftingBagContainer.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
        registry.addRecipeTransferHandler(CraftingStickContainer.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
        registry.addRecipeTransferHandler(ContainerWorkbench.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
        registry.addRecipeTransferHandler(ContainerGeneratorDrops.class, GenitemRecipeCategory.ID, 0, 1, 1, 36);
        registry.addRecipeTransferHandler(ContainerCrusher.class, CrusherRecipeCategory.ID, 0, 1, 1, 36);
    }
}

