/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.compat.jei;

import com.lothrazar.cyclic.block.generatorfluid.RecipeGeneratorFluid;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.UtilChat;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;

public class GenfluidRecipeCategory
implements IRecipeCategory<RecipeGeneratorFluid> {
    private static final int FONT = 0x404040;
    static final ResourceLocation ID = new ResourceLocation(CyclicRecipeType.GENERATOR_FLUID.toString());
    private IDrawable gui;
    private IDrawable icon;

    public GenfluidRecipeCategory(IGuiHelper helper) {
        this.gui = helper.drawableBuilder(new ResourceLocation("cyclic", "textures/jei/generator_fluid.png"), 0, 0, 118, 32).setTextureSize(118, 32).build();
        this.icon = helper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)BlockRegistry.GENERATOR_FLUID.get()));
    }

    public Component getTitle() {
        return UtilChat.ilang(((Block)BlockRegistry.GENERATOR_FLUID.get()).m_7705_());
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.gui;
    }

    public Class<? extends RecipeGeneratorFluid> getRecipeClass() {
        return RecipeGeneratorFluid.class;
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public void setIngredients(RecipeGeneratorFluid recipe, IIngredients ingredients) {
        if (recipe.getRecipeFluid().isEmpty()) {
            List<FluidStack> matchingFluids = recipe.fluidIng.getMatchingFluids();
            if (matchingFluids != null) {
                ingredients.setInputs(VanillaTypes.FLUID, recipe.fluidIng.getMatchingFluids());
            }
        } else {
            ingredients.setInput(VanillaTypes.FLUID, (Object)recipe.getRecipeFluid());
        }
    }

    public void draw(RecipeGeneratorFluid recipe, PoseStack ms, double mouseX, double mouseY) {
        Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.getTicks() + " t", 60.0f, 0.0f, 0x404040);
        Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.getRfpertick() + " RF/t", 60.0f, 10.0f, 0x404040);
        Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.getRfTotal() + " RF", 60.0f, 20.0f, 0x404040);
    }

    public void setRecipe(IRecipeLayout recipeLayout, RecipeGeneratorFluid recipe, IIngredients ingredients) {
        recipeLayout.getFluidStacks().init(0, true, 6, 7, 16, 16, 1000, false, null);
        if (recipe.fluidIng.hasTag()) {
            List<FluidStack> matchingFluids = recipe.fluidIng.getMatchingFluids();
            if (matchingFluids != null) {
                recipeLayout.getFluidStacks().set(0, matchingFluids);
            }
        } else if (!recipe.getRecipeFluid().isEmpty()) {
            recipeLayout.getFluidStacks().set(0, recipe.getRecipeFluid());
        }
    }
}

