/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.compat.jei;

import com.lothrazar.cyclic.block.generatoritem.RecipeGeneratorItem;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.UtilChat;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class GenitemRecipeCategory
implements IRecipeCategory<RecipeGeneratorItem> {
    private static final int FONT = 0x404040;
    static final ResourceLocation ID = new ResourceLocation(CyclicRecipeType.GENERATOR_ITEM.toString());
    private IDrawable gui;
    private IDrawable icon;

    public GenitemRecipeCategory(IGuiHelper helper) {
        this.gui = helper.drawableBuilder(new ResourceLocation("cyclic", "textures/jei/generator_item.png"), 0, 0, 118, 32).setTextureSize(118, 32).build();
        this.icon = helper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)BlockRegistry.GENERATOR_ITEM.get()));
    }

    public Component getTitle() {
        return UtilChat.ilang(((Block)BlockRegistry.GENERATOR_ITEM.get()).m_7705_());
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.gui;
    }

    public Class<? extends RecipeGeneratorItem> getRecipeClass() {
        return RecipeGeneratorItem.class;
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public void setIngredients(RecipeGeneratorItem recipe, IIngredients ingredients) {
        ArrayList in = new ArrayList();
        ArrayList stuff = new ArrayList();
        Collections.addAll(stuff, recipe.ingredientAt(0));
        in.add(stuff);
        ingredients.setInputLists(VanillaTypes.ITEM, in);
    }

    public void draw(RecipeGeneratorItem recipe, PoseStack ms, double mouseX, double mouseY) {
        Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.getTicks() + " t", 60.0f, 0.0f, 0x404040);
        Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.getRfpertick() + " RF/t", 60.0f, 10.0f, 0x404040);
        Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.getRfTotal() + " RF", 60.0f, 20.0f, 0x404040);
    }

    public void setRecipe(IRecipeLayout recipeLayout, RecipeGeneratorItem recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 5, 6);
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        guiItemStacks.set(0, (List)inputs.get(0));
    }
}

