/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.compat.jei;

import com.lothrazar.cyclic.block.solidifier.RecipeSolidifier;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.UtilChat;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;

public class SolidifierRecipeCategory
implements IRecipeCategory<RecipeSolidifier> {
    private static final int FONT = 0x404040;
    static final ResourceLocation ID = new ResourceLocation(CyclicRecipeType.SOLID.toString());
    private IDrawable gui;
    private IDrawable icon;

    public SolidifierRecipeCategory(IGuiHelper helper) {
        this.gui = helper.drawableBuilder(new ResourceLocation("cyclic", "textures/jei/solidifier_recipe.png"), 0, 0, 169, 69).setTextureSize(169, 69).build();
        this.icon = helper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)BlockRegistry.SOLIDIFIER.get()));
    }

    public Component getTitle() {
        return UtilChat.ilang(((Block)BlockRegistry.SOLIDIFIER.get()).m_7705_());
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.gui;
    }

    public Class<? extends RecipeSolidifier> getRecipeClass() {
        return RecipeSolidifier.class;
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public void setIngredients(RecipeSolidifier recipe, IIngredients ingredients) {
        if (recipe.getRecipeFluid().isEmpty()) {
            List<FluidStack> matchingFluids = recipe.fluidIngredient.getMatchingFluids();
            if (matchingFluids != null) {
                ingredients.setInputs(VanillaTypes.FLUID, recipe.fluidIngredient.getMatchingFluids());
            }
        } else {
            ingredients.setInput(VanillaTypes.FLUID, (Object)recipe.getRecipeFluid());
        }
        ArrayList in = new ArrayList();
        ArrayList stuff = new ArrayList();
        Collections.addAll(stuff, recipe.ingredientAt(0));
        in.add(stuff);
        stuff = new ArrayList();
        Collections.addAll(stuff, recipe.ingredientAt(1));
        in.add(stuff);
        stuff = new ArrayList();
        Collections.addAll(stuff, recipe.ingredientAt(2));
        in.add(stuff);
        ingredients.setInputLists(VanillaTypes.ITEM, in);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
    }

    public void draw(RecipeSolidifier recipe, PoseStack ms, double mouseX, double mouseY) {
        Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.getEnergyCost() + " RF", 60.0f, 20.0f, 0x404040);
    }

    public void setRecipe(IRecipeLayout recipeLayout, RecipeSolidifier recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 33, 6);
        guiItemStacks.init(1, true, 33, 24);
        guiItemStacks.init(2, true, 33, 42);
        guiItemStacks.init(3, false, 104, 24);
        guiItemStacks.set(3, recipe.m_8043_());
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List input = null;
        for (int i = 0; i <= 2; ++i) {
            input = (List)inputs.get(i);
            if (input == null || input.isEmpty()) continue;
            guiItemStacks.set(i, input);
        }
        recipeLayout.getFluidStacks().init(0, true, 4, 25, 16, 16, 1000, false, null);
        if (recipe.fluidIngredient.hasTag()) {
            List<FluidStack> matchingFluids = recipe.fluidIngredient.getMatchingFluids();
            if (matchingFluids != null) {
                recipeLayout.getFluidStacks().set(0, matchingFluids);
            }
        } else if (!recipe.getRecipeFluid().isEmpty()) {
            recipeLayout.getFluidStacks().set(0, recipe.getRecipeFluid());
        }
    }
}

