/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.lothrazar.cyclic.CyclicLogger;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.CandlePeaceBlock;
import com.lothrazar.cyclic.block.CandleWaterBlock;
import com.lothrazar.cyclic.block.LavaSpongeBlock;
import com.lothrazar.cyclic.block.PeatBlock;
import com.lothrazar.cyclic.block.anvil.TileAnvilAuto;
import com.lothrazar.cyclic.block.anvilmagma.TileAnvilMagma;
import com.lothrazar.cyclic.block.anvilvoid.TileAnvilVoid;
import com.lothrazar.cyclic.block.beaconpotion.TilePotion;
import com.lothrazar.cyclic.block.cable.energy.TileCableEnergy;
import com.lothrazar.cyclic.block.cable.fluid.TileCableFluid;
import com.lothrazar.cyclic.block.collectfluid.TileFluidCollect;
import com.lothrazar.cyclic.block.crafter.TileCrafter;
import com.lothrazar.cyclic.block.disenchant.TileDisenchant;
import com.lothrazar.cyclic.block.dropper.TileDropper;
import com.lothrazar.cyclic.block.enderctrl.EnderShelfHelper;
import com.lothrazar.cyclic.block.endershelf.EnderShelfItemHandler;
import com.lothrazar.cyclic.block.eye.TileEye;
import com.lothrazar.cyclic.block.eyetp.TileEyeTp;
import com.lothrazar.cyclic.block.forester.TileForester;
import com.lothrazar.cyclic.block.generatorfood.TileGeneratorFood;
import com.lothrazar.cyclic.block.generatorfuel.TileGeneratorFuel;
import com.lothrazar.cyclic.block.harvester.TileHarvester;
import com.lothrazar.cyclic.block.miner.TileMiner;
import com.lothrazar.cyclic.block.packager.TilePackager;
import com.lothrazar.cyclic.block.peatfarm.TilePeatFarm;
import com.lothrazar.cyclic.block.shapebuilder.TileStructure;
import com.lothrazar.cyclic.block.soundrecord.BlockSoundRecorder;
import com.lothrazar.cyclic.block.sprinkler.TileSprinkler;
import com.lothrazar.cyclic.block.terrasoil.TileTerraPreta;
import com.lothrazar.cyclic.block.tp.BlockTeleport;
import com.lothrazar.cyclic.block.uncrafter.TileUncraft;
import com.lothrazar.cyclic.block.user.TileUser;
import com.lothrazar.cyclic.config.ClientConfigCyclic;
import com.lothrazar.cyclic.enchant.AutoSmeltEnchant;
import com.lothrazar.cyclic.enchant.BeekeeperEnchant;
import com.lothrazar.cyclic.enchant.BeheadingEnchant;
import com.lothrazar.cyclic.enchant.CurseEnchant;
import com.lothrazar.cyclic.enchant.DisarmEnchant;
import com.lothrazar.cyclic.enchant.ElytraLaunchEnchant;
import com.lothrazar.cyclic.enchant.ExcavationEnchant;
import com.lothrazar.cyclic.enchant.GrowthEnchant;
import com.lothrazar.cyclic.enchant.LifeLeechEnchant;
import com.lothrazar.cyclic.enchant.MagnetEnchant;
import com.lothrazar.cyclic.enchant.Multishot;
import com.lothrazar.cyclic.enchant.PearlEnchant;
import com.lothrazar.cyclic.enchant.QuickdrawEnchant;
import com.lothrazar.cyclic.enchant.ReachEnchant;
import com.lothrazar.cyclic.enchant.StandEnchant;
import com.lothrazar.cyclic.enchant.StepEnchant;
import com.lothrazar.cyclic.enchant.TravellerEnchant;
import com.lothrazar.cyclic.enchant.VenomEnchant;
import com.lothrazar.cyclic.enchant.XpEnchant;
import com.lothrazar.cyclic.item.EdibleFlightItem;
import com.lothrazar.cyclic.item.EdibleSpecItem;
import com.lothrazar.cyclic.item.OreProspector;
import com.lothrazar.cyclic.item.TeleporterWandItem;
import com.lothrazar.cyclic.item.bauble.AutoCaveTorchItem;
import com.lothrazar.cyclic.item.bauble.AutoTorchItem;
import com.lothrazar.cyclic.item.bauble.CharmBase;
import com.lothrazar.cyclic.item.findspawner.ItemProjectileDungeon;
import com.lothrazar.cyclic.item.heart.HeartItem;
import com.lothrazar.cyclic.item.heart.HeartToxicItem;
import com.lothrazar.cyclic.item.transporter.TileTransporterEmptyItem;
import com.lothrazar.cyclic.registry.CommandRegistry;
import com.lothrazar.cyclic.registry.WorldGenRegistry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigRegistry {
    private static final ForgeConfigSpec.Builder CFG = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder CFGC = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec COMMON_CONFIG;
    private static ForgeConfigSpec CLIENT_CONFIG;
    private static final List<String> BEHEADING;
    private static final List<String> UNCRAFT_IGNORE_ITEMS;
    private static final List<String> MBALL_IGNORE;
    private static final List<String> UNCRAFT_RECIPE_IDS;
    private static final List<String> TRANSPORTBAG;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> BEHEADING_SKINS;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> MBALL_IGNORE_LIST;
    private static final String WALL = "####################################################################################";

    private static void buildDefaults() {
        BEHEADING.add("minecraft:blaze:MHF_Blaze");
        BEHEADING.add("minecraft:cat:MHF_Ocelot");
        BEHEADING.add("minecraft:cave_spider:MHF_CaveSpider");
        BEHEADING.add("minecraft:chicken:MHF_Chicken");
        BEHEADING.add("minecraft:cow:MHF_Cow");
        BEHEADING.add("minecraft:enderman:MHF_Enderman");
        BEHEADING.add("minecraft:ghast:MHF_Ghast");
        BEHEADING.add("minecraft:iron_golem:MHF_Golem");
        BEHEADING.add("minecraft:magma_cube:MHF_LavaSlime");
        BEHEADING.add("minecraft:mooshroom:MHF_MushroomCow");
        BEHEADING.add("minecraft:ocelot:MHF_Ocelot");
        BEHEADING.add("minecraft:pig:MHF_Pig");
        BEHEADING.add("minecraft:zombie_pigman:MHF_PigZombie");
        BEHEADING.add("minecraft:sheep:MHF_Sheep");
        BEHEADING.add("minecraft:slime:MHF_Slime");
        BEHEADING.add("minecraft:spider:MHF_Spider");
        BEHEADING.add("minecraft:squid:MHF_Squid");
        BEHEADING.add("minecraft:villager:MHF_Villager");
        BEHEADING.add("minecraft:witch:MHF_Witch");
        BEHEADING.add("minecraft:wolf:MHF_Wolf");
        BEHEADING.add("minecraft:guardian:MHF_Guardian");
        BEHEADING.add("minecraft:elder_guardian:MHF_Guardian");
        BEHEADING.add("minecraft:snow_golem:MHF_SnowGolem");
        BEHEADING.add("minecraft:silverfish:MHF_Silverfish");
        BEHEADING.add("minecraft:endermite:MHF_Endermite");
        UNCRAFT_IGNORE_ITEMS.add("minecraft:elytra");
        UNCRAFT_IGNORE_ITEMS.add("minecraft:tipped_arrow");
        UNCRAFT_IGNORE_ITEMS.add("minecraft:magma_block");
        UNCRAFT_IGNORE_ITEMS.add("minecraft:stick");
        UNCRAFT_IGNORE_ITEMS.add("minecraft:*_dye");
        UNCRAFT_IGNORE_ITEMS.add("spectrite:spectrite_arrow");
        UNCRAFT_IGNORE_ITEMS.add("spectrite:spectrite_arrow_special");
        UNCRAFT_IGNORE_ITEMS.add("techreborn:uumatter");
        UNCRAFT_IGNORE_ITEMS.add("projecte:*");
        UNCRAFT_RECIPE_IDS.add("botania:cobweb");
        UNCRAFT_RECIPE_IDS.add("minecraft:magma_cream");
        UNCRAFT_RECIPE_IDS.add("minecraft:beacon");
        UNCRAFT_RECIPE_IDS.add("minecraft:stick_from_bamboo_item");
        UNCRAFT_RECIPE_IDS.add("minecraft:netherite_ingot_from_netherite_block");
        UNCRAFT_RECIPE_IDS.add("mysticalagriculture:essence*");
        UNCRAFT_RECIPE_IDS.add("mysticalagriculture:farmland_till");
        UNCRAFT_RECIPE_IDS.add("refinedstorage:coloring_recipes*");
        UNCRAFT_RECIPE_IDS.add("forcecraft:transmutation*");
        TRANSPORTBAG.addAll(Arrays.asList("parabox:parabox", "extracells:fluidcrafter", "extracells:ecbaseblock", "extracells:fluidfiller", "exnihilosequentia:*", "refinedstorage:*", "tconstruct:seared_fuel_tank", "tconstruct:smeltery_controller", "tconstruct:seared_drain", "tconstruct:seared_fuel_gauge", "tconstruct:seared_ingot_tank", "tconstruct:seared_ingot_gauge", "tconstruct:seared_melter", "tconstruct:seared_heater", "tconstruct:scorched_drain", "tconstruct:scorched_duct", "tconstruct:scorched_chute", "tconstruct:foundry_controller", "tconstruct:scorched_alloyer", "rftoolspower:cell3", "rftoolspower:cell2", "rftoolspower:cell1", "rftoolspower:cell3", "rftoolspower:cell2", "rftoolspower:cell1"));
        MBALL_IGNORE.add("minecraft:ender_dragon");
        MBALL_IGNORE.add("minecraft:wither");
    }

    private static void initConfig() {
        CFG.comment(new String[]{WALL, "Features with configurable properties are split into categories", WALL}).push("cyclic");
        CFG.comment(new String[]{WALL, " Enchantment related configs", WALL}).push("enchantment");
        AutoSmeltEnchant.CFG = CFG.comment("Set false to disable enchantment").define("auto_smelt.enabled", true);
        BeekeeperEnchant.CFG = CFG.comment("Set false to disable enchantment").define("beekeeper.enabled", true);
        BeheadingEnchant.CFG = CFG.comment("Set false to disable enchantment").define("beheading.enabled", true);
        CurseEnchant.CFG = CFG.comment("Set false to disable enchantment").define("curse.enabled", true);
        DisarmEnchant.CFG = CFG.comment("Set false to disable enchantment").define("disarm.enabled", true);
        ExcavationEnchant.CFG = CFG.comment("Set false to disable enchantment").define("excavate.enabled", true);
        GrowthEnchant.CFG = CFG.comment("Set false to disable enchantment").define("growth.enabled", true);
        ElytraLaunchEnchant.CFG = CFG.comment("Set false to disable Multi Jump enchantment").define("launch.enabled", true);
        LifeLeechEnchant.CFG = CFG.comment("Set false to disable enchantment").define("life_leech.enabled", true);
        MagnetEnchant.CFG = CFG.comment("Set false to disable enchantment").define("magnet.enabled", true);
        Multishot.CFG = CFG.comment("Set false to disable enchantment").define("multishot.enabled", true);
        PearlEnchant.CFG = CFG.comment("Set false to disable enchantment").define("ender.enabled", true);
        QuickdrawEnchant.CFG = CFG.comment("Set false to disable enchantment").define("quickshot.enabled", true);
        ReachEnchant.CFG = CFG.comment("Set false to disable enchantment").define("reach.enabled", true);
        StepEnchant.CFG = CFG.comment("Set false to disable enchantment").define("step.enabled", true);
        StandEnchant.CFG = CFG.comment("Set false to disable enchantment").define("laststand.enabled", true);
        StandEnchant.COST = CFG.comment("Base XP cost to activate at level 1 (level 2 is this/2)").defineInRange("laststand.xp_cost", 50, 1, 9999);
        StandEnchant.ABS = CFG.comment("How many ticks of Absorption hearts given on trigger, 0 to disable").defineInRange("laststand.potion_ticks", 600, 0, 9999);
        StandEnchant.COOLDOWN = CFG.comment("How many ticks of cooldown, 0 to disable").defineInRange("laststand.cooldown", 20, 0, 99999);
        TravellerEnchant.CFG = CFG.comment("Set false to disable enchantment").define("traveler.enabled", true);
        VenomEnchant.CFG = CFG.comment("Set false to disable enchantment").define("venom.enabled", true);
        XpEnchant.CFG = CFG.comment("Set false to disable enchantment").define("experience_boost.enabled", true);
        BEHEADING_SKINS = CFG.comment("Beheading enchant add player skin head drop, add any mob id and any skin").defineList("beekeeper.EntityMHF", BEHEADING, it -> it instanceof String);
        CFG.pop();
        CFG.comment(new String[]{WALL, " Worldgen settings  ", WALL}).push("worldgen");
        WorldGenRegistry.GENERATES = CFG.comment("Do the four generate in the world.  If false, the 4 flower blocks and 3 features (flower_all, flower_tulip_ flower_lime) will still be registered and can be used externally (data packs etc), but the mod will not use the features to generate/place flowers in world-generation").define("flowers.enabled", true);
        CFG.pop();
        CFG.comment(new String[]{WALL, " Edit the permissions of all commands added by the mod.  false means anyone can use, true means only OP players can use  ", WALL}).push("command");
        CommandRegistry.COMMANDGETHOME = CFG.comment("True means only players with OP can use this /cyclic command").define(CommandRegistry.CyclicCommands.GETHOME.toString(), false);
        CommandRegistry.COMMANDHEALTH = CFG.comment("True means only players with OP can use this /cyclic command").define(CommandRegistry.CyclicCommands.HEALTH.toString(), true);
        CommandRegistry.COMMANDHOME = CFG.comment("True means only players with OP can use this /cyclic command").define(CommandRegistry.CyclicCommands.HOME.toString(), true);
        CommandRegistry.COMMANDHUNGER = CFG.comment("True means only players with OP can use this /cyclic command").define(CommandRegistry.CyclicCommands.HUNGER.toString(), true);
        CommandRegistry.COMMANDDEV = CFG.comment("True means only players with OP can use this /cyclic command").define(CommandRegistry.CyclicCommands.DEV.toString(), false);
        CommandRegistry.COMMANDPING = CFG.comment("True means only players with OP can use this /cyclic command").define(CommandRegistry.CyclicCommands.PING.toString(), false);
        CFG.pop();
        CFG.comment(new String[]{WALL, " Logging related configs", WALL}).push("logging");
        CyclicLogger.LOGINFO = CFG.comment("Unblock info logs; very spammy; can be useful for testing certain issues").define("info", false);
        CFG.pop();
        CFG.comment(new String[]{WALL, " Item specific configs", WALL}).push("items");
        OreProspector.RANGE = CFG.comment("Ore Prospector radius around player to search for ores").defineInRange("prospector.range", 32, 1, 256);
        ItemProjectileDungeon.RANGE = CFG.comment("Range in all directions to search for spawner").defineInRange("spawner_seeker.range", 64, 1, 256);
        AutoTorchItem.LIGHT_LEVEL = CFG.comment("Light level limit for placing torches").defineInRange("charm_torch.light_level", 9, 0, 15);
        CharmBase.CHARM_LUCK = CFG.comment("Boost given by item charm_luck").defineInRange("charm_luck.boost", 10, 0, 100);
        CharmBase.CHARM_SPEED = CFG.comment("Boost given by item charm_speed").defineInRange("charm_speed.boost", 0.5, 0.0, 2.0);
        CharmBase.CHARM_ATTACKSPEED = CFG.comment("Boost given by item charm_attackspeed").defineInRange("charm_attack_speed.boost", 0.5, 0.0, 2.0);
        CFG.comment(" Caving Torch Charm settings").push("caving_torch");
        AutoCaveTorchItem.LIGHT_LIMIT = CFG.comment("Light level at which to start placing down a torch").defineInRange("light_limit", 7, 0, 13);
        AutoCaveTorchItem.LIGHT_TARGET = CFG.comment(new String[]{"Light level of the current block after placing down a torch. Must be greater than light_limit", "Higher values means torches will be placed closer to you. Lower values means torches will overlap less,", "but might result in small dark spots between torches"}).defineInRange("light_target", 10, 1, 14);
        AutoCaveTorchItem.PREFER_WALLS = CFG.comment("Whether to prioritise placing torches on walls").define("prefer_walls", true);
        AutoCaveTorchItem.PREFER_LEFT_WALL = CFG.comment(new String[]{"Which wall to place torches on when digging a 1-wide tunnel", "True means left, False means right"}).define("prefer_left_wall", false);
        CFG.pop();
        EdibleFlightItem.TICKS = CFG.comment("Seconds of flight per chorus_flight").defineInRange("chorus_flight.ticks", 1200, 1, 20000);
        EdibleSpecItem.TICKS = CFG.comment("Seconds of noClip per chorus_spectral").defineInRange("chorus_spectral.ticks", 600, 1, 20000);
        MBALL_IGNORE_LIST = CFG.comment("Entity ids that cannot be picked up with the Monster all").defineList("monster_ball.ignore_list", MBALL_IGNORE, it -> it instanceof String);
        CFG.comment("Wand settings").push("teleport_wand");
        TeleporterWandItem.RANGE = CFG.comment("Maximum distance to activate").defineInRange("range", 256, 8, 1024);
        CFG.pop();
        CFG.comment("Sack of Holding settings").push("tile_transporter");
        TileTransporterEmptyItem.IGNORELIST = CFG.comment("Block these from being picked up").defineList("disable_pickup", TRANSPORTBAG, it -> it instanceof String);
        CFG.pop();
        CFG.comment("Heart items").push("heart");
        HeartToxicItem.HEARTXPMINUS = CFG.comment("Experience given when eating a poisoned heart").defineInRange("experience", 500, 0, 99999);
        HeartItem.MAX = CFG.comment("Maximum number of hearts that can be attained (including initial 10)").defineInRange("maximum", 100, 1, 200);
        CFG.pop();
        CFG.pop();
        CFG.comment(new String[]{WALL, " Block specific configs", WALL}).push("blocks");
        TileCableFluid.BUFFERSIZE = CFG.comment("How many buckets of buffer fluid the fluid cable can hold (for each direction. for example 2 here means 2000ub in each face)").defineInRange("cables.fluid.buffer", 16, 1, 32);
        TileCableFluid.TRANSFER_RATE = CFG.comment("How many fluid units per tick can flow through these cables each tick (1 bucket = 1000) including normal flow and extraction mode").defineInRange("cables.fluid.flow", 1000, 100, 32000);
        TileCableEnergy.BUFFERSIZE = CFG.comment("How much buffer the energy cables hold (must not be smaller than flow)").defineInRange("cables.energy.buffer", 32000, 1, 128000);
        TileCableEnergy.TRANSFER_RATE = CFG.comment("How fast energy flows in these cables (must not be greater than buffer)").defineInRange("cables.energy.flow", 1000, 100, 32000);
        TileGeneratorFuel.RF_PER_TICK = CFG.comment("RF energy per tick generated while burning furnace fuel in this machine.  Burn time in ticks is the same as furnace values, so 1 coal = 1600 ticks").defineInRange("generator_fuel.rf_per_tick", 80, 1, 6400);
        TileGeneratorFood.RF_PER_TICK = CFG.comment("RF energy per tick generated while burning food in this machine").defineInRange("generator_food.rf_per_tick", 60, 1, 6400);
        TileGeneratorFood.TICKS_PER_FOOD = CFG.comment("This [factor * (item.food + item.saturation) = ticks] results in the number of ticks food will burn at. IE Bread has (5 + 0.6) with factor 100, will burn for 560 ticks.").defineInRange("generator_food.ticks_per_food", 100, 1, 6400);
        LavaSpongeBlock.RADIUS = CFG.comment("Reach of the sponge").defineInRange("sponge_lava.radius", 8, 1, 64);
        CandlePeaceBlock.HEIGHT = CFG.comment("Height reach of the candle for spawn prevention").defineInRange("peace_candle.height", 8, 1, 128);
        CandlePeaceBlock.RADIUS = CFG.comment("Reach of the candle for spawn prevention").defineInRange("peace_candle.radius", 32, 1, 128);
        CandleWaterBlock.RADIUS = CFG.comment("Reach of the candle").defineInRange("water_candle.radius", 8, 1, 64);
        CandleWaterBlock.TICK_RATE = CFG.comment("Tick rate of the candle").defineInRange("water_candle.tick_rate", 60, 1, 2000);
        TilePackager.POWERCONF = CFG.comment("Power per recipe in the packager").defineInRange("packager.energy_cost", 50, 0, 64000);
        TileUser.POWERCONF = CFG.comment("Power per use user").defineInRange("user.energy_cost", 0, 0, 64000);
        TileAnvilAuto.POWERCONF = CFG.comment("Power per repair anvil").defineInRange("anvil.energy_cost", 250, 0, 64000);
        TileDropper.POWERCONF = CFG.comment("Power per use dropper").defineInRange("dropper.energy_cost", 50, 0, 64000);
        TileForester.POWERCONF = CFG.comment("Power per use forester").defineInRange("forester.energy_cost", 50, 0, 64000);
        TileHarvester.POWERCONF = CFG.comment("Power per use harvester").defineInRange("harvester.energy_cost", 250, 0, 64000);
        TilePotion.POWERCONF = CFG.comment("Power per tick beacon").defineInRange("beacon.energy_cost", 10, 0, 64000);
        TileMiner.POWERCONF = CFG.comment("Power per use miner").defineInRange("miner.energy_cost", 10, 0, 64000);
        TileUncraft.POWERCONF = CFG.comment("Power per use uncraft").defineInRange("uncraft.energy_cost", 1000, 0, 64000);
        TileFluidCollect.POWERCONF = CFG.comment("Power per use collector_fluid").defineInRange("collector_fluid.energy_cost", 500, 0, 64000);
        TilePeatFarm.POWERCONF = CFG.comment("Power per use peat_farm").defineInRange("peat_farm.energy_cost", 500, 0, 64000);
        TileCrafter.POWERCONF = CFG.comment("Power per use crafter").defineInRange("crafter.energy_cost", 500, 0, 64000);
        TileStructure.POWERCONF = CFG.comment("Power per tick while in use").defineInRange("structure.energy_cost", 10, 0, 64000);
        BlockTeleport.POWERCONF = CFG.comment("Power per use").defineInRange("teleport.energy_cost", 400, 0, 64000);
        BlockTeleport.COSTDIM = CFG.comment("Power per use while crossing dimensions").defineInRange("teleport.energy_cost_xdim", 8000, 0, 64000);
        TilePotion.POWERCONF = CFG.comment("Power per tick while in use").defineInRange("beacon.energy_cost", 0, 0, 64000);
        PeatBlock.PEATCHANCE = CFG.comment("Chance that Peat Bog converts to Peat when wet (is multiplied by the number of surrounding water blocks)").defineInRange("peat.conversion_chance", (double)0.08f, (double)0.001f, 1.0);
        TileAnvilMagma.FLUIDCOST = CFG.comment("Cost of magma fluid per action").defineInRange("anvil_magma.fluid_cost", 100, 1, 64000);
        CFG.push("disenchanter");
        TileDisenchant.FLUIDCOST = CFG.comment("Cost of (or payment for if negative) per enchanted book generated").defineInRange("fluid_cost", 100, -1000, 16000);
        TileDisenchant.POWERCONF = CFG.comment("Power per use disenchanter").defineInRange("energy_cost", 2500, 0, 64000);
        CFG.pop();
        CFG.push("terra_preta");
        TileTerraPreta.TIMER_FULL = CFG.comment("Growth interval in ticks (100 would be every 5 seconds). Also affects terra glass").defineInRange("growth_interval", 100, 1, 64000);
        TileTerraPreta.CHANCE = CFG.comment("Chance that the crop will grow after the interval").defineInRange("growth_chance", 0.5, 0.0, 1.0);
        CFG.pop();
        CFG.push("anvil_void");
        TileAnvilVoid.FLUIDPAY = CFG.comment("Payment per void action, if not zero").defineInRange("fluid_cost", 25, 0, 16000);
        CFG.pop();
        CFG.push("sound");
        BlockSoundRecorder.RADIUS = CFG.comment("Sound Recorder - how far out does it listen to record sounds").defineInRange("radius", 8, 1, 64);
        CFG.pop();
        CFG.push("ender_shelf");
        EnderShelfItemHandler.BOOKS_PER_ROW = CFG.comment("Each shelf has five rows.  Set the number of books stored per row here").defineInRange("books_per_row", 64, 1, 64);
        EnderShelfHelper.MAX_DIST = CFG.comment("Controller Max distance to search (using manhattan distance)").defineInRange("controller_distance", 64, 1, 256);
        CFG.pop();
        CFG.push("sprinkler");
        TileSprinkler.WATERCOST = CFG.comment("Water consumption").defineInRange("water", 5, 0, 1000);
        TileSprinkler.TIMER_FULL = CFG.comment("Tick rate.  20 will fire one block per second").defineInRange("ticks", 20, 1, 20);
        CFG.pop();
        CFG.comment("Ender Anchor settings").push("eye_teleport");
        TileEyeTp.RANGE = CFG.comment("Maximum distance to activate").defineInRange("range", 128, 2, 256);
        TileEyeTp.HUNGER = CFG.comment("Hunger cost on teleport").defineInRange("hunger", 1, 0, 20);
        TileEyeTp.EXP = CFG.comment("Exp cost on teleport").defineInRange("exp", 0, 0, 500);
        TileEyeTp.FREQUENCY = CFG.comment("Tick delay between checks, faster checks can consume server resources (1 means check every tick; 20 means only check once per second)").defineInRange("frequency", 5, 1, 20);
        CFG.pop();
        CFG.comment("Ender Trigger settings").push("eye_redstone");
        TileEye.RANGE = CFG.comment("Maximum distance to activate").defineInRange("range", 32, 2, 256);
        TileEye.FREQUENCY = CFG.comment("Tick delay between checks, faster checks can consume server resources (1 means check every tick; 20 means only check once per second)").defineInRange("frequency", 5, 1, 20);
        CFG.pop();
        CFG.push("uncrafter");
        TileUncraft.IGNORE_NBT = CFG.comment("When searching for a recipe, does it ignore all NBT values (such as enchantments, RepairCost, Damage, etc).  For example, if false it will not uncraft damaged or enchanted items").define("nbt_ignored", false);
        TileUncraft.IGNORELIST = CFG.comment("ITEM IDS HERE.  Block ALL recipes that output this item, no matter which recipe they use").defineList("ignore_list", UNCRAFT_IGNORE_ITEMS, it -> it instanceof String);
        TileUncraft.IGNORELIST_RECIPES = CFG.comment("RECIPE IDS HERE.  Block these recipe ids from being reversed, but do not block all recipes for this output item").defineList("ignore_recipes", UNCRAFT_RECIPE_IDS, it -> it instanceof String);
        TileUncraft.TIMER = CFG.comment("Ticks used for each uncraft").defineInRange("ticks", 60, 1, 9999);
        CFG.pop();
        CFG.pop();
        CFG.pop();
        COMMON_CONFIG = CFG.build();
        ConfigRegistry.initClientConfig();
    }

    private static void initClientConfig() {
        CFGC.comment(new String[]{WALL, "Client-side properties", WALL}).push("cyclic");
        CFGC.comment(new String[]{WALL, "Block Rendering properties.  Color MUST have one # symbol and then six spots after so #000000 up to #FFFFFF", WALL}).push("blocks");
        CFGC.push("colors");
        ClientConfigCyclic.COLLECTOR_ITEM = CFGC.comment("Specify hex color of preview mode.  default #444044").define("collector_item", (Object)"#444044");
        ClientConfigCyclic.COLLECTOR_FLUID = CFGC.comment("Specify hex color of preview mode.  default #444044").define("collector_fluid", (Object)"#444044");
        ClientConfigCyclic.DETECTOR_ENTITY = CFGC.comment("Specify hex color of preview mode.  default #00FF00").define("detector_entity", (Object)"#00FF00");
        ClientConfigCyclic.DETECTOR_ITEM = CFGC.comment("Specify hex color of preview mode.  default #00AA00").define("detector_item", (Object)"#00AA00");
        ClientConfigCyclic.PEAT_FARM = CFGC.comment("Specify hex color of preview mode.  default #404040").define("peat_farm", (Object)"#404040");
        ClientConfigCyclic.MINER = CFGC.comment("Specify hex color of preview mode.  default #0000AA").define("miner", (Object)"#0000AA");
        ClientConfigCyclic.DROPPER = CFGC.comment("Specify hex color of preview mode.  default #AA0011").define("dropper", (Object)"#AA0011");
        ClientConfigCyclic.FORESTER = CFGC.comment("Specify hex color of preview mode.  default #11BB00").define("forester", (Object)"#11BB00");
        ClientConfigCyclic.HARVESTER = CFGC.comment("Specify hex color of preview mode.  default #00EE00").define("harvester", (Object)"#00EE00");
        ClientConfigCyclic.STRUCTURE = CFGC.comment("Specify hex color of preview mode.  default #FF0000").define("structure", (Object)"#FF0000");
        CFGC.pop();
        CFGC.push("text");
        ClientConfigCyclic.FLUID_BLOCK_STATUS = CFGC.comment("True means this will hide the fluid contents chat message (right click) on relevant blocks (pylon, fluid generator, fluid hopper, solidifier, sprinkler, tank, cask)").define("FluidContents", true);
        CFGC.pop();
        CFGC.pop();
        CFGC.comment(new String[]{WALL, "Item Rendering properties.  Color MUST have one # symbol and then six spots after so #000000 up to #FFFFFF", WALL}).push("items");
        CFGC.push("colors");
        ClientConfigCyclic.LOCATION = CFGC.comment("Specify hex color of preview mode for the GPS data card.  default #0000FF").define("location", (Object)"#0000FF");
        ClientConfigCyclic.SHAPE_DATA = CFGC.comment("Specify hex color of preview mode.  default #FFC800").define("shape_data", (Object)"#FFC800");
        ClientConfigCyclic.RANDOMIZE_SCEPTER = CFGC.comment("Specify hex color of preview mode.  default #0000FF").define("randomize_scepter", (Object)"#00EE00");
        ClientConfigCyclic.OFFSET_SCEPTER = CFGC.comment("Specify hex color of preview mode.  default #0000FF").define("offset_scepter", (Object)"#00FF00");
        ClientConfigCyclic.REPLACE_SCEPTER = CFGC.comment("Specify hex color of preview mode.  default #0000FF").define("replace_scepter", (Object)"#FFFF00");
        ClientConfigCyclic.BUILD_SCEPTER = CFGC.comment("Specify hex color of preview mode.  default #0000FF").define("build_scepter", (Object)"#0000FF");
        CFGC.pop();
        CFGC.pop();
        CFGC.pop();
        CLIENT_CONFIG = CFGC.build();
    }

    public static void setup() {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("cyclic.toml")).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        COMMON_CONFIG.setConfig((CommentedConfig)configData);
    }

    public static void setupClient() {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("cyclic-client.toml")).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        CLIENT_CONFIG.setConfig((CommentedConfig)configData);
    }

    public static List<String> getMagicNetList() {
        return (List)MBALL_IGNORE_LIST.get();
    }

    public static Map<String, String> getMappedBeheading() {
        HashMap<String, String> mappedBeheading = new HashMap<String, String>();
        for (String s : (List)BEHEADING_SKINS.get()) {
            try {
                String[] stuff = s.split(":");
                String entity = stuff[0] + ":" + stuff[1];
                String skin = stuff[2];
                mappedBeheading.put(entity, skin);
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Beheading Enchantment: Invalid config entry " + s);
            }
        }
        return mappedBeheading;
    }

    static {
        BEHEADING = new ArrayList<String>();
        UNCRAFT_IGNORE_ITEMS = new ArrayList<String>();
        MBALL_IGNORE = new ArrayList<String>();
        UNCRAFT_RECIPE_IDS = new ArrayList<String>();
        TRANSPORTBAG = new ArrayList<String>();
        ConfigRegistry.buildDefaults();
        ConfigRegistry.initConfig();
    }
}

