/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.enchant.EnchantmentCyclic;
import com.lothrazar.cyclic.util.UtilEnchant;
import com.lothrazar.cyclic.util.UtilFakePlayer;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;

public class CurseEnchant
extends EnchantmentCyclic {
    public static final double BASE_ACTIVATION_CHANCE = 0.1;
    public static final double BASE_APPLY_CHANCE = 0.3;
    public static final double MIN_EFFECTS = 1.0;
    public static final double MAX_EFFECTS = 3.0;
    public static final int EFFECT_DURATION = 100;
    public static ForgeConfigSpec.BooleanValue CFG;
    public static final String ID = "curse";

    public CurseEnchant(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int m_6586_() {
        return 1;
    }

    public boolean m_6081_(ItemStack stack) {
        return stack.m_41720_() instanceof ArmorItem;
    }

    public void m_7675_(LivingEntity user, Entity attacker, int level) {
        if (user.f_19853_.f_46443_ || !(attacker instanceof LivingEntity) || UtilFakePlayer.isFakePlayer(attacker)) {
            return;
        }
        LivingEntity livingAttacker = (LivingEntity)attacker;
        int totalLevels = this.getCurrentArmorLevelSlot(user, EquipmentSlot.HEAD) + this.getCurrentArmorLevelSlot(user, EquipmentSlot.CHEST) + this.getCurrentArmorLevelSlot(user, EquipmentSlot.LEGS) + this.getCurrentArmorLevelSlot(user, EquipmentSlot.FEET);
        double adjustedActivationChance = 0.1 / (double)totalLevels;
        if (adjustedActivationChance > user.f_19853_.f_46441_.nextDouble()) {
            List<MobEffect> negativeEffects = UtilEnchant.getNegativeEffects();
            Collections.shuffle(negativeEffects);
            int appliedEffects = 0;
            for (MobEffect effect : negativeEffects) {
                if (effect == null || !((double)appliedEffects < 1.0) && !(0.3 > user.f_19853_.f_46441_.nextDouble())) continue;
                livingAttacker.m_7292_(new MobEffectInstance(effect, 100));
                if (!((double)(++appliedEffects) >= 3.0)) continue;
                break;
            }
        }
        super.m_7675_(user, attacker, level);
    }
}

