/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.enchant.EnchantmentCyclic;
import com.lothrazar.cyclic.util.UtilPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ReachEnchant
extends EnchantmentCyclic {
    private static final String NBT_REACH_ON = "reachon";
    private static final int REACH_VANILLA = 5;
    private static final int REACH_BOOST = 16;
    public static final String ID = "reach";
    public static ForgeConfigSpec.BooleanValue CFG;

    public ReachEnchant(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int m_6586_() {
        return 1;
    }

    public boolean m_6081_(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.m_6081_(stack);
    }

    private void turnReachOff(Player player) {
        player.getPersistentData().m_128379_(NBT_REACH_ON, false);
        UtilPlayer.setPlayerReach(player, 5);
    }

    private void turnReachOn(Player player) {
        player.getPersistentData().m_128379_(NBT_REACH_ON, true);
        UtilPlayer.setPlayerReach(player, 16);
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!(event.getEntityLiving() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntityLiving();
        ItemStack armor = this.getFirstArmorStackWithEnchant((LivingEntity)player);
        int level = 0;
        if (!armor.m_41619_() && EnchantmentHelper.m_44831_((ItemStack)armor) != null && EnchantmentHelper.m_44831_((ItemStack)armor).containsKey((Object)this)) {
            level = (Integer)EnchantmentHelper.m_44831_((ItemStack)armor).get((Object)this);
        }
        if (level > 0) {
            this.turnReachOn(player);
        } else if (player.getPersistentData().m_128441_(NBT_REACH_ON) && player.getPersistentData().m_128471_(NBT_REACH_ON)) {
            this.turnReachOff(player);
        }
    }
}

