/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.event;

import com.lothrazar.cyclic.api.IEntityInteractable;
import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.CandlePeaceBlock;
import com.lothrazar.cyclic.block.cable.CableBase;
import com.lothrazar.cyclic.block.scaffolding.ItemScaffolding;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.enchant.Multishot;
import com.lothrazar.cyclic.item.AntimatterEvaporatorWandItem;
import com.lothrazar.cyclic.item.apple.LoftyStatureApple;
import com.lothrazar.cyclic.item.bauble.CharmBase;
import com.lothrazar.cyclic.item.bauble.SoulstoneCharm;
import com.lothrazar.cyclic.item.builder.BuilderActionType;
import com.lothrazar.cyclic.item.builder.BuilderItem;
import com.lothrazar.cyclic.item.carrot.ItemHorseEnder;
import com.lothrazar.cyclic.item.datacard.ShapeCard;
import com.lothrazar.cyclic.item.enderbook.EnderBookItem;
import com.lothrazar.cyclic.item.equipment.GlowingHelmetItem;
import com.lothrazar.cyclic.item.heart.HeartItem;
import com.lothrazar.cyclic.item.storagebag.ItemStorageBag;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.EnchantRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.PotionRegistry;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.CharmUtil;
import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilSound;
import com.lothrazar.cyclic.util.UtilWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemEvents {
    @SubscribeEvent
    public void onLivingSpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        MobSpawnType res;
        LivingEntity mob = event.getEntityLiving();
        if (CandlePeaceBlock.isBad(mob, res = event.getSpawnReason()) && UtilWorld.doesBlockExist(mob.f_19853_, mob.m_142538_(), (BlockState)((Block)BlockRegistry.PEACE_CANDLE.get()).m_49966_().m_61124_((Property)BlockCyclic.LIT, (Comparable)Boolean.valueOf(true)), (Integer)CandlePeaceBlock.RADIUS.get(), (Integer)CandlePeaceBlock.HEIGHT.get())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        if (!(event.getEntityLiving() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntityLiving();
        if (player.m_21205_().m_41720_() == ItemRegistry.ENDER_BOOK.get()) {
            EnderBookItem.cancelTeleport(player.m_21205_());
        }
        if (player.m_21206_().m_41720_() == ItemRegistry.ENDER_BOOK.get()) {
            EnderBookItem.cancelTeleport(player.m_21206_());
        }
    }

    @SubscribeEvent
    public void onCriticalHitEvent(CriticalHitEvent event) {
        Player ply;
        ItemStack find;
        if (event.getEntityLiving() instanceof Player && !(find = CharmUtil.getIfEnabled(ply = (Player)event.getEntityLiving(), (Item)ItemRegistry.CHARM_CRIT.get())).m_41619_()) {
            event.setDamageModifier(3.0f);
            UtilItemStack.damageItem((LivingEntity)ply, find);
        }
    }

    @SubscribeEvent
    public void onArrowLooseEvent(ArrowLooseEvent event) {
        if (!((Boolean)Multishot.CFG.get()).booleanValue()) {
            return;
        }
        ItemStack stackBow = event.getBow();
        Player player = event.getPlayer();
        Level worldIn = player.f_19853_;
        if (!worldIn.f_46443_) {
            int level = EnchantRegistry.MULTIBOW.getCurrentLevelTool(stackBow);
            if (level <= 0) {
                return;
            }
            Vec3 playerDirection = UtilEntity.lookVector(player.m_146908_(), player.m_146909_());
            Vec3 left = playerDirection.m_82537_(new Vec3(0.0, 1.0, 0.0));
            Vec3 right = playerDirection.m_82537_(new Vec3(0.0, -1.0, 0.0));
            Multishot.spawnArrow(worldIn, player, stackBow, event.getCharge(), left.m_82541_());
            Multishot.spawnArrow(worldIn, player, stackBow, event.getCharge(), right.m_82541_());
        }
    }

    @SubscribeEvent
    public void onLivingKnockBackEvent(LivingKnockBackEvent event) {
        Player ply;
        ItemStack find;
        if (event.getEntityLiving() instanceof Player && !(find = CharmUtil.getIfEnabled(ply = (Player)event.getEntityLiving(), (Item)ItemRegistry.CHARM_KNOCKBACK_RESIST.get())).m_41619_()) {
            event.setCanceled(true);
            UtilItemStack.damageItem((LivingEntity)ply, find);
        }
    }

    @SubscribeEvent
    public void onProjectileImpactEvent(ProjectileImpactEvent event) {
        Projectile arrow = event.getProjectile();
        if (arrow == null || event.getRayTraceResult() == null) {
            return;
        }
        Level world = arrow.f_19853_;
        HitResult.Type hit = event.getRayTraceResult().m_6662_();
        Entity shooter = arrow.m_37282_();
        if (shooter instanceof Player) {
            Player ply = (Player)shooter;
            ItemStack find = CharmUtil.getIfEnabled(ply, (Item)ItemRegistry.QUIVER_DMG.get());
            if (!find.m_41619_() && arrow instanceof AbstractArrow) {
                AbstractArrow arroww = (AbstractArrow)arrow;
                double boost = arroww.m_36789_() / 2.0;
                arroww.m_36781_(arroww.m_36789_() + boost);
                UtilItemStack.damageItem((LivingEntity)ply, find);
            }
            if (!(find = CharmUtil.getIfEnabled(ply, (Item)ItemRegistry.QUIVER_LIT.get())).m_41619_() && world.f_46441_.nextDouble() < 0.25 && hit == HitResult.Type.ENTITY && ((EntityHitResult)event.getRayTraceResult()).m_82443_() instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)((EntityHitResult)event.getRayTraceResult()).m_82443_();
                target.m_146915_(true);
                BlockPos p = target.m_142538_();
                LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(world);
                lightningboltentity.m_6027_((double)p.m_123341_(), (double)p.m_123342_(), (double)p.m_123343_());
                world.m_7967_((Entity)lightningboltentity);
                UtilItemStack.damageItem((LivingEntity)ply, find);
            }
        }
    }

    @SubscribeEvent
    public void onPotionAddedEvent(PotionEvent.PotionAddedEvent event) {
        if (event.getEntityLiving() instanceof Player) {
            Player ply = (Player)event.getEntityLiving();
            ItemStack find = CharmUtil.getIfEnabled(ply, (Item)ItemRegistry.CHARM_ANTIPOTION.get());
            if (!find.m_41619_()) {
                event.getPotionEffect().f_19503_ = 0;
                UtilItemStack.damageItem((LivingEntity)ply, find);
            }
            if (!(find = CharmUtil.getIfEnabled(ply, (Item)ItemRegistry.CHARM_STEALTHPOTION.get())).m_41619_()) {
                if (event.getOldPotionEffect() != null) {
                    event.getOldPotionEffect().f_19508_ = false;
                }
                event.getPotionEffect().f_19508_ = false;
            }
            if (!(find = CharmUtil.getIfEnabled(ply, (Item)ItemRegistry.CHARM_BOOSTPOTION.get())).m_41619_()) {
                int boost = event.getPotionEffect().f_19503_ / 2;
                event.getPotionEffect().f_19503_ += boost;
                UtilItemStack.damageItem((LivingEntity)ply, find);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDamage(LivingDamageEvent event) {
        DamageSource src = event.getSource();
        if (event.getEntityLiving() instanceof Player) {
            Player player = (Player)event.getEntityLiving();
            if (src.m_19372_()) {
                this.damageFinder(event, player, (Item)ItemRegistry.CHARM_CREEPER.get(), 0.0f);
            }
            if (src == DamageSource.f_19315_ || src == DamageSource.f_19314_ || src == DamageSource.f_19325_) {
                this.damageFinder(event, player, (Item)ItemRegistry.CHARM_LONGFALL.get(), 0.0f);
            } else if (src == DamageSource.f_19316_ || src == DamageSource.f_19310_) {
                this.damageFinder(event, player, (Item)ItemRegistry.CHARM_STONE.get(), 0.0f);
            } else if (src == DamageSource.f_19319_ || src == DamageSource.f_19323_) {
                this.damageFinder(event, player, (Item)ItemRegistry.CHARM_MAGICDEF.get(), 0.5f);
            } else if (src == DamageSource.f_19313_) {
                if (this.damageFinder(event, player, (Item)ItemRegistry.CHARM_STARVATION.get(), 0.0f)) {
                    player.m_36324_().m_38707_(0, 0.2f);
                }
            } else if (src == DamageSource.f_19312_) {
                if (this.damageFinder(event, player, (Item)ItemRegistry.CHARM_WATER.get(), 0.0f)) {
                    MobEffectInstance eff = new MobEffectInstance(MobEffects.f_19608_, 200, 1);
                    eff.f_19508_ = false;
                    eff.f_19509_ = false;
                    player.m_7292_(eff);
                }
            } else if (src == DamageSource.f_19308_ || src == DamageSource.f_19305_ || src == DamageSource.f_19307_) {
                this.damageFinder(event, player, (Item)ItemRegistry.CHARM_FIRE.get(), 0.0f);
            }
        } else if (src.m_7639_() instanceof Player) {
            Player ply = (Player)src.m_7639_();
            ItemStack find = CharmUtil.getIfEnabled(ply, (Item)ItemRegistry.CHARM_VENOM.get());
            if (!find.m_41619_() && ply.f_19853_.f_46441_.nextDouble() < 0.25) {
                int seconds = 2 + ply.f_19853_.f_46441_.nextInt(4);
                event.getEntityLiving().m_7292_(new MobEffectInstance(MobEffects.f_19614_, 20 * seconds, 0));
                UtilItemStack.damageItem((LivingEntity)ply, find);
            }
            if (ply.m_7655_() == null || ply.m_21120_(ply.m_7655_()).m_41619_()) {
                // empty if block
            }
        }
    }

    private boolean damageFinder(LivingDamageEvent event, Player player, Item item, float factor) {
        ItemStack find = CharmUtil.getIfEnabled(player, item);
        if (!find.m_41619_()) {
            float amt = event.getAmount() * factor;
            event.setAmount(amt);
            if (amt <= 0.0f) {
                event.setCanceled(true);
            }
            UtilItemStack.damageItem((LivingEntity)player, find);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof Player) {
            Player player = (Player)event.getEntityLiving();
            ItemStack charmStack = CharmUtil.getIfEnabled(player, (Item)ItemRegistry.SOULSTONE.get());
            if (SoulstoneCharm.checkTotemDeathProtection(event.getSource(), player, charmStack)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerCloneDeath(PlayerEvent.Clone event) {
        AttributeModifier healthModifier;
        AttributeInstance original = event.getOriginal().m_21051_(Attributes.f_22276_);
        if (original != null && (healthModifier = original.m_22111_(HeartItem.ID)) != null) {
            event.getPlayer().m_21051_(Attributes.f_22276_).m_22125_(healthModifier);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity liv = event.getEntityLiving();
        this.tryItemHorseEnder(liv);
        if (liv instanceof Player) {
            Player player = (Player)liv;
            CharmBase.charmSpeed(player);
            CharmBase.charmLuck(player);
            CharmBase.charmAttackSpeed(player);
            CharmBase.charmExpSpeed(player);
            LoftyStatureApple.onUpdate(player);
            GlowingHelmetItem.onEntityUpdate(event);
        }
    }

    @SubscribeEvent
    public void onXpPickup(PlayerXpEvent.PickupXp event) {
        Player player = event.getPlayer();
        ItemStack charmStack = CharmUtil.getIfEnabled(player, (Item)ItemRegistry.CHARM_XPSTOPPER.get());
        if (!charmStack.m_41619_()) {
            event.setCanceled(true);
        }
    }

    private void tryItemHorseEnder(LivingEntity liv) {
        if (liv.getPersistentData().m_128441_("cyclic_carrot_ender") && liv.getPersistentData().m_128451_("cyclic_carrot_ender") > 0) {
            if (liv.m_20069_() && !liv.m_6040_() && liv.m_20146_() < liv.m_6062_() && !liv.m_21023_(MobEffects.f_19608_)) {
                liv.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 1200, 4));
                liv.m_7292_(new MobEffectInstance((MobEffect)PotionRegistry.PotionEffects.SWIMSPEED, 1200, 1));
                ItemHorseEnder.onSuccess(liv);
            }
            if (liv.m_6060_() && !liv.m_21023_(MobEffects.f_19607_)) {
                liv.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 1200, 4));
                liv.m_20095_();
                ItemHorseEnder.onSuccess(liv);
            }
            if (liv.f_19789_ > 12.0f && !liv.m_21023_(MobEffects.f_19591_)) {
                liv.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 1200, 4));
                ItemHorseEnder.onSuccess(liv);
            }
            if (liv.m_21223_() < 6.0f && !liv.m_21023_(MobEffects.f_19617_)) {
                liv.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 1200, 4));
                liv.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 1200, 4));
                ItemHorseEnder.onSuccess(liv);
            }
        }
    }

    @SubscribeEvent
    public void onBonemealEvent(BonemealEvent event) {
        BlockPos pos;
        Level world = event.getWorld();
        BlockState state = world.m_8055_(pos = event.getPos());
        if (state.m_60734_() == Blocks.f_50599_ && world.m_46859_(pos.m_7494_())) {
            event.setResult(Event.Result.ALLOW);
            world.m_46597_(pos.m_7494_(), ((Block)BlockRegistry.FLOWER_CYAN.get()).m_49966_());
        } else if (state.m_60734_() == BlockRegistry.FLOWER_CYAN.get()) {
            event.setResult(Event.Result.ALLOW);
            if (world.f_46441_.nextDouble() < 0.5) {
                UtilItemStack.drop(world, pos, new ItemStack((ItemLike)BlockRegistry.FLOWER_CYAN.get()));
            }
        } else if (state.m_60734_() == BlockRegistry.FLOWER_PURPLE_TULIP.get()) {
            event.setResult(Event.Result.ALLOW);
            if (world.f_46441_.nextDouble() < 0.25) {
                UtilItemStack.drop(world, pos, new ItemStack((ItemLike)BlockRegistry.FLOWER_PURPLE_TULIP.get()));
            }
        } else if (state.m_60734_() == BlockRegistry.FLOWER_ABSALON_TULIP.get()) {
            event.setResult(Event.Result.ALLOW);
            if (world.f_46441_.nextDouble() < 0.25) {
                UtilItemStack.drop(world, pos, new ItemStack((ItemLike)BlockRegistry.FLOWER_ABSALON_TULIP.get()));
            }
        } else if (state.m_60734_() == BlockRegistry.FLOWER_LIME_CARNATION.get()) {
            event.setResult(Event.Result.ALLOW);
            if (world.f_46441_.nextDouble() < 0.25) {
                UtilItemStack.drop(world, pos, new ItemStack((ItemLike)BlockRegistry.FLOWER_LIME_CARNATION.get()));
            }
        }
    }

    @SubscribeEvent
    public void onBedCheck(SleepingLocationCheckEvent event) {
        Player p;
        if (event.getEntity() instanceof Player && (p = (Player)event.getEntity()).getPersistentData().m_128471_("cyclic_sleeping")) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().m_41619_()) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getItemStack().m_41720_() instanceof ItemScaffolding && player.m_6047_()) {
            this.scaffoldHit(event);
        }
        if (player.m_6047_() && event.getItemStack().m_150922_(DataTags.WRENCH) && event.getWorld().m_8055_(event.getPos()).m_60734_() instanceof CableBase) {
            player.m_6674_(event.getHand());
            event.getWorld().m_46961_(event.getPos(), true);
            event.setCanceled(true);
        }
    }

    private void scaffoldHit(PlayerInteractEvent.RightClickBlock event) {
        ItemScaffolding item = (ItemScaffolding)event.getItemStack().m_41720_();
        Direction opp = event.getFace().m_122424_();
        BlockPos dest = UtilWorld.nextReplaceableInDirection(event.getWorld(), event.getPos(), opp, 16, item.m_40614_());
        if (event.getWorld().m_46859_(dest)) {
            event.getWorld().m_46597_(dest, item.m_40614_().m_49966_());
            ItemStack stac = event.getPlayer().m_21120_(event.getHand());
            UtilItemStack.shrink(event.getPlayer(), stac);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityInteractEvent(PlayerInteractEvent.EntityInteract event) {
        if (event.getItemStack().m_41720_() instanceof IEntityInteractable) {
            IEntityInteractable item = (IEntityInteractable)event.getItemStack().m_41720_();
            item.interactWith(event);
        }
    }

    @SubscribeEvent
    public void onHit(PlayerInteractEvent.LeftClickBlock event) {
        BlockState target;
        Player player = event.getPlayer();
        ItemStack held = player.m_21120_(event.getHand());
        if (held.m_41619_()) {
            return;
        }
        Level world = player.m_20193_();
        if (held.m_41720_() instanceof ShapeCard && player.m_6047_()) {
            target = world.m_8055_(event.getPos());
            ShapeCard.setBlockState(held, target);
            UtilChat.sendStatusMessage(player, target.m_60734_().m_7705_());
        }
        if (held.m_41720_() instanceof BuilderItem) {
            if (BuilderActionType.getTimeout(held) > 0) {
                return;
            }
            BuilderActionType.setTimeout(held);
            event.setCanceled(true);
            if (player.m_6047_()) {
                target = world.m_8055_(event.getPos());
                BuilderActionType.setBlockState(held, target);
                UtilChat.sendStatusMessage(player, target.m_60734_().m_7705_());
                event.setCanceled(true);
                UtilSound.playSound((Entity)player, SoundRegistry.DCOIN, 0.3f, 1.0f);
            } else {
                if (!world.f_46443_) {
                    BuilderActionType.toggle(held);
                }
                UtilSound.playSound((Entity)player, SoundRegistry.TOOL_MODE);
                UtilChat.sendStatusMessage(player, UtilChat.lang(BuilderActionType.getName(held)));
                event.setCanceled(true);
            }
        }
        if (held.m_41720_() instanceof AntimatterEvaporatorWandItem) {
            AntimatterEvaporatorWandItem.toggleMode(player, held);
        }
    }

    @SubscribeEvent
    public void onPlayerPickup(EntityItemPickupEvent event) {
        if (event.getEntityLiving() instanceof Player) {
            Player player = (Player)event.getEntityLiving();
            ItemEntity itemEntity = event.getItem();
            ItemStack resultStack = itemEntity.m_32055_();
            int origCount = resultStack.m_41613_();
            for (Integer i : ItemStorageBag.getAllBagSlots(player)) {
                ItemStack bag = player.m_150109_().m_8020_(i.intValue());
                switch (ItemStorageBag.getPickupMode(bag)) {
                    case EVERYTHING: {
                        resultStack = ItemStorageBag.tryInsert(bag, resultStack);
                        break;
                    }
                    case FILTER: {
                        resultStack = ItemStorageBag.tryFilteredInsert(bag, resultStack);
                        break;
                    }
                }
                if (!resultStack.m_41619_()) continue;
                break;
            }
            if (resultStack.m_41613_() != origCount) {
                itemEntity.m_32045_(resultStack);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }
}

