/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item;

import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemBaseCyclic
extends Item {
    public static final float INACCURACY_DEFAULT = 1.0f;
    public static final float VELOCITY_MAX = 1.5f;

    public ItemBaseCyclic(Item.Properties properties) {
        super(properties);
        ItemRegistry.ITEMSFIXME.add(this);
    }

    protected void shootMe(Level world, Player shooter, ThrowableItemProjectile ball, float pitch, float velocityFactor) {
        if (world.f_46443_) {
            return;
        }
        Vec3 vector3d1 = shooter.m_20289_(1.0f);
        Quaternion quaternion = new Quaternion(new Vector3f(vector3d1), pitch, true);
        Vec3 vector3d = shooter.m_20252_(1.0f);
        Vector3f vector3f = new Vector3f(vector3d);
        vector3f.m_122251_(quaternion);
        ball.m_6686_((double)vector3f.m_122239_(), (double)vector3f.m_122260_(), (double)vector3f.m_122269_(), velocityFactor * 1.5f, 1.0f);
        world.m_7967_((Entity)ball);
    }

    protected ItemStack findAmmo(Player player, Item item) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack = player.m_150109_().m_8020_(i);
            if (itemstack.m_41720_() != item) continue;
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public void tryRepairWith(ItemStack stackToRepair, Player player, Item target) {
        ItemStack torches;
        if (stackToRepair.m_41768_() && !(torches = this.findAmmo(player, target)).m_41619_()) {
            torches.m_41774_(1);
            UtilItemStack.repairItem(stackToRepair);
        }
    }

    public float getChargedPercent(ItemStack stack, int chargeTimer) {
        return BowItem.m_40661_((int)(this.m_8105_(stack) - chargeTimer));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent(this.m_5524_() + ".tooltip").m_130940_(ChatFormatting.GRAY));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient() {
    }
}

