/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.elemental;

import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilShape;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class WaterSpreaderItem
extends ItemBaseCyclic {
    private static final int COOLDOWN = 28;
    private static final int RADIUS = 3;

    public WaterSpreaderItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        if (side != null) {
            pos = pos.m_142300_(side);
        }
        this.spreadWaterFromCenter(context.m_43725_(), player, pos);
        player.m_6674_(context.m_43724_());
        return super.m_6225_(context);
    }

    private boolean spreadWaterFromCenter(Level world, Player player, BlockPos posCenter) {
        boolean success;
        int count = 0;
        for (BlockPos pos : UtilShape.squareHorizontalFull(posCenter, 3)) {
            if (world.m_46801_(pos) && world.m_8055_(pos).m_60734_() == Blocks.f_49990_) {
                world.m_46597_(pos, Blocks.f_49990_.m_49966_());
                ++count;
                continue;
            }
            BlockState state = world.m_8055_(pos);
            if (!state.m_61138_((Property)BlockStateProperties.f_61362_) || ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() || !this.isWaterNextdoor(world, pos)) continue;
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
            world.m_46597_(pos, state);
            ++count;
        }
        boolean bl = success = count > 0;
        if (success) {
            UtilEntity.setCooldownItem(player, this, 28);
        }
        return success;
    }

    private boolean isWaterNextdoor(Level world, BlockPos pos) {
        return world.m_46801_(pos.m_142127_()) || world.m_46801_(pos.m_142128_()) || world.m_46801_(pos.m_142126_()) || world.m_46801_(pos.m_142125_());
    }
}

