/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.random;

import com.lothrazar.cyclic.item.random.RandomizerItem;
import com.lothrazar.cyclic.net.PacketBaseCyclic;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilPlaceBlocks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class PacketRandomize
extends PacketBaseCyclic {
    private BlockPos pos;
    private Direction side;
    private InteractionHand hand;

    public PacketRandomize(BlockPos pos, Direction side, InteractionHand h) {
        this.pos = pos;
        this.side = side;
        this.hand = h;
    }

    public static PacketRandomize decode(FriendlyByteBuf buf) {
        PacketRandomize p = new PacketRandomize(buf.m_130135_(), Direction.values()[buf.readInt()], InteractionHand.values()[buf.readInt()]);
        return p;
    }

    public static void encode(PacketRandomize msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeInt(msg.side.ordinal());
        buf.writeInt(msg.hand.ordinal());
    }

    public static void handle(PacketRandomize message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Level world = player.m_20193_();
            List<BlockPos> places = RandomizerItem.getPlaces(message.pos, message.side);
            ArrayList<BlockPos> rpos = new ArrayList<BlockPos>();
            ArrayList<BlockState> rstates = new ArrayList<BlockState>();
            BlockState stateHere = null;
            boolean atLeastOne = false;
            for (BlockPos p : places) {
                stateHere = world.m_8055_(p);
                boolean canMove = RandomizerItem.canMove(stateHere, world, p);
                if (!canMove) continue;
                rpos.add(p);
                rstates.add(stateHere);
            }
            Collections.shuffle(rpos, world.f_46441_);
            ArrayList<BlockPos> arrayList = rpos;
            synchronized (arrayList) {
                for (int i = 0; i < rpos.size(); ++i) {
                    BlockPos swapPos = (BlockPos)rpos.get(i);
                    BlockState swapState = (BlockState)rstates.get(i);
                    world.m_46961_(swapPos, false);
                    if (!UtilPlaceBlocks.placeStateSafe(world, (Player)player, swapPos, swapState, false)) continue;
                    atLeastOne = true;
                }
            }
            if (atLeastOne) {
                UtilItemStack.damageItem((LivingEntity)player, player.m_21120_(message.hand));
            }
        });
        message.done(ctx);
    }
}

