/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.net.PacketBaseCyclic;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilPlaceBlocks;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class PacketRotateBlock
extends PacketBaseCyclic {
    private BlockPos pos;
    private Direction side;
    private InteractionHand hand;

    public PacketRotateBlock(BlockPos mouseover, Direction s, InteractionHand hand) {
        this.pos = mouseover;
        this.side = s;
        this.hand = hand;
    }

    public static PacketRotateBlock decode(FriendlyByteBuf buf) {
        return new PacketRotateBlock(buf.m_130135_(), Direction.values()[buf.readInt()], InteractionHand.values()[buf.readInt()]);
    }

    public static void encode(PacketRotateBlock msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeInt(msg.side.ordinal());
        buf.writeInt(msg.hand.ordinal());
    }

    public static void handle(PacketRotateBlock message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level world = ((NetworkEvent.Context)ctx.get()).getSender().f_19853_;
            boolean succ = UtilPlaceBlocks.rotateBlockValidState(world, message.pos, message.side);
            if (succ) {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                ItemStack itemStackHeld = player.m_21120_(message.hand);
                UtilItemStack.damageItem((LivingEntity)player, itemStackHeld);
                if (world.m_8055_(message.pos).m_60827_() != null) {
                    UtilSound.playSoundFromServer(player, world.m_8055_(message.pos).m_60827_().m_56777_(), 1.0f, 1.0f);
                }
            }
        });
        message.done(ctx);
    }
}

