/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.block.enderitemshelf.ClientAutoSyncItemHandler;
import com.lothrazar.cyclic.block.endershelf.EnderShelfItemHandler;
import com.lothrazar.cyclic.net.PacketBaseCyclic;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.network.NetworkEvent;

public class PacketTileInventoryToClient
extends PacketBaseCyclic {
    private BlockPos blockPos;
    private int slot;
    private ItemStack itemStack;
    private SyncPacketType type;

    public PacketTileInventoryToClient(BlockPos blockPos, int slot, ItemStack itemStack, SyncPacketType type) {
        this.blockPos = blockPos;
        this.slot = slot;
        this.itemStack = itemStack;
        this.type = type;
    }

    public PacketTileInventoryToClient() {
    }

    public static void handle(PacketTileInventoryToClient message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ == null) {
                message.done(ctx);
                return;
            }
            BlockEntity tile = Minecraft.m_91087_().f_91073_.m_7702_(message.blockPos);
            if (tile != null) {
                tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                    if (message.type == SyncPacketType.SET) {
                        if (h instanceof EnderShelfItemHandler) {
                            ItemStack itemStack = ((EnderShelfItemHandler)((Object)((Object)h))).emptySlot(message.slot);
                        } else if (h instanceof ClientAutoSyncItemHandler) {
                            ItemStack itemStack = ((ClientAutoSyncItemHandler)((Object)((Object)h))).emptySlot(message.slot);
                        } else {
                            h.extractItem(message.slot, 64, false);
                        }
                    }
                    h.insertItem(message.slot, message.itemStack, false);
                });
            }
        });
        message.done(ctx);
    }

    public static PacketTileInventoryToClient decode(FriendlyByteBuf buf) {
        PacketTileInventoryToClient p = new PacketTileInventoryToClient();
        p.blockPos = buf.m_130135_();
        p.slot = buf.readInt();
        p.itemStack = buf.m_130267_();
        p.type = (SyncPacketType)buf.m_130066_(SyncPacketType.class);
        return p;
    }

    public static void encode(PacketTileInventoryToClient msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.blockPos);
        buf.writeInt(msg.slot);
        buf.m_130055_(msg.itemStack);
        buf.m_130068_((Enum)msg.type);
    }

    public static enum SyncPacketType {
        CHANGE,
        SET;

    }
}

