/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidTagIngredient {
    private final FluidStack fluid;
    private final String tag;
    private final int amount;

    public FluidTagIngredient(FluidStack fs, String str, int cnt) {
        this.fluid = fs == null ? FluidStack.EMPTY : fs;
        this.tag = str == null ? "" : str;
        this.amount = cnt;
    }

    public FluidStack getFluidStack() {
        return this.fluid;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean hasFluid() {
        return !this.fluid.isEmpty();
    }

    public boolean hasTag() {
        return !this.tag.isEmpty();
    }

    public List<Fluid> list() {
        if (!this.hasTag()) {
            return null;
        }
        for (Map.Entry fluidTag : FluidTags.m_144299_().m_5643_().entrySet()) {
            if (!((ResourceLocation)fluidTag.getKey()).toString().equalsIgnoreCase(this.tag)) continue;
            return ((Tag)fluidTag.getValue()).m_6497_();
        }
        return null;
    }

    public List<FluidStack> getMatchingFluids() {
        List<Fluid> fluids = this.list();
        if (fluids == null) {
            return null;
        }
        ArrayList<FluidStack> me = new ArrayList<FluidStack>();
        for (Fluid f : fluids) {
            me.add(new FluidStack(f, this.amount));
        }
        return me;
    }

    public static FluidTagIngredient readFromPacket(FriendlyByteBuf buffer) {
        return new FluidTagIngredient(FluidStack.readFromPacket((FriendlyByteBuf)buffer), buffer.m_130277_(), buffer.readInt());
    }

    public void writeToPacket(FriendlyByteBuf buffer) {
        this.fluid.writeToPacket(buffer);
        buffer.m_130070_(this.tag);
        buffer.writeInt(this.amount);
    }

    public int getAmount() {
        return this.amount;
    }
}

