/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.registry;

import com.lothrazar.cyclic.enchant.AutoSmeltEnchant;
import com.lothrazar.cyclic.enchant.BeekeeperEnchant;
import com.lothrazar.cyclic.enchant.BeheadingEnchant;
import com.lothrazar.cyclic.enchant.CurseEnchant;
import com.lothrazar.cyclic.enchant.DisarmEnchant;
import com.lothrazar.cyclic.enchant.ElytraLaunchEnchant;
import com.lothrazar.cyclic.enchant.EnchantmentCyclic;
import com.lothrazar.cyclic.enchant.ExcavationEnchant;
import com.lothrazar.cyclic.enchant.GrowthEnchant;
import com.lothrazar.cyclic.enchant.LifeLeechEnchant;
import com.lothrazar.cyclic.enchant.MagnetEnchant;
import com.lothrazar.cyclic.enchant.Multishot;
import com.lothrazar.cyclic.enchant.PearlEnchant;
import com.lothrazar.cyclic.enchant.QuickdrawEnchant;
import com.lothrazar.cyclic.enchant.ReachEnchant;
import com.lothrazar.cyclic.enchant.StandEnchant;
import com.lothrazar.cyclic.enchant.StepEnchant;
import com.lothrazar.cyclic.enchant.TravellerEnchant;
import com.lothrazar.cyclic.enchant.VenomEnchant;
import com.lothrazar.cyclic.enchant.XpEnchant;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnchantRegistry {
    public static final Enchantment TRAVELLER = (Enchantment)new TravellerEnchant(Enchantment.Rarity.RARE, EnchantmentCategory.ARMOR_LEGS, EquipmentSlot.LEGS).setRegistryName("traveler");
    private static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final EnchantmentCyclic MULTIBOW = (EnchantmentCyclic)new Multishot(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.BOW, EquipmentSlot.MAINHAND).setRegistryName("multishot");
    public static final EnchantmentCyclic EXCAVATE = (EnchantmentCyclic)new ExcavationEnchant(Enchantment.Rarity.RARE, EnchantmentCategory.DIGGER, EquipmentSlot.MAINHAND).setRegistryName("excavate");
    public static final EnchantmentCyclic EXPERIENCE_BOOST = (EnchantmentCyclic)new XpEnchant(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.DIGGER, EquipmentSlot.MAINHAND).setRegistryName("experience_boost");
    public static final ElytraLaunchEnchant LAUNCH = (ElytraLaunchEnchant)new ElytraLaunchEnchant(Enchantment.Rarity.RARE, EnchantmentCategory.ARMOR_FEET, EquipmentSlot.FEET).setRegistryName("launch");

    @SubscribeEvent
    public static void onEnchantRegister(RegistryEvent.Register<Enchantment> event) {
        IForgeRegistry r = event.getRegistry();
        EnchantRegistry.register((IForgeRegistry<Enchantment>)r, EXCAVATE);
        EnchantRegistry.register((IForgeRegistry<Enchantment>)r, EXPERIENCE_BOOST);
        EnchantRegistry.register((IForgeRegistry<Enchantment>)r, (Enchantment)new BeheadingEnchant(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.WEAPON, EquipmentSlot.MAINHAND).setRegistryName("beheading"));
        EnchantRegistry.register((IForgeRegistry<Enchantment>)r, (Enchantment)new GrowthEnchant(Enchantment.Rarity.COMMON, EnchantmentCategory.DIGGER, EquipmentSlot.MAINHAND).setRegistryName("growth"));
        EnchantRegistry.register((IForgeRegistry<Enchantment>)r, LAUNCH);
        EnchantRegistry.register((IForgeRegistry<Enchantment>)r, (Enchantment)new LifeLeechEnchant(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.WEAPON, EquipmentSlot.MAINHAND).setRegistryName("life_leech"));
        EnchantRegistry.register((IForgeRegistry<Enchantment>)r, (Enchantment)new MagnetEnchant(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.BREAKABLE, EquipmentSlot.MAINHAND).setRegistryName("magnet"));
        EnchantRegistry.register((IForgeRegistry<Enchantment>)r, MULTIBOW);
        EnchantRegistry.register((IForgeRegistry<Enchantment>)r, (Enchantment)new QuickdrawEnchant(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.BOW, EquipmentSlot.MAINHAND).setRegistryName("quickshot"));
        EnchantRegistry.register((IForgeRegistry<Enchantment>)r, (Enchantment)new ReachEnchant(Enchantment.Rarity.RARE, EnchantmentCategory.WEARABLE, ARMOR_SLOTS).setRegistryName("reach"));
        EnchantRegistry.register((IForgeRegistry<Enchantment>)r, (Enchantment)new StepEnchant(Enchantment.Rarity.RARE, EnchantmentCategory.ARMOR_LEGS, EquipmentSlot.LEGS).setRegistryName("step"));
        EnchantRegistry.register((IForgeRegistry<Enchantment>)r, TRAVELLER);
        EnchantRegistry.register((IForgeRegistry<Enchantment>)r, (Enchantment)new VenomEnchant(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.WEAPON, EquipmentSlot.MAINHAND).setRegistryName("venom"));
        EnchantRegistry.register((IForgeRegistry<Enchantment>)r, (Enchantment)new AutoSmeltEnchant(Enchantment.Rarity.RARE, EnchantmentCategory.DIGGER, EquipmentSlot.MAINHAND).setRegistryName("auto_smelt"));
        EnchantRegistry.register((IForgeRegistry<Enchantment>)r, (Enchantment)new DisarmEnchant(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.WEAPON, EquipmentSlot.MAINHAND).setRegistryName("disarm"));
        EnchantRegistry.register((IForgeRegistry<Enchantment>)r, (Enchantment)new CurseEnchant(Enchantment.Rarity.RARE, EnchantmentCategory.ARMOR, EquipmentSlot.CHEST).setRegistryName("curse"));
        EnchantRegistry.register((IForgeRegistry<Enchantment>)r, (Enchantment)new PearlEnchant(Enchantment.Rarity.RARE, EnchantmentCategory.WEAPON, EquipmentSlot.MAINHAND).setRegistryName("ender"));
        EnchantRegistry.register((IForgeRegistry<Enchantment>)r, (Enchantment)new BeekeeperEnchant(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.ARMOR_HEAD, EquipmentSlot.HEAD).setRegistryName("beekeeper"));
        EnchantRegistry.register((IForgeRegistry<Enchantment>)r, (Enchantment)new StandEnchant(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.ARMOR_LEGS, EquipmentSlot.LEGS).setRegistryName("laststand"));
    }

    private static void register(IForgeRegistry<Enchantment> r, Enchantment e) {
        EnchantmentCyclic ench = (EnchantmentCyclic)e;
        if (ench.isEnabled()) {
            r.register((IForgeRegistryEntry)ench);
        }
    }
}

