/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.registry;

import com.lothrazar.cyclic.potion.TickableEffect;
import com.lothrazar.cyclic.potion.effect.StunEffect;
import com.lothrazar.cyclic.potion.effect.SwimEffect;
import com.lothrazar.cyclic.recipe.ModBrewingRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PotionRegistry {
    @SubscribeEvent
    public static void onPotEffectRegistry(RegistryEvent.Register<MobEffect> event) {
        IForgeRegistry r = event.getRegistry();
        PotionEffects.STUN = PotionRegistry.register((IForgeRegistry<MobEffect>)r, new StunEffect(MobEffectCategory.HARMFUL, 0xCCCC00), "stun");
        PotionEffects.SWIMSPEED = PotionRegistry.register((IForgeRegistry<MobEffect>)r, new SwimEffect(MobEffectCategory.BENEFICIAL, 0x663300), "swimspeed");
    }

    private static TickableEffect register(IForgeRegistry<MobEffect> r, TickableEffect pot, String name) {
        pot.setRegistryName(new ResourceLocation("cyclic", name));
        r.register((IForgeRegistryEntry)pot);
        PotionEffects.EFFECTS.add(pot);
        return pot;
    }

    @SubscribeEvent
    public static void onPotRegistry(RegistryEvent.Register<Potion> event) {
        IForgeRegistry r = event.getRegistry();
        int normal = 3600;
        int smal = 1800;
        r.register((IForgeRegistryEntry)((Potion)new Potion("cyclic_haste", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19598_, normal)}).setRegistryName("cyclic:haste")));
        r.register((IForgeRegistryEntry)((Potion)new Potion("cyclic_strong_haste", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19598_, smal, 1)}).setRegistryName("cyclic:strong_haste")));
        r.register((IForgeRegistryEntry)((Potion)new Potion("cyclic_stun", new MobEffectInstance[]{new MobEffectInstance((MobEffect)PotionEffects.STUN, smal)}).setRegistryName("cyclic:stun")));
        r.register((IForgeRegistryEntry)((Potion)new Potion("cyclic_swimspeed", new MobEffectInstance[]{new MobEffectInstance((MobEffect)PotionEffects.SWIMSPEED, normal)}).setRegistryName("cyclic:swimspeed")));
        r.register((IForgeRegistryEntry)((Potion)new Potion("cyclic_blind", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19610_, normal)}).setRegistryName("cyclic:blind")));
        r.register((IForgeRegistryEntry)((Potion)new Potion("cyclic_levitation", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19620_, smal)}).setRegistryName("cyclic:levitation")));
        r.register((IForgeRegistryEntry)((Potion)new Potion("cyclic_hunger", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19612_, normal)}).setRegistryName("cyclic:hunger")));
        r.register((IForgeRegistryEntry)((Potion)new Potion("cyclic_strong_hunger", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19612_, smal, 1)}).setRegistryName("cyclic:strong_hunger")));
        r.register((IForgeRegistryEntry)((Potion)new Potion("cyclic_wither", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19615_, smal)}).setRegistryName("cyclic:wither")));
        r.register((IForgeRegistryEntry)((Potion)new Potion("cyclic_resistance", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19606_, smal)}).setRegistryName("cyclic:resistance")));
    }

    public static void setup(FMLCommonSetupEvent event) {
        ItemStack awkwardPotion = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43602_);
        ItemStack thickPotion = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43601_);
        PotionRegistry.basicBrewing(awkwardPotion.m_41777_(), PotionItem.HASTE, Items.f_42616_);
        PotionRegistry.basicBrewing(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)PotionItem.HASTE), PotionItem.STRONG_HASTE, Items.f_42451_);
        PotionRegistry.basicBrewing(awkwardPotion.m_41777_(), PotionItem.STUN, Items.f_41983_);
        PotionRegistry.basicBrewing(awkwardPotion.m_41777_(), PotionItem.SWIMSPEED, Items.f_42515_);
        PotionRegistry.basicBrewing(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43603_), PotionItem.BLIND, Items.f_42732_);
        PotionRegistry.basicBrewing(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43596_), PotionItem.LEVITATION, Items.f_42592_);
        PotionRegistry.basicBrewing(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43590_), PotionItem.RESISTANCE, Items.f_42416_);
        PotionRegistry.basicBrewing(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43593_), PotionItem.WITHER, Items.f_42691_);
        PotionRegistry.basicBrewing(thickPotion.m_41777_(), PotionItem.HUNGER, Items.f_42583_);
        PotionRegistry.basicBrewing(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)PotionItem.HUNGER), PotionItem.STRONG_HUNGER, Items.f_42451_);
    }

    private static void basicBrewing(ItemStack inputPot, Potion pot, Item item) {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ModBrewingRecipe(inputPot, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)pot)));
    }

    static void splashBrewing(Potion pot, Item item) {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ModBrewingRecipe(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43602_), Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)item)}), PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)pot)));
    }

    static void lingerBrewing(Potion pot, Item item) {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ModBrewingRecipe(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)Potions.f_43602_), Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)item)}), PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)pot)));
    }

    public static class PotionEffects {
        public static final List<TickableEffect> EFFECTS = new ArrayList<TickableEffect>();
        @ObjectHolder(value="cyclic:stun")
        public static TickableEffect STUN;
        @ObjectHolder(value="cyclic:swimspeed")
        public static TickableEffect SWIMSPEED;
    }

    public static class PotionItem {
        @ObjectHolder(value="cyclic:strong_haste")
        public static Potion STRONG_HASTE;
        @ObjectHolder(value="cyclic:haste")
        public static Potion HASTE;
        @ObjectHolder(value="cyclic:stun")
        public static Potion STUN;
        @ObjectHolder(value="cyclic:swimspeed")
        public static Potion SWIMSPEED;
        @ObjectHolder(value="cyclic:blind")
        public static Potion BLIND;
        @ObjectHolder(value="cyclic:levitation")
        public static Potion LEVITATION;
        @ObjectHolder(value="cyclic:hunger")
        public static Potion HUNGER;
        @ObjectHolder(value="cyclic:strong_hunger")
        public static Potion STRONG_HUNGER;
        @ObjectHolder(value="cyclic:wither")
        public static Potion WITHER;
        @ObjectHolder(value="cyclic:resistance")
        public static Potion RESISTANCE;
    }
}

