/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.render;

import com.lothrazar.cyclic.data.Model3D;
import com.lothrazar.cyclic.util.UtilRender;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;

public class RenderResizableCuboid {
    public static final RenderResizableCuboid INSTANCE = new RenderResizableCuboid();
    private static final Vector3f VEC_ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final int U_MIN = 0;
    private static final int U_MAX = 1;
    private static final int V_MIN = 2;
    private static final int V_MAX = 3;
    protected EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();

    private static Vector3f withValue(Vector3f vector, Direction.Axis axis, float value) {
        if (axis == Direction.Axis.X) {
            return new Vector3f(value, vector.m_122260_(), vector.m_122269_());
        }
        if (axis == Direction.Axis.Y) {
            return new Vector3f(vector.m_122239_(), value, vector.m_122269_());
        }
        if (axis == Direction.Axis.Z) {
            return new Vector3f(vector.m_122239_(), vector.m_122260_(), value);
        }
        throw new RuntimeException("Was given a null axis! That was probably not intentional, consider this a bug! (Vector = " + vector + ")");
    }

    public static double getValue(Vec3 vector, Direction.Axis axis) {
        if (axis == Direction.Axis.X) {
            return vector.f_82479_;
        }
        if (axis == Direction.Axis.Y) {
            return vector.f_82480_;
        }
        if (axis == Direction.Axis.Z) {
            return vector.f_82481_;
        }
        throw new RuntimeException("Was given a null axis! That was probably not intentional, consider this a bug! (Vector = " + vector + ")");
    }

    public void renderCube(Model3D cube, PoseStack matrix, VertexConsumer buffer, int argb, int light) {
        float red = UtilRender.getRed(argb);
        float green = UtilRender.getGreen(argb);
        float blue = UtilRender.getBlue(argb);
        float alpha = UtilRender.getAlpha(argb);
        Vec3 size = new Vec3(cube.sizeX(), cube.sizeY(), cube.sizeZ());
        matrix.m_85836_();
        matrix.m_85837_(cube.minX, cube.minY, cube.minZ);
        Matrix4f matrix4f = matrix.m_85850_().m_85861_();
        for (Direction face : Direction.values()) {
            int ordinal;
            TextureAtlasSprite sprite;
            if (!cube.shouldSideRender(face) || (sprite = cube.textures[ordinal = face.ordinal()]) == null) continue;
            Direction.Axis u = face.m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
            Direction.Axis v = face.m_122434_() == Direction.Axis.Y ? Direction.Axis.Z : Direction.Axis.Y;
            float other = face.m_122421_() == Direction.AxisDirection.POSITIVE ? (float)RenderResizableCuboid.getValue(size, face.m_122434_()) : 0.0f;
            face = face.m_122421_() == Direction.AxisDirection.NEGATIVE ? face : face.m_122424_();
            Direction opposite = face.m_122424_();
            float minU = sprite.m_118409_();
            float maxU = sprite.m_118410_();
            float minV = sprite.m_118412_();
            float maxV = sprite.m_118411_();
            double sizeU = RenderResizableCuboid.getValue(size, u);
            double sizeV = RenderResizableCuboid.getValue(size, v);
            int uIndex = 0;
            while ((double)uIndex < sizeU) {
                float[] baseUV = new float[]{minU, maxU, minV, maxV};
                double addU = 1.0;
                if ((double)uIndex + addU > sizeU) {
                    addU = sizeU - (double)uIndex;
                    baseUV[1] = baseUV[0] + (baseUV[1] - baseUV[0]) * (float)addU;
                }
                int vIndex = 0;
                while ((double)vIndex < sizeV) {
                    float[] uv = Arrays.copyOf(baseUV, 4);
                    double addV = 1.0;
                    if ((double)vIndex + addV > sizeV) {
                        addV = sizeV - (double)vIndex;
                        uv[3] = uv[2] + (uv[3] - uv[2]) * (float)addV;
                    }
                    float[] xyz = new float[]{uIndex, (float)((double)uIndex + addU), vIndex, (float)((double)vIndex + addV)};
                    this.renderPoint(matrix4f, buffer, face, u, v, other, uv, xyz, true, false, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, face, u, v, other, uv, xyz, true, true, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, face, u, v, other, uv, xyz, false, true, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, face, u, v, other, uv, xyz, false, false, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, opposite, u, v, other, uv, xyz, false, false, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, opposite, u, v, other, uv, xyz, false, true, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, opposite, u, v, other, uv, xyz, true, true, red, green, blue, alpha, light);
                    this.renderPoint(matrix4f, buffer, opposite, u, v, other, uv, xyz, true, false, red, green, blue, alpha, light);
                    ++vIndex;
                }
                ++uIndex;
            }
        }
        matrix.m_85849_();
    }

    private void renderPoint(Matrix4f matrix4f, VertexConsumer buffer, Direction face, Direction.Axis u, Direction.Axis v, float other, float[] uv, float[] xyz, boolean minU, boolean minV, float red, float green, float blue, float alpha, int light) {
        int uFinal = minU ? 0 : 1;
        int vFinal = minV ? 2 : 3;
        Vector3f vertex = RenderResizableCuboid.withValue(VEC_ZERO, u, xyz[uFinal]);
        vertex = RenderResizableCuboid.withValue(vertex, v, xyz[vFinal]);
        vertex = RenderResizableCuboid.withValue(vertex, face.m_122434_(), other);
        buffer.m_85982_(matrix4f, vertex.m_122239_(), vertex.m_122260_(), vertex.m_122269_()).m_85950_(red, green, blue, alpha).m_7421_(uv[uFinal], uv[vFinal]).m_85969_(light).m_5752_();
    }
}

