/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.util;

import com.lothrazar.cyclic.data.BlockPosDim;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class UtilWorld {
    public static Direction getRandomDirection(Random rand) {
        int index = Mth.m_14072_((Random)rand, (int)0, (int)(Direction.values().length - 1));
        return Direction.values()[index];
    }

    public static boolean removeFlowingLiquid(Level world, BlockPos pos, boolean nukeOption) {
        BlockState blockHere = world.m_8055_(pos);
        if (blockHere.m_61138_((Property)BlockStateProperties.f_61362_)) {
            return world.m_7731_(pos, (BlockState)blockHere.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 18);
        }
        if (blockHere.m_60734_() instanceof BucketPickup) {
            BucketPickup block = (BucketPickup)blockHere.m_60734_();
            ItemStack res = block.m_142598_((LevelAccessor)world, pos, blockHere);
            if (!res.m_41619_()) {
                return world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 18);
            }
            return true;
        }
        if (nukeOption) {
            return world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 18);
        }
        return false;
    }

    public static String dimensionToString(Level world) {
        return world.m_46472_().m_135782_().toString();
    }

    public static ResourceKey<Level> stringToDimension(String key) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)ResourceLocation.m_135820_((String)key));
    }

    public static double distanceBetweenHorizontal(BlockPos start, BlockPos end) {
        int xDistance = Math.abs(start.m_123341_() - end.m_123341_());
        int zDistance = Math.abs(start.m_123343_() - end.m_123343_());
        return Math.sqrt(xDistance * xDistance + zDistance * zDistance);
    }

    public static BlockPos nextReplaceableInDirection(Level world, BlockPos posIn, Direction facing, int max, Block blockMatch) {
        BlockPos posToPlaceAt = new BlockPos((Vec3i)posIn);
        BlockPos posLoop = new BlockPos((Vec3i)posIn);
        for (int i = 0; i < max; ++i) {
            BlockState state = world.m_8055_(posLoop);
            if (state.m_60734_() != null && world.m_8055_(posLoop).m_60734_() == Blocks.f_50016_) {
                posToPlaceAt = posLoop;
                break;
            }
            posLoop = posLoop.m_142300_(facing);
        }
        return posToPlaceAt;
    }

    public static ItemEntity dropItemStackInWorld(Level world, BlockPos pos, ItemStack stack) {
        if (pos == null || world == null || stack.m_41619_()) {
            return null;
        }
        ItemEntity entityItem = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
        if (!world.f_46443_) {
            world.m_7967_((Entity)entityItem);
        }
        return entityItem;
    }

    public static boolean doesBlockExist(Level world, BlockPos start, BlockState blockHunt, int radius, int height) {
        int xMin = start.m_123341_() - radius;
        int xMax = start.m_123341_() + radius;
        int yMin = start.m_123342_();
        int yMax = start.m_123342_() + height;
        int zMin = start.m_123343_() - radius;
        int zMax = start.m_123343_() + radius;
        BlockPos posCurrent = null;
        for (int xLoop = xMin; xLoop <= xMax; ++xLoop) {
            for (int yLoop = yMin; yLoop <= yMax; ++yLoop) {
                for (int zLoop = zMin; zLoop <= zMax; ++zLoop) {
                    posCurrent = new BlockPos(xLoop, yLoop, zLoop);
                    if (world.m_8055_(posCurrent) != blockHunt) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static ArrayList<BlockPos> findBlocks(Level world, BlockPos start, Block blockHunt, int radius) {
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        int xMin = start.m_123341_() - radius;
        int xMax = start.m_123341_() + radius;
        int yMin = start.m_123342_() - radius;
        int yMax = start.m_123342_() + radius;
        int zMin = start.m_123343_() - radius;
        int zMax = start.m_123343_() + radius;
        BlockPos posCurrent = null;
        for (int xLoop = xMin; xLoop <= xMax; ++xLoop) {
            for (int yLoop = yMin; yLoop <= yMax; ++yLoop) {
                for (int zLoop = zMin; zLoop <= zMax; ++zLoop) {
                    posCurrent = new BlockPos(xLoop, yLoop, zLoop);
                    if (!world.m_8055_(posCurrent).m_60734_().equals(blockHunt)) continue;
                    found.add(posCurrent);
                }
            }
        }
        return found;
    }

    public static void toggleLeverPowerState(Level worldIn, BlockPos blockPos, BlockState blockState) {
        boolean hasPowerHere = (Boolean)blockState.m_61143_((Property)LeverBlock.f_54622_);
        BlockState stateNew = (BlockState)blockState.m_61124_((Property)LeverBlock.f_54622_, (Comparable)Boolean.valueOf(!hasPowerHere));
        boolean success = worldIn.m_46597_(blockPos, stateNew);
        if (success) {
            UtilWorld.flagUpdate(worldIn, blockPos, blockState, stateNew);
            UtilWorld.flagUpdate(worldIn, blockPos.m_7495_(), blockState, stateNew);
            UtilWorld.flagUpdate(worldIn, blockPos.m_7494_(), blockState, stateNew);
            UtilWorld.flagUpdate(worldIn, blockPos.m_142125_(), blockState, stateNew);
            UtilWorld.flagUpdate(worldIn, blockPos.m_142126_(), blockState, stateNew);
            UtilWorld.flagUpdate(worldIn, blockPos.m_142127_(), blockState, stateNew);
            UtilWorld.flagUpdate(worldIn, blockPos.m_142128_(), blockState, stateNew);
        }
    }

    public static void flagUpdate(Level worldIn, BlockPos blockPos, BlockState blockState, BlockState stateNew) {
        worldIn.m_7260_(blockPos, blockState, stateNew, 3);
        worldIn.m_46672_(blockPos, stateNew.m_60734_());
        worldIn.m_46672_(blockPos, blockState.m_60734_());
    }

    public static BlockPos findClosestBlock(Player player, Block blockHunt, int radiusIn) {
        BlockPos found = null;
        int xMin = (int)player.m_20185_() - radiusIn;
        int xMax = (int)player.m_20185_() + radiusIn;
        int yMin = (int)player.m_20186_() - radiusIn;
        int yMax = (int)player.m_20186_() + radiusIn;
        int zMin = (int)player.m_20189_() - radiusIn;
        int zMax = (int)player.m_20189_() + radiusIn;
        int distance = 0;
        int distanceClosest = radiusIn * radiusIn;
        BlockPos posCurrent = null;
        Level world = player.m_20193_();
        for (int xLoop = xMin; xLoop <= xMax; ++xLoop) {
            for (int yLoop = yMin; yLoop <= yMax; ++yLoop) {
                for (int zLoop = zMin; zLoop <= zMax; ++zLoop) {
                    posCurrent = new BlockPos(xLoop, yLoop, zLoop);
                    if (!world.isAreaLoaded(posCurrent, 1) || !world.m_8055_(posCurrent).m_60734_().equals(blockHunt)) continue;
                    if (found == null) {
                        found = posCurrent;
                        continue;
                    }
                    distance = (int)UtilWorld.distanceBetweenHorizontal(player.m_142538_(), posCurrent);
                    if (distance >= distanceClosest) continue;
                    found = posCurrent;
                    distanceClosest = distance;
                }
            }
        }
        return found;
    }

    public static List<BlockPos> getPositionsInRange(BlockPos pos, int xMin, int xMax, int yMin, int yMax, int zMin, int zMax) {
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int z = zMin; z <= zMax; ++z) {
                    found.add(new BlockPos(x, y, z));
                }
            }
        }
        return found;
    }

    public static boolean doBlockStatesMatch(BlockState replacedBlockState, BlockState newToPlace) {
        return replacedBlockState.equals(newToPlace);
    }

    public static BlockPos getFirstBlockAbove(Level world, BlockPos pos) {
        BlockPos posCurrent = null;
        for (int y = pos.m_123342_() + 1; y < 256; ++y) {
            posCurrent = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
            if (world.m_8055_(posCurrent).m_60734_() != Blocks.f_50016_ || world.m_8055_(posCurrent.m_7494_()).m_60734_() != Blocks.f_50016_ || world.m_8055_(posCurrent.m_7495_()).m_60734_() == Blocks.f_50016_) continue;
            return posCurrent;
        }
        return null;
    }

    public static BlockPos getLastAirBlockAbove(Level world, BlockPos pos) {
        return UtilWorld.getLastAirBlock(world, pos, Direction.UP);
    }

    public static BlockPos getLastAirBlockBelow(Level world, BlockPos pos) {
        return UtilWorld.getLastAirBlock(world, pos, Direction.DOWN);
    }

    public static BlockPos getLastAirBlock(Level world, BlockPos pos, Direction direction) {
        int increment = direction == Direction.DOWN ? -1 : 1;
        BlockPos posPrevious = pos;
        for (int y = pos.m_123342_(); y < 256 && y > 0; y += increment) {
            BlockPos posCurrent = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
            if (!world.m_46859_(posCurrent)) {
                return posPrevious;
            }
            posPrevious = posCurrent;
        }
        return pos;
    }

    public static boolean dimensionIsEqual(BlockPosDim targetPos, Level world) {
        if (targetPos == null || targetPos.getDimension() == null) {
            return false;
        }
        return targetPos.getDimension().equalsIgnoreCase(UtilWorld.dimensionToString(world));
    }
}

