/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.simplemagnets.DemagnetizationCoilTile;
import com.supermartijn642.simplemagnets.gui.DemagnetizationCoilContainer;
import com.supermartijn642.simplemagnets.gui.FilteredDemagnetizationCoilContainer;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class DemagnetizationCoilBlock
extends BaseBlock
implements EntityBlock {
    private static final BlockShape[] SHAPES;
    public static final EnumProperty<Direction> FACING;
    private final Supplier<Integer> maxRange;
    private final Supplier<Boolean> hasFilter;
    private final BiFunction<BlockPos, BlockState, ? extends DemagnetizationCoilTile> tileSupplier;

    public DemagnetizationCoilBlock(String registryName, Supplier<Integer> maxRange, Supplier<Boolean> hasFilter, BiFunction<BlockPos, BlockState, ? extends DemagnetizationCoilTile> tileSupplier) {
        super(registryName, false, BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60999_().m_60913_(3.0f, 5.0f).m_60918_(SoundType.f_56743_));
        this.maxRange = maxRange;
        this.hasFilter = hasFilter;
        this.tileSupplier = tileSupplier;
        this.m_49959_((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)Direction.DOWN));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, final BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.f_46443_) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return TextComponents.empty().get();
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
                    return DemagnetizationCoilBlock.this.hasFilter.get() != false ? new FilteredDemagnetizationCoilContainer(id, player, pos) : new DemagnetizationCoilContainer(id, player, pos);
                }
            }, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5871_(ItemStack stack, BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.hasFilter.get().booleanValue()) {
            tooltip.add((Component)TextComponents.translation((String)"simplemagnets.demagnetization_coil.info.filtered", (Object[])new Object[]{TextComponents.number((int)this.maxRange.get()).color(ChatFormatting.GOLD).get()}).color(ChatFormatting.GRAY).get());
        } else {
            tooltip.add((Component)TextComponents.translation((String)"simplemagnets.demagnetization_coil.info.no_filter", (Object[])new Object[]{TextComponents.number((int)this.maxRange.get()).color(ChatFormatting.GOLD).get()}).color(ChatFormatting.GRAY).get());
        }
        super.m_5871_(stack, worldIn, tooltip, flagIn);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_43719_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.m_61143_(FACING)).m_122411_()].getUnderlying();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return (BlockEntity)this.tileSupplier.apply(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> blockEntityType) {
        return (world2, pos, state2, entity) -> {
            if (entity instanceof DemagnetizationCoilTile) {
                ((DemagnetizationCoilTile)entity).tick();
            }
        };
    }

    static {
        BlockShape shape = BlockShape.or((BlockShape)BlockShape.createBlockShape((double)7.0, (double)10.5, (double)7.0, (double)9.0, (double)11.0, (double)9.0), (BlockShape[])new BlockShape[]{BlockShape.createBlockShape((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)1.0, (double)11.5), BlockShape.createBlockShape((double)6.5, (double)2.0, (double)6.5, (double)9.5, (double)10.5, (double)9.5), BlockShape.createBlockShape((double)5.5, (double)1.0, (double)5.5, (double)10.5, (double)1.5, (double)10.5), BlockShape.createBlockShape((double)6.0, (double)1.5, (double)6.0, (double)10.0, (double)2.0, (double)10.0), BlockShape.createBlockShape((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0), BlockShape.createBlockShape((double)5.5, (double)8.0, (double)5.5, (double)10.5, (double)9.0, (double)10.5), BlockShape.createBlockShape((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0), BlockShape.createBlockShape((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), BlockShape.createBlockShape((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), BlockShape.createBlockShape((double)5.5, (double)4.0, (double)5.5, (double)10.5, (double)5.0, (double)10.5), BlockShape.createBlockShape((double)5.5, (double)6.0, (double)5.5, (double)10.5, (double)7.0, (double)10.5)});
        SHAPES = new BlockShape[Direction.values().length];
        DemagnetizationCoilBlock.SHAPES[Direction.DOWN.m_122411_()] = shape;
        DemagnetizationCoilBlock.SHAPES[Direction.UP.m_122411_()] = shape.rotate(Direction.Axis.X).rotate(Direction.Axis.X);
        DemagnetizationCoilBlock.SHAPES[Direction.NORTH.m_122411_()] = shape.rotate(Direction.Axis.X).rotate(Direction.Axis.X).rotate(Direction.Axis.X);
        DemagnetizationCoilBlock.SHAPES[Direction.EAST.m_122411_()] = shape.rotate(Direction.Axis.Z).rotate(Direction.Axis.Z).rotate(Direction.Axis.Z);
        DemagnetizationCoilBlock.SHAPES[Direction.SOUTH.m_122411_()] = shape.rotate(Direction.Axis.X);
        DemagnetizationCoilBlock.SHAPES[Direction.WEST.m_122411_()] = shape.rotate(Direction.Axis.Z);
        FACING = BlockStateProperties.f_61372_;
    }
}

