/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.OreBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeColorCalculator;
import xaero.map.biome.BiomeGetter;
import xaero.map.biome.BiomeKey;
import xaero.map.biome.BlockTintProvider;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.exception.SilentException;
import xaero.map.misc.CachedFunction;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;

public class MapWriter {
    public static final int NO_Y_VALUE = Short.MAX_VALUE;
    public static final int MAX_TRANSPARENCY_BLEND_DEPTH = 5;
    public static final String[] DEFAULT_RESOURCE = new String[]{"minecraft", ""};
    private int X;
    private int Z;
    private int playerChunkX;
    private int playerChunkZ;
    private int loadDistance;
    private int startTileChunkX;
    private int startTileChunkZ;
    private int endTileChunkX;
    private int endTileChunkZ;
    private int insideX;
    private int insideZ;
    private long updateCounter;
    private boolean clearCachedColours;
    private MapBlock loadingObject;
    private OverlayBuilder overlayBuilder;
    private final BlockPos.MutableBlockPos mutableLocalPos;
    private final BlockPos.MutableBlockPos mutableGlobalPos;
    private Random usedRandom = new Random(0L);
    private long lastWrite = -1L;
    private long lastWriteTry = -1L;
    private int workingFrameCount;
    private long framesFreedTime = -1L;
    public long writeFreeSinceLastWrite = -1L;
    private int writeFreeSizeTiles;
    private int writeFreeFullUpdateTargetTime;
    private MapProcessor mapProcessor;
    private ArrayList<BlockState> buggedStates;
    private BlockStateShortShapeCache blockStateShortShapeCache;
    private int topH;
    private final CachedFunction<StateHolder<?, ?>, Boolean> transparentCache;
    private int firstTransparentStateY;
    private final BlockPos.MutableBlockPos mutableBlockPos3;
    private CachedFunction<FluidState, BlockState> fluidToBlock;
    private BiomeGetter biomeGetter;
    private HashMap<String, Integer> textureColours;
    private HashMap<BlockState, Integer> blockColours;
    private BlockState lastBlockStateForTextureColor = null;
    private int lastBlockStateForTextureColorResult = -1;

    public MapWriter(OverlayManager overlayManager, BlockStateShortShapeCache blockStateShortShapeCache, BiomeGetter biomeGetter) {
        this.loadingObject = new MapBlock();
        this.textureColours = new HashMap();
        this.blockColours = new HashMap();
        this.overlayBuilder = new OverlayBuilder(overlayManager);
        this.mutableLocalPos = new BlockPos.MutableBlockPos();
        this.mutableGlobalPos = new BlockPos.MutableBlockPos();
        this.buggedStates = new ArrayList();
        this.blockStateShortShapeCache = blockStateShortShapeCache;
        this.transparentCache = new CachedFunction<StateHolder, Boolean>(state -> this.shouldOverlay((StateHolder<?, ?>)state));
        this.mutableBlockPos3 = new BlockPos.MutableBlockPos();
        this.fluidToBlock = new CachedFunction<FluidState, BlockState>(FluidState::m_76188_);
        this.biomeGetter = biomeGetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRender(BiomeColorCalculator biomeColorCalculator, OverlayManager overlayManager) {
        block20: {
            long before = System.nanoTime();
            try {
                if (WorldMap.crashHandler.getCrashedBy() != null) break block20;
                Object object = this.mapProcessor.renderThreadPauseSync;
                synchronized (object) {
                    if (!this.mapProcessor.isWritingPaused() && !this.mapProcessor.isWaitingForWorldUpdate() && this.mapProcessor.getMapSaveLoad().isRegionDetectionComplete() && this.mapProcessor.isCurrentMultiworldWritable()) {
                        if (this.mapProcessor.getWorld() == null || !this.mapProcessor.caveStartIsDetermined() || this.mapProcessor.isCurrentMapLocked()) {
                            return;
                        }
                        if (this.mapProcessor.getCurrentWorldId() != null && !this.mapProcessor.ignoreWorld((Level)this.mapProcessor.getWorld()) && (WorldMap.settings.updateChunks || WorldMap.settings.loadChunks)) {
                            long passed;
                            double playerZ;
                            double playerY;
                            double playerX;
                            Object object2 = this.mapProcessor.mainStuffSync;
                            synchronized (object2) {
                                if (this.mapProcessor.mainWorld != this.mapProcessor.getWorld()) {
                                    return;
                                }
                                playerX = this.mapProcessor.mainPlayerX;
                                playerY = this.mapProcessor.mainPlayerY;
                                playerZ = this.mapProcessor.mainPlayerZ;
                            }
                            XaeroWorldMapCore.ensureField();
                            int lengthX = this.endTileChunkX - this.startTileChunkX + 1;
                            int lengthZ = this.endTileChunkZ - this.startTileChunkZ + 1;
                            if (this.lastWriteTry == -1L) {
                                lengthX = 3;
                                lengthZ = 3;
                            }
                            int sizeTileChunks = lengthX * lengthZ;
                            int sizeTiles = sizeTileChunks * 4 * 4;
                            int sizeBasedTargetTime = sizeTiles * 1000 / 1500;
                            int fullUpdateTargetTime = Math.max(100, sizeBasedTargetTime);
                            long time = System.currentTimeMillis();
                            long l = passed = this.lastWrite == -1L ? 0L : time - this.lastWrite;
                            if (this.lastWriteTry == -1L || this.writeFreeSizeTiles != sizeTiles || this.writeFreeFullUpdateTargetTime != fullUpdateTargetTime || this.workingFrameCount > 30) {
                                this.framesFreedTime = time;
                                this.writeFreeSizeTiles = sizeTiles;
                                this.writeFreeFullUpdateTargetTime = fullUpdateTargetTime;
                                this.workingFrameCount = 0;
                            }
                            long sinceLastWrite = Math.min(passed, this.writeFreeSinceLastWrite);
                            if (this.framesFreedTime != -1L) {
                                sinceLastWrite = time - this.framesFreedTime;
                            }
                            long tilesToUpdate = Math.min(sinceLastWrite * (long)sizeTiles / (long)fullUpdateTargetTime, 100L);
                            if (this.lastWrite == -1L || tilesToUpdate != 0L) {
                                this.lastWrite = time;
                            }
                            if (tilesToUpdate != 0L) {
                                if (this.framesFreedTime == -1L) {
                                    int timeLimit = (int)(Math.min(sinceLastWrite, 50L) * 86960L);
                                    long writeStartNano = System.nanoTime();
                                    Registry<Biome> biomeRegistry = this.mapProcessor.worldBiomeRegistry;
                                    boolean loadChunks = WorldMap.settings.loadChunks;
                                    boolean updateChunks = WorldMap.settings.updateChunks;
                                    boolean ignoreHeightmaps = this.mapProcessor.getMapWorld().isIgnoreHeightmaps();
                                    boolean flowers = WorldMap.settings.flowers;
                                    boolean detailedDebug = WorldMap.settings.detailed_debug;
                                    BlockPos.MutableBlockPos mutableBlockPos3 = this.mutableBlockPos3;
                                    BlockTintProvider blockTintProvider = this.mapProcessor.getWorldBlockTintProvider();
                                    int i = 0;
                                    while ((long)i < tilesToUpdate) {
                                        this.writeMap((Level)this.mapProcessor.getWorld(), playerX, playerY, playerZ, biomeRegistry, biomeColorCalculator, overlayManager, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug, mutableBlockPos3, blockTintProvider);
                                        if (System.nanoTime() - writeStartNano >= (long)timeLimit) break;
                                        ++i;
                                    }
                                    ++this.workingFrameCount;
                                } else {
                                    this.writeFreeSinceLastWrite = sinceLastWrite;
                                    this.framesFreedTime = -1L;
                                }
                            }
                            this.lastWriteTry = time;
                        }
                    }
                }
            }
            catch (Throwable e) {
                WorldMap.crashHandler.setCrashedBy(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMap(Level world, double playerX, double playerY, double playerZ, Registry<Biome> biomeRegistry, BiomeColorCalculator biomeColorCalculator, OverlayManager overlayManager, boolean loadChunks, boolean updateChunks, boolean ignoreHeightmaps, boolean flowers, boolean detailedDebug, BlockPos.MutableBlockPos mutableBlockPos3, BlockTintProvider blockTintProvider) {
        boolean onlyLoad = loadChunks && (!updateChunks || this.updateCounter % 5L != 0L);
        Level level = world;
        synchronized (level) {
            if (this.insideX == 0 && this.insideZ == 0) {
                this.playerChunkX = (int)Math.floor(playerX) >> 4;
                this.playerChunkZ = (int)Math.floor(playerZ) >> 4;
                this.loadDistance = Minecraft.m_91087_().f_91066_.f_92106_;
                this.startTileChunkX = this.playerChunkX - this.loadDistance >> 2;
                this.startTileChunkZ = this.playerChunkZ - this.loadDistance >> 2;
                this.endTileChunkX = this.playerChunkX + this.loadDistance >> 2;
                this.endTileChunkZ = this.playerChunkZ + this.loadDistance >> 2;
            }
            this.writeChunk(world, this.loadDistance, onlyLoad, biomeRegistry, biomeColorCalculator, overlayManager, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug, mutableBlockPos3, blockTintProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChunk(Level world, int distance, boolean onlyLoad, Registry<Biome> biomeRegistry, BiomeColorCalculator biomeColorCalculator, OverlayManager overlayManager, boolean loadChunks, boolean updateChunks, boolean ignoreHeightmaps, boolean flowers, boolean detailedDebug, BlockPos.MutableBlockPos mutableBlockPos3, BlockTintProvider blockTintProvider) {
        int result = 1;
        int tileChunkX = this.startTileChunkX + this.X;
        int tileChunkZ = this.startTileChunkZ + this.Z;
        int tileChunkLocalX = tileChunkX & 7;
        int tileChunkLocalZ = tileChunkZ & 7;
        int regionX = tileChunkX >> 3;
        int regionZ = tileChunkZ >> 3;
        MapRegion region = this.mapProcessor.getMapRegion(regionX, regionZ, true);
        MapTileChunk tileChunk = null;
        MapTileChunk rightChunk = null;
        MapTileChunk bottomChunk = null;
        MapTileChunk bottomRightChunk = null;
        int worldBottomY = world.m_141937_();
        int worldTopY = world.m_151558_();
        Object object = region.writerThreadPauseSync;
        synchronized (object) {
            if (!region.isWritingPaused()) {
                boolean regionIsResting;
                MapRegion mapRegion = region;
                synchronized (mapRegion) {
                    if (region.getLoadState() == 2) {
                        region.registerVisit();
                    }
                    if (regionIsResting = region.isResting()) {
                        region.setBeingWritten(true);
                        tileChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ);
                        if (region.getLoadState() == 2 && tileChunk == null) {
                            tileChunk = new MapTileChunk(region, tileChunkX, tileChunkZ);
                            region.setChunk(tileChunkLocalX, tileChunkLocalZ, tileChunk);
                            tileChunk.setLoadState((byte)2);
                        } else if (!(region.reloadHasBeenRequested() || region.recacheHasBeenRequested() || region.getLoadState() != 0 && region.getLoadState() != 4)) {
                            this.mapProcessor.getMapSaveLoad().requestLoad(region, "writing");
                        }
                    }
                }
                if (regionIsResting && region.getLoadState() == 2 && tileChunk != null && tileChunk.getLoadState() == 2) {
                    if (!tileChunk.getLeafTexture().shouldUpload()) {
                        int caveStart = this.mapProcessor.getCaveStart();
                        int chunkX = tileChunkX * 4 + this.insideX;
                        int chunkZ = tileChunkZ * 4 + this.insideZ;
                        if (chunkX >= this.playerChunkX - distance && chunkX < this.playerChunkX + distance && chunkZ >= this.playerChunkZ - distance && chunkZ < this.playerChunkZ + distance) {
                            LevelChunk chunk = (LevelChunk)world.m_6522_(chunkX, chunkZ, ChunkStatus.f_62326_, false);
                            MapTile mapTile = tileChunk.getTile(this.insideX, this.insideZ);
                            boolean chunkUpdated = false;
                            try {
                                chunkUpdated = chunk != null && (mapTile == null || (Boolean)XaeroWorldMapCore.chunkCleanField.get(chunk) == false);
                            }
                            catch (IllegalAccessException | IllegalArgumentException e) {
                                throw new RuntimeException(e);
                            }
                            if (chunkUpdated && !(chunk instanceof EmptyLevelChunk)) {
                                boolean edgeChunk = false;
                                block16: for (int i = -1; i < 2; ++i) {
                                    for (int j = -1; j < 2; ++j) {
                                        LevelChunk neighbor;
                                        if (i == 0 && j == 0 || (neighbor = world.m_6325_(chunkX + i, chunkZ + j)) != null && !(neighbor instanceof EmptyLevelChunk)) continue;
                                        edgeChunk = true;
                                        break block16;
                                    }
                                }
                                if (!edgeChunk && (mapTile == null && loadChunks || mapTile != null && updateChunks && !onlyLoad)) {
                                    if (mapTile == null) {
                                        mapTile = this.mapProcessor.getTilePool().get(this.mapProcessor.getCurrentDimension(), chunkX, chunkZ);
                                        tileChunk.setChanged(true);
                                    }
                                    MapTileChunk prevTileChunk = tileChunk.getNeighbourTileChunk(0, -1, this.mapProcessor, false);
                                    MapTileChunk prevTileChunkDiagonal = tileChunk.getNeighbourTileChunk(-1, -1, this.mapProcessor, false);
                                    MapTileChunk prevTileChunkHorisontal = tileChunk.getNeighbourTileChunk(-1, 0, this.mapProcessor, false);
                                    int sectionBasedHeight = this.getSectionBasedHeight(chunk, 64);
                                    Heightmap.Types typeWorldSurface = Heightmap.Types.WORLD_SURFACE;
                                    MapTile bottomTile = this.insideZ < 3 ? tileChunk.getTile(this.insideX, this.insideZ + 1) : null;
                                    MapTile rightTile = this.insideX < 3 ? tileChunk.getTile(this.insideX + 1, this.insideZ) : null;
                                    for (int x = 0; x < 16; ++x) {
                                        for (int z = 0; z < 16; ++z) {
                                            int startHeight;
                                            if (caveStart != Short.MAX_VALUE) {
                                                startHeight = caveStart;
                                            } else {
                                                int mappedHeight = chunk.m_5885_(typeWorldSurface, x, z);
                                                startHeight = ignoreHeightmaps || mappedHeight < worldBottomY ? sectionBasedHeight : mappedHeight;
                                            }
                                            if (startHeight >= worldTopY) {
                                                startHeight = worldTopY - 1;
                                            }
                                            MapBlock currentPixel = mapTile.isLoaded() ? mapTile.getBlock(x, z) : null;
                                            this.loadPixel(world, this.loadingObject, currentPixel, chunk, x, z, startHeight, worldBottomY, caveStart != Short.MAX_VALUE, mapTile.wasWrittenOnce(), biomeRegistry, flowers, worldBottomY, mutableBlockPos3);
                                            this.loadingObject.fixHeightType(x, z, mapTile, tileChunk, prevTileChunk, prevTileChunkDiagonal, prevTileChunkHorisontal, this.loadingObject.getEffectiveHeight(this.blockStateShortShapeCache), true, this.blockStateShortShapeCache);
                                            boolean equalsSlopesExcluded = this.loadingObject.equalsSlopesExcluded(currentPixel);
                                            boolean fullyEqual = this.loadingObject.equals(currentPixel, equalsSlopesExcluded);
                                            if (fullyEqual) continue;
                                            MapBlock loadedBlock = this.loadingObject;
                                            mapTile.setBlock(x, z, loadedBlock);
                                            this.loadingObject = currentPixel != null ? currentPixel : new MapBlock();
                                            if (!equalsSlopesExcluded) {
                                                boolean xEdge;
                                                tileChunk.setChanged(true);
                                                boolean zEdge = z == 15;
                                                boolean bl = xEdge = x == 15;
                                                if ((zEdge || xEdge) && (currentPixel == null || currentPixel.getEffectiveHeight(this.blockStateShortShapeCache) != loadedBlock.getEffectiveHeight(this.blockStateShortShapeCache))) {
                                                    if (zEdge) {
                                                        if (bottomTile == null && this.insideZ == 3 && tileChunkLocalZ < 7) {
                                                            if (bottomChunk == null && (bottomChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ + 1)) != null) {
                                                                bottomChunk.setChanged(true);
                                                            }
                                                            MapTile mapTile2 = bottomTile = bottomChunk != null ? bottomChunk.getTile(this.insideX, 0) : null;
                                                        }
                                                        if (bottomTile != null) {
                                                            bottomTile.getBlock(x, 0).setSlopeUnknown(true);
                                                            if (!xEdge) {
                                                                bottomTile.getBlock(x + 1, 0).setSlopeUnknown(true);
                                                            }
                                                        }
                                                        if (xEdge) {
                                                            MapTile bottomRightTile;
                                                            MapTile mapTile3 = bottomRightTile = this.insideX < 3 && this.insideZ < 3 ? tileChunk.getTile(this.insideX + 1, this.insideZ + 1) : null;
                                                            if (bottomRightTile == null && this.insideX == 3 && tileChunkLocalX < 7) {
                                                                if (this.insideZ == 3) {
                                                                    if (bottomRightChunk == null && tileChunkLocalZ < 7 && (bottomRightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ + 1)) != null) {
                                                                        bottomRightChunk.setChanged(true);
                                                                    }
                                                                    bottomRightTile = bottomRightChunk != null ? bottomRightChunk.getTile(0, 0) : null;
                                                                } else {
                                                                    if (rightChunk == null && (rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ)) != null) {
                                                                        rightChunk.setChanged(true);
                                                                    }
                                                                    MapTile mapTile4 = bottomRightTile = rightChunk != null ? rightChunk.getTile(0, this.insideZ + 1) : null;
                                                                }
                                                            }
                                                            if (bottomRightTile != null) {
                                                                bottomRightTile.getBlock(0, 0).setSlopeUnknown(true);
                                                            }
                                                        }
                                                    } else if (xEdge) {
                                                        if (rightTile == null && this.insideX == 3 && rightChunk == null && tileChunkLocalX < 7) {
                                                            rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ);
                                                            if (rightChunk != null) {
                                                                rightChunk.setChanged(true);
                                                            }
                                                            MapTile mapTile5 = rightTile = rightChunk != null ? rightChunk.getTile(0, this.insideZ) : null;
                                                        }
                                                        if (rightTile != null) {
                                                            rightTile.getBlock(0, z + 1).setSlopeUnknown(true);
                                                        }
                                                    }
                                                }
                                            }
                                            result = 3;
                                        }
                                    }
                                    mapTile.setWorldInterpretationVersion(1);
                                    tileChunk.setTile(this.insideX, this.insideZ, mapTile, this.blockStateShortShapeCache);
                                    mapTile.setWrittenOnce(true);
                                    mapTile.setLoaded(true);
                                    try {
                                        XaeroWorldMapCore.chunkCleanField.set(chunk, true);
                                    }
                                    catch (IllegalAccessException | IllegalArgumentException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            }
                        }
                    }
                    if (!tileChunk.includeInSave()) {
                        tileChunk = null;
                        region.setChunk(tileChunkX & 7, tileChunkZ & 7, null);
                    }
                }
            }
        }
        ++this.insideZ;
        if (this.insideZ > 3) {
            this.insideZ = 0;
            ++this.insideX;
            if (this.insideX > 3) {
                this.insideX = 0;
                object = region.writerThreadPauseSync;
                synchronized (object) {
                    if (tileChunk != null && !region.isWritingPaused()) {
                        boolean regionIsStillWritable = false;
                        MapRegion mapRegion = region;
                        synchronized (mapRegion) {
                            boolean bl = regionIsStillWritable = region.isResting() && region.getLoadState() == 2;
                            if (regionIsStillWritable) {
                                region.setBeingWritten(true);
                            }
                        }
                        if (regionIsStillWritable && tileChunk.wasChanged()) {
                            tileChunk.updateBuffers(this.mapProcessor, blockTintProvider, overlayManager, detailedDebug, this.blockStateShortShapeCache);
                            result += 2;
                            if (bottomChunk == null && tileChunkLocalZ < 7) {
                                bottomChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ + 1);
                            }
                            if (rightChunk == null && tileChunkLocalX < 7) {
                                rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ);
                            }
                            if (bottomRightChunk == null && tileChunkLocalX < 7 && tileChunkLocalZ < 7) {
                                bottomRightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ + 1);
                            }
                            if (bottomChunk != null && bottomChunk.wasChanged()) {
                                bottomChunk.updateBuffers(this.mapProcessor, blockTintProvider, overlayManager, detailedDebug, this.blockStateShortShapeCache);
                                bottomChunk.setChanged(false);
                                result += 2;
                            }
                            if (rightChunk != null && rightChunk.wasChanged()) {
                                rightChunk.setToUpdateBuffers(true);
                                rightChunk.setChanged(false);
                            }
                            if (bottomRightChunk != null && bottomRightChunk.wasChanged()) {
                                bottomRightChunk.setToUpdateBuffers(true);
                                bottomRightChunk.setChanged(false);
                            }
                            tileChunk.setChanged(false);
                        }
                    }
                }
                ++this.Z;
                if (this.Z > this.endTileChunkZ - this.startTileChunkZ) {
                    this.Z = 0;
                    ++this.X;
                    if (this.X > this.endTileChunkX - this.startTileChunkX) {
                        this.X = 0;
                        ++this.updateCounter;
                    }
                }
            }
        }
    }

    public int getSectionBasedHeight(LevelChunk bchunk, int startY) {
        LevelChunkSection searchedSection;
        int i;
        LevelChunkSection[] sections = bchunk.m_7103_();
        if (sections.length == 0) {
            return 0;
        }
        int chunkBottomY = bchunk.m_141937_();
        int playerSection = Math.min(startY - chunkBottomY >> 4, sections.length - 1);
        if (playerSection < 0) {
            playerSection = 0;
        }
        int result = 0;
        for (i = playerSection; i < sections.length; ++i) {
            searchedSection = sections[i];
            if (searchedSection.m_188008_()) continue;
            result = chunkBottomY + (i << 4) + 15;
        }
        if (playerSection > 0 && result == 0) {
            for (i = playerSection - 1; i >= 0; --i) {
                searchedSection = sections[i];
                if (searchedSection.m_188008_()) continue;
                result = chunkBottomY + (i << 4) + 15;
                break;
            }
        }
        return result;
    }

    public boolean isGlowing(BlockState state) {
        return (double)state.m_60791_() >= 0.5;
    }

    private boolean shouldOverlayCached(StateHolder<?, ?> state) {
        return this.transparentCache.apply(state);
    }

    public boolean shouldOverlay(StateHolder<?, ?> state) {
        if (state instanceof BlockState) {
            BlockState blockState = (BlockState)state;
            return blockState.m_60734_() instanceof AirBlock || blockState.m_60734_() instanceof GlassBlock || ItemBlockRenderTypes.canRenderInLayer((BlockState)blockState, (RenderType)RenderType.m_110466_());
        }
        FluidState fluidState = (FluidState)state;
        return ItemBlockRenderTypes.canRenderInLayer((FluidState)fluidState, (RenderType)RenderType.m_110466_());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInvisible(Level world, BlockState state, Block b, boolean flowers) {
        if (!(b instanceof LiquidBlock) && state.m_60799_() == RenderShape.INVISIBLE) {
            return true;
        }
        if (b == Blocks.f_50081_) {
            return true;
        }
        if (b == Blocks.f_50034_) {
            return true;
        }
        if (b instanceof DoublePlantBlock && !(b instanceof TallFlowerBlock)) {
            return true;
        }
        if ((b instanceof FlowerBlock || b instanceof TallFlowerBlock) && !flowers) {
            return true;
        }
        ArrayList<BlockState> arrayList = this.buggedStates;
        synchronized (arrayList) {
            if (this.buggedStates.contains(state)) {
                return true;
            }
        }
        MaterialColor materialColor = null;
        try {
            materialColor = state.m_60780_((BlockGetter)world, (BlockPos)this.mutableGlobalPos);
        }
        catch (Throwable t) {
            ArrayList<BlockState> arrayList2 = this.buggedStates;
            synchronized (arrayList2) {
                this.buggedStates.add(state);
            }
            WorldMap.LOGGER.info("Broken vanilla map color definition found: " + ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)b));
        }
        return materialColor == null || materialColor.f_76396_ == 0;
    }

    public void loadPixel(Level world, MapBlock pixel, MapBlock currentPixel, LevelChunk bchunk, int insideX, int insideZ, int highY, int lowY, boolean cave, boolean canReuseBiomeColours, Registry<Biome> biomeRegistry, boolean flowers, int worldBottomY, BlockPos.MutableBlockPos mutableBlockPos3) {
        pixel.prepareForWriting(worldBottomY);
        this.overlayBuilder.startBuilding();
        boolean underair = !cave;
        BlockState opaqueState = null;
        byte workingLight = -1;
        this.topH = lowY;
        this.mutableGlobalPos.m_122178_((bchunk.m_7697_().f_45578_ << 4) + insideX, lowY - 1, (bchunk.m_7697_().f_45579_ << 4) + insideZ);
        boolean shouldExtendTillTheBottom = false;
        int transparentSkipY = 0;
        int h = highY;
        while (h >= lowY) {
            Block b;
            this.mutableLocalPos.m_122178_(insideX, h, insideZ);
            BlockState state = bchunk.m_8055_((BlockPos)this.mutableLocalPos);
            FluidState fluidFluidState = bchunk.m_6425_((BlockPos)this.mutableLocalPos);
            boolean bl = shouldExtendTillTheBottom = !shouldExtendTillTheBottom && !this.overlayBuilder.isEmpty() && this.firstTransparentStateY - h >= 5;
            if (shouldExtendTillTheBottom) {
                for (transparentSkipY = h - 1; transparentSkipY >= lowY; --transparentSkipY) {
                    BlockState traceState = bchunk.m_8055_((BlockPos)mutableBlockPos3.m_122178_(insideX, transparentSkipY, insideZ));
                    FluidState traceFluidState = traceState.m_60819_();
                    if (!traceFluidState.m_76178_()) {
                        if (!this.shouldOverlayCached((StateHolder<?, ?>)traceFluidState)) break;
                        if (!(traceState.m_60734_() instanceof AirBlock) && traceState.m_60734_() == this.fluidToBlock.apply(traceFluidState).m_60734_()) continue;
                    }
                    if (!this.shouldOverlayCached((StateHolder<?, ?>)traceState)) break;
                }
            }
            this.mutableGlobalPos.m_142448_(h + 1);
            workingLight = (byte)world.m_45517_(LightLayer.BLOCK, (BlockPos)this.mutableGlobalPos);
            this.mutableGlobalPos.m_142448_(h);
            if (!fluidFluidState.m_76178_()) {
                underair = true;
                BlockState fluidState = this.fluidToBlock.apply(fluidFluidState);
                if (this.loadPixelHelp(pixel, currentPixel, world, fluidState, workingLight, bchunk, insideX, insideZ, h, canReuseBiomeColours, cave, fluidFluidState, biomeRegistry, transparentSkipY, shouldExtendTillTheBottom, flowers)) {
                    opaqueState = state;
                    break;
                }
            }
            if ((b = state.m_60734_()) instanceof AirBlock) {
                underair = true;
            } else if (underair && state != null && state.m_60734_() != this.fluidToBlock.apply(fluidFluidState).m_60734_() && this.loadPixelHelp(pixel, currentPixel, world, state, workingLight, bchunk, insideX, insideZ, h, canReuseBiomeColours, cave, null, biomeRegistry, transparentSkipY, shouldExtendTillTheBottom, flowers)) {
                opaqueState = state;
                break;
            }
            h = shouldExtendTillTheBottom ? transparentSkipY : h - 1;
        }
        if (h < lowY) {
            h = lowY;
        }
        BiomeKey blockBiome = null;
        BlockState state = opaqueState == null ? Blocks.f_50016_.m_49966_() : opaqueState;
        byte light = opaqueState == null ? (byte)0 : workingLight;
        this.overlayBuilder.finishBuilding(pixel);
        blockBiome = !canReuseBiomeColours || currentPixel == null || currentPixel.getState() != state ? this.biomeGetter.getBiome(world, (BlockPos)this.mutableGlobalPos, biomeRegistry) : currentPixel.getBiome();
        if (this.overlayBuilder.getOverlayBiome() != null) {
            blockBiome = this.overlayBuilder.getOverlayBiome();
        }
        boolean glowing = this.isGlowing(state);
        pixel.write(state, h, this.topH, blockBiome, light, glowing, cave);
    }

    private boolean loadPixelHelp(MapBlock pixel, MapBlock currentPixel, Level world, BlockState state, byte light, LevelChunk bchunk, int insideX, int insideZ, int h, boolean canReuseBiomeColours, boolean cave, FluidState fluidFluidState, Registry<Biome> biomeRegistry, int transparentSkipY, boolean shouldExtendTillTheBottom, boolean flowers) {
        Block b = state.m_60734_();
        if (this.shouldOverlayCached((StateHolder<?, ?>)(fluidFluidState == null ? state : fluidFluidState))) {
            if (h > this.topH) {
                this.topH = h;
            }
            if (this.overlayBuilder.isEmpty()) {
                this.firstTransparentStateY = h;
            }
            if (shouldExtendTillTheBottom) {
                this.overlayBuilder.getCurrentOverlay().increaseOpacity(this.overlayBuilder.getCurrentOverlay().getState().m_60739_((BlockGetter)world, (BlockPos)this.mutableGlobalPos) * (h - transparentSkipY));
            } else {
                BiomeKey overlayBiome = this.overlayBuilder.getOverlayBiome();
                if (overlayBiome == null) {
                    overlayBiome = canReuseBiomeColours && currentPixel != null && currentPixel.getNumberOfOverlays() > 0 && currentPixel.getOverlays().get(0).getState() == state ? currentPixel.getBiome() : this.biomeGetter.getBiome(world, (BlockPos)this.mutableGlobalPos, biomeRegistry);
                }
                this.overlayBuilder.build(state, state.m_60739_((BlockGetter)world, (BlockPos)this.mutableGlobalPos), light, this.mapProcessor, overlayBiome);
            }
            return false;
        }
        if (this.isInvisible(world, state, b, flowers)) {
            return false;
        }
        if (h > this.topH) {
            this.topH = h;
        }
        return true;
    }

    public int loadBlockColourFromTexture(BlockState state, boolean convert, Level world, BlockPos globalPos) {
        if (this.clearCachedColours) {
            this.textureColours.clear();
            this.blockColours.clear();
            this.lastBlockStateForTextureColor = null;
            this.lastBlockStateForTextureColorResult = -1;
            this.clearCachedColours = false;
            if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("Xaero's World Map cache cleared!");
            }
        }
        if (state == this.lastBlockStateForTextureColor) {
            return this.lastBlockStateForTextureColorResult;
        }
        Integer c = this.blockColours.get(state);
        int red = 0;
        int green = 0;
        int blue = 0;
        Block b = state.m_60734_();
        if (c == null) {
            Object name = null;
            try {
                Integer cachedColour;
                List upQuads = null;
                BlockModelShaper bms = Minecraft.m_91087_().m_91289_().m_110907_();
                if (convert) {
                    upQuads = bms.m_110893_(state).m_6840_(state, Direction.UP, this.usedRandom);
                }
                TextureAtlasSprite missingTexture = Minecraft.m_91087_().m_91304_().m_119428_(TextureAtlas.f_118259_).m_118316_((ResourceLocation)null);
                TextureAtlasSprite texture = upQuads == null || upQuads.isEmpty() || ((BakedQuad)upQuads.get(0)).m_173410_() == missingTexture ? bms.m_110882_(state) : ((BakedQuad)upQuads.get(0)).m_173410_();
                name = texture.m_118413_() + ".png";
                if (b instanceof OreBlock && b != Blocks.f_50331_) {
                    name = "minecraft:block/stone.png";
                }
                c = -1;
                String[] args = ((String)name).split(":");
                if (args.length < 2) {
                    MapWriter.DEFAULT_RESOURCE[1] = args[0];
                    args = DEFAULT_RESOURCE;
                }
                if ((cachedColour = this.textureColours.get(name)) == null) {
                    ResourceLocation location = new ResourceLocation(args[0], "textures/" + args[1]);
                    Resource resource = Minecraft.m_91087_().m_91098_().m_142591_(location);
                    InputStream input = resource.m_6679_();
                    BufferedImage img = ImageIO.read(input);
                    red = 0;
                    green = 0;
                    blue = 0;
                    int total = 0;
                    int ts = Math.min(img.getWidth(), img.getHeight());
                    if (ts > 0) {
                        int diff = Math.max(1, Math.min(4, ts / 8));
                        int parts = ts / diff;
                        for (int i = 0; i < parts; ++i) {
                            for (int j = 0; j < parts; ++j) {
                                int rgb = img.getRGB(i * diff, j * diff);
                                int alpha = rgb >> 24 & 0xFF;
                                if (rgb == 0 || alpha == 0) continue;
                                red += rgb >> 16 & 0xFF;
                                green += rgb >> 8 & 0xFF;
                                blue += rgb & 0xFF;
                                ++total;
                            }
                        }
                    }
                    input.close();
                    if (total == 0) {
                        total = 1;
                    }
                    if (convert && (red /= total) == 0 && (green /= total) == 0 && (blue /= total) == 0) {
                        throw new SilentException("Black texture " + ts);
                    }
                    c = 0xFF000000 | red << 16 | green << 8 | blue;
                    this.textureColours.put((String)name, c);
                } else {
                    c = cachedColour;
                }
            }
            catch (FileNotFoundException e) {
                if (convert) {
                    return this.loadBlockColourFromTexture(state, false, world, globalPos);
                }
                WorldMap.LOGGER.info("Block file not found: " + ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)b));
                c = 0;
                if (state != null && state.m_60780_((BlockGetter)world, globalPos) != null) {
                    c = state.m_60780_((BlockGetter)world, (BlockPos)globalPos).f_76396_;
                }
                if (name != null) {
                    this.textureColours.put((String)name, c);
                }
            }
            catch (Exception e) {
                WorldMap.LOGGER.info("Exception when loading " + ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)b) + " texture, using material colour.");
                c = 0;
                if (state.m_60780_((BlockGetter)world, globalPos) != null) {
                    c = state.m_60780_((BlockGetter)world, (BlockPos)globalPos).f_76396_;
                }
                if (name != null) {
                    this.textureColours.put((String)name, c);
                }
                if (e instanceof SilentException) {
                    WorldMap.LOGGER.info(e.getMessage());
                }
                WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            }
            if (c != null) {
                this.blockColours.put(state, c);
            }
        }
        this.lastBlockStateForTextureColor = state;
        this.lastBlockStateForTextureColorResult = c;
        return c;
    }

    public long getUpdateCounter() {
        return this.updateCounter;
    }

    public void resetPosition() {
        this.X = 0;
        this.Z = 0;
        this.insideX = 0;
        this.insideZ = 0;
    }

    public void requestCachedColoursClear() {
        this.clearCachedColours = true;
    }

    public void setMapProcessor(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }
}

