/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import xaero.map.WorldMap;
import xaero.map.animation.SlowingAnimation;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.map.gui.GuiMap;
import xaero.map.gui.IRightClickableElement;
import xaero.map.gui.RightClickOption;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.WaypointMenuElement;
import xaero.map.mods.gui.WaypointSymbolCreator;

public class Waypoint
extends WaypointMenuElement
implements Comparable<Waypoint>,
IRightClickableElement {
    private Object original;
    public static final ResourceLocation minimapTextures = new ResourceLocation("xaerobetterpvp", "gui/guis.png");
    public static final int white = -1;
    private int x;
    private int y;
    private int z;
    private String text;
    private String symbol;
    private int color;
    private boolean disabled = false;
    private int type = 0;
    private boolean rotation = false;
    private int yaw = 0;
    private float destAlpha = 0.0f;
    private float alpha = 0.0f;
    private SlowingAnimation alphaAnim = null;
    private boolean editable;
    private boolean temporary;
    private boolean global;
    private String setName;
    private boolean yIncluded;
    private ArrayList<RightClickOption> rightClickOptions;

    public Waypoint(Object original, int x, int y, int z, String name, String symbol, int color, int type, boolean editable, String setName, boolean yIncluded) {
        this.original = original;
        this.x = x;
        this.y = y;
        this.z = z;
        this.symbol = symbol;
        this.color = color;
        this.type = type;
        this.text = name;
        this.editable = editable;
        this.setName = setName;
        this.yIncluded = yIncluded;
        this.rightClickOptions = new ArrayList();
        this.rightClickOptions.add(new RightClickOption(name, this.rightClickOptions.size(), this){

            @Override
            public void onAction(Screen screen) {
                SupportMods.xaeroMinimap.openWaypoint((GuiMap)screen, Waypoint.this);
            }
        });
        if (!SupportMods.xaeroMinimap.hidingWaypointCoordinates()) {
            this.rightClickOptions.add(new RightClickOption(String.format("X: %d, Y: %s, Z: %d", x, this.yIncluded ? "" + y : "~", z), this.rightClickOptions.size(), this){

                @Override
                public void onAction(Screen screen) {
                    SupportMods.xaeroMinimap.openWaypoint((GuiMap)screen, Waypoint.this);
                }
            });
        }
        this.rightClickOptions.add(new RightClickOption("gui.xaero_right_click_waypoint_edit", this.rightClickOptions.size(), this){

            @Override
            public void onAction(Screen screen) {
                SupportMods.xaeroMinimap.openWaypoint((GuiMap)screen, Waypoint.this);
            }
        }.setNameFormatArgs("E"));
        this.rightClickOptions.add(new RightClickOption("gui.xaero_right_click_waypoint_teleport", this.rightClickOptions.size(), this){

            @Override
            public void onAction(Screen screen) {
                SupportMods.xaeroMinimap.teleportToWaypoint(screen, Waypoint.this);
            }

            @Override
            public boolean isActive() {
                return SupportMods.xaeroMinimap.canTeleport(SupportMods.xaeroMinimap.getWaypointWorld());
            }
        }.setNameFormatArgs("T"));
        this.rightClickOptions.add(new RightClickOption("gui.xaero_right_click_waypoint_share", this.rightClickOptions.size(), this){

            @Override
            public void onAction(Screen screen) {
                SupportMods.xaeroMinimap.shareWaypoint(Waypoint.this, (GuiMap)screen, SupportMods.xaeroMinimap.getWaypointWorld());
            }
        });
        this.rightClickOptions.add(new RightClickOption("", this.rightClickOptions.size(), this){

            @Override
            public String getName() {
                return Waypoint.this.temporary ? "gui.xaero_right_click_waypoint_restore" : (Waypoint.this.disabled ? "gui.xaero_right_click_waypoint_enable" : "gui.xaero_right_click_waypoint_disable");
            }

            @Override
            public void onAction(Screen screen) {
                if (Waypoint.this.temporary) {
                    SupportMods.xaeroMinimap.toggleTemporaryWaypoint(Waypoint.this);
                } else {
                    SupportMods.xaeroMinimap.disableWaypoint(Waypoint.this);
                }
            }
        }.setNameFormatArgs("H"));
        this.rightClickOptions.add(new RightClickOption("", this.rightClickOptions.size(), this){

            @Override
            public String getName() {
                return Waypoint.this.temporary ? "gui.xaero_right_click_waypoint_delete_confirm" : "gui.xaero_right_click_waypoint_delete";
            }

            @Override
            public void onAction(Screen screen) {
                if (Waypoint.this.temporary) {
                    SupportMods.xaeroMinimap.deleteWaypoint(Waypoint.this);
                } else {
                    SupportMods.xaeroMinimap.toggleTemporaryWaypoint(Waypoint.this);
                }
            }
        }.setNameFormatArgs("DEL"));
    }

    public String getName() {
        return I18n.m_118938_((String)this.text, (Object[])new Object[0]);
    }

    public void renderWaypoint(VertexConsumer waypointNameBGConsumer, MultiTextureRenderTypeRenderer uniquePremultipliedTextureUIObjectRenderer, PoseStack matrixStack, double wpScale, float x, float y, boolean viewing, TextureManager textureManager, Font fontRenderer, WaypointSymbolCreator symbolCreator, boolean renderBackground, MultiBufferSource.BufferSource renderTypeBuffers) {
        int symbolFrameWidth;
        float visibilityAlpha = this.disabled ? 0.3f : 1.0f;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, 0.0);
        matrixStack.m_85841_((float)wpScale, (float)wpScale, 1.0f);
        matrixStack.m_85836_();
        int color = this.color;
        String symbol = this.symbol;
        int type = this.type;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int flagU = 35;
        int flagV = 34;
        int flagW = 30;
        int flagH = 43;
        if (symbol.length() > 1) {
            flagU += 35;
            flagW += 13;
        }
        if (this.temporary) {
            flagU += 83;
        }
        matrixStack.m_85837_((double)((float)(-flagW) / 2.0f), (double)(-flagH + 1), 0.0);
        if (renderBackground) {
            MapRenderHelper.blitIntoMultiTextureRenderer(matrixStack.m_85850_().m_85861_(), uniquePremultipliedTextureUIObjectRenderer, 0, 0, flagU, flagV, flagW, flagH, red * visibilityAlpha, green * visibilityAlpha, blue * visibilityAlpha, visibilityAlpha, textureManager.m_118506_(WorldMap.guiTextures).m_117963_());
        }
        matrixStack.m_85849_();
        float oldDestAlpha = this.destAlpha;
        this.destAlpha = viewing ? 255.0f : 0.0f;
        if (oldDestAlpha != this.destAlpha) {
            this.alphaAnim = new SlowingAnimation(this.alpha, this.destAlpha, 0.8, 1.0);
        }
        if (this.alphaAnim != null) {
            this.alpha = (float)this.alphaAnim.getCurrent();
        }
        float alpha = this.alpha;
        int symbolTexture = 0;
        int symbolVerticalOffset = 0;
        int symbolWidth = 0;
        int stringWidth = fontRenderer.m_92895_(symbol);
        int n = symbolFrameWidth = stringWidth / 2 > 4 ? 64 : 32;
        if (type != 1 && alpha < 200.0f) {
            symbolVerticalOffset = 5;
            symbolWidth = (stringWidth - 1) * 3;
            symbolTexture = symbolCreator.getSymbolTexture(symbol);
        } else if (type == 1) {
            symbolVerticalOffset = 3;
            symbolWidth = 27;
            symbolTexture = symbolCreator.getDeathSymbolTexture();
        }
        if (symbolTexture != 0) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(-1.0f - (float)symbolWidth / 2.0f), (double)(32 + (renderBackground ? -43 + symbolVerticalOffset - 1 : -12)), 0.0);
            matrixStack.m_85841_(1.0f, -1.0f, 1.0f);
            MapRenderHelper.blitIntoMultiTextureRenderer(matrixStack.m_85850_().m_85861_(), uniquePremultipliedTextureUIObjectRenderer, 0, 0, 0, 0, symbolFrameWidth, 32, visibilityAlpha, visibilityAlpha, visibilityAlpha, visibilityAlpha, symbolFrameWidth, 32, symbolTexture);
            matrixStack.m_85849_();
        }
        if ((int)alpha > 0) {
            int tc = (int)alpha << 24 | 0xFFFFFF;
            String name = this.getName();
            int len = fontRenderer.m_92895_(name);
            matrixStack.m_85837_(0.0, (double)(renderBackground ? -38 : -11), 0.0);
            matrixStack.m_85841_(3.0f, 3.0f, 1.0f);
            int bgLen = Math.max(len + 2, 10);
            MapRenderHelper.fillIntoExistingBuffer(matrixStack.m_85850_().m_85861_(), waypointNameBGConsumer, -bgLen / 2, -1, bgLen / 2, 9, red, green, blue, alpha / 255.0f);
            MapRenderHelper.fillIntoExistingBuffer(matrixStack.m_85850_().m_85861_(), waypointNameBGConsumer, -bgLen / 2, -1, bgLen / 2, 8, 0.0f, 0.0f, 0.0f, alpha / 255.0f * 200.0f / 255.0f);
            if ((int)alpha > 3) {
                matrixStack.m_85837_(0.0, 0.0, 1.0);
                Misc.drawNormalText(matrixStack, name, (float)(-(len - 1)) / 2.0f, 0.0f, tc, false, renderTypeBuffers);
            }
        }
        matrixStack.m_85849_();
    }

    @Override
    public void renderInMenu(PoseStack matrixStack, Screen gui, int x, int y, int mouseX, int mouseY, double scale, boolean elementEnabled, boolean hovered, Minecraft mc, boolean pressed) {
        matrixStack.m_85836_();
        if (hovered) {
            matrixStack.m_85837_(pressed ? 1.0 : 2.0, 0.0, 0.0);
        }
        matrixStack.m_85837_((double)x, (double)y, 0.0);
        matrixStack.m_85841_((float)scale, (float)scale, 1.0f);
        matrixStack.m_85837_(-4.0, -4.0, 0.0);
        RenderSystem.m_69478_();
        if (this.type == 1) {
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)this.color);
            RenderSystem.m_157456_((int)0, (ResourceLocation)minimapTextures);
            RenderSystem.m_157429_((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            gui.m_93228_(matrixStack, 1, 1, 0, 78, 9, 9);
            RenderSystem.m_157429_((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            gui.m_93228_(matrixStack, 0, 0, 0, 78, 9, 9);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.m_69472_();
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)this.color);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.type != 1) {
            mc.f_91062_.m_92750_(matrixStack, this.symbol, (float)(5 - mc.f_91062_.m_92895_(this.symbol) / 2), 1.0f, -1);
        }
        Object name = this.getName();
        if (this.global) {
            name = "* " + (String)name;
        }
        int len = mc.f_91062_.m_92895_((String)name);
        int textX = -3 - len;
        int infoIconWidth = 10;
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)(textX - 2 - (this.disabled ? infoIconWidth : 0) - (this.temporary ? infoIconWidth : 0)), (int)-2, (int)(textX + len + 2), (int)11, (int)0x77000000);
        mc.f_91062_.m_92750_(matrixStack, (String)name, (float)textX, 0.0f, -1);
        RenderSystem.m_69478_();
        int infoIconOffset = infoIconWidth;
        if (this.disabled) {
            RenderSystem.m_69493_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)WorldMap.guiTextures);
            gui.m_93228_(matrixStack, textX - 1 - infoIconOffset, 0, 173, 16, 8, 8);
            infoIconOffset += infoIconWidth;
        }
        if (this.temporary) {
            RenderSystem.m_69493_();
            RenderSystem.m_157429_((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)WorldMap.guiTextures);
            gui.m_93228_(matrixStack, textX - 1 - infoIconOffset, 0, 165, 16, 8, 8);
            infoIconOffset += infoIconWidth;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.m_85849_();
    }

    public void renderShadow(float brightness, VertexConsumer regularUIObjectConsumer, PoseStack matrixStack, double wpScale, float x, float y, TextureManager textureManager) {
        float visibilityAlpha = this.disabled ? 0.3f : 1.0f;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, 0.0);
        matrixStack.m_85841_((float)wpScale, (float)wpScale, 1.0f);
        matrixStack.m_85837_(-14.0, -41.0, 0.0);
        MapRenderHelper.blitIntoExistingBuffer(matrixStack.m_85850_().m_85861_(), regularUIObjectConsumer, 0, 19, 0, 117, 41, 22, 0.0f, 0.0f, 0.0f, brightness * visibilityAlpha);
        matrixStack.m_85849_();
    }

    @Override
    public int compareTo(Waypoint arg0) {
        return this.z > arg0.z ? 1 : (this.z != arg0.z ? -1 : 0);
    }

    public String toString() {
        return this.getName();
    }

    public int getX() {
        return this.x;
    }

    public int getX(double dimDiv) {
        if (dimDiv == 1.0) {
            return this.x;
        }
        return (int)Math.floor((double)this.x / dimDiv);
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int getZ(double dimDiv) {
        if (dimDiv == 1.0) {
            return this.z;
        }
        return (int)Math.floor((double)this.z / dimDiv);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public int getType() {
        return this.type;
    }

    public int getYaw() {
        return this.yaw;
    }

    public void setYaw(int yaw) {
        this.yaw = yaw;
    }

    public boolean isRotation() {
        return this.rotation;
    }

    public void setRotation(boolean rotation) {
        this.rotation = rotation;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public Object getOriginal() {
        return this.original;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    @Override
    public int getLeftSideLength(Minecraft mc) {
        return 9 + mc.f_91062_.m_92895_(this.getName());
    }

    public String getSetName() {
        return this.setName;
    }

    public String getComparisonName() {
        String comparisonName = this.getName().toLowerCase().trim();
        if (comparisonName.startsWith("the ")) {
            comparisonName = comparisonName.substring(4);
        }
        if (comparisonName.startsWith("a ")) {
            comparisonName = comparisonName.substring(2);
        }
        return comparisonName;
    }

    @Override
    public ArrayList<RightClickOption> getRightClickOptions() {
        return this.rightClickOptions;
    }

    @Override
    public boolean isRightClickValid() {
        return SupportMods.xaeroMinimap.waypointExists(this);
    }

    @Override
    public int getRightClickTitleBackgroundColor() {
        return this.color;
    }

    public boolean isGlobal() {
        return this.global;
    }
}

