/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.settings;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.Option;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import xaero.map.WorldMap;
import xaero.map.gui.CursorBox;
import xaero.map.settings.ModSettings;
import xaero.map.settings.XaeroCyclingOption;
import xaero.map.settings.XaeroDoubleOption;

public class ModOptions {
    public static ModOptions DEBUG;
    public static ModOptions COLOURS;
    public static ModOptions LIGHTING;
    public static ModOptions UPDATE;
    public static ModOptions LOAD;
    public static ModOptions DEPTH;
    public static ModOptions SLOPES;
    public static ModOptions STEPS;
    public static ModOptions FLOWERS;
    public static ModOptions COMPRESSION;
    public static ModOptions COORDINATES;
    public static ModOptions BIOMES;
    public static ModOptions WAYPOINTS;
    public static ModOptions ARROW;
    public static ModOptions DISPLAY_ZOOM;
    public static ModOptions IGNORE_HEIGHTMAPS;
    public static ModOptions WAYPOINT_SCALE;
    public static ModOptions OPEN_ANIMATION;
    public static ModOptions RELOAD;
    public static ModOptions ZOOM_BUTTONS;
    public static ModOptions WAYPOINT_BACKGROUNDS;
    public static ModOptions PAUSE_REQUESTS;
    public static ModOptions EXTRA_DEBUG;
    public static ModOptions DETECT_AMBIGUOUS_Y;
    public static ModOptions UPDATE_NOTIFICATION;
    public static ModOptions ADJUST_HEIGHT_FOR_SHORT_BLOCKS;
    public static ModOptions MIN_ZOOM_LOCAL_WAYPOINTS;
    public static ModOptions ARROW_COLOUR;
    private final boolean enumDouble;
    final boolean enumBoolean;
    private final String enumString;
    private double valueMin;
    private double valueMax;
    private double valueStep;
    private Option mcOption;
    private CursorBox tooltip;
    private boolean ingameOnly;
    private boolean requiresMinimap;

    public static void init() {
        DEBUG = new ModOptions("gui.xaero_debug", false, false);
        COLOURS = new ModOptions("gui.xaero_block_colours", 2, false, false);
        LIGHTING = new ModOptions("gui.xaero_lighting", false, false);
        UPDATE = new ModOptions("gui.xaero_update_chunks", false, false);
        LOAD = new ModOptions("gui.xaero_load_chunks", false, false);
        DEPTH = new ModOptions("gui.xaero_terrain_depth", false, false);
        SLOPES = new ModOptions("gui.xaero_terrain_slopes", 4, false, false);
        STEPS = new ModOptions("gui.xaero_footsteps", false, false);
        FLOWERS = new ModOptions("gui.xaero_flowers", false, false);
        COMPRESSION = new ModOptions("gui.xaero_texture_compression", false, false);
        COORDINATES = new ModOptions("gui.xaero_wm_coordinates", false, false);
        BIOMES = new ModOptions("gui.xaero_biome_colors", false, false);
        WAYPOINTS = new ModOptions("gui.xaero_worldmap_waypoints", false, true);
        ARROW = new ModOptions("gui.xaero_render_arrow", false, false);
        DISPLAY_ZOOM = new ModOptions("gui.xaero_display_zoom", false, false);
        IGNORE_HEIGHTMAPS = new ModOptions("gui.xaero_wm_ignore_heightmaps", new CursorBox("gui.xaero_wm_box_ignore_heightmaps"), true, false);
        WAYPOINT_SCALE = new ModOptions("gui.xaero_wm_waypoint_scale", 0.5, 5.0, 0.5, false, true);
        OPEN_ANIMATION = new ModOptions("gui.xaero_open_map_animation", false, false);
        RELOAD = new ModOptions("gui.xaero_reload_everything", false, false);
        ZOOM_BUTTONS = new ModOptions("gui.xaero_zoom_buttons", false, false);
        WAYPOINT_BACKGROUNDS = new ModOptions("gui.xaero_waypoint_backgrounds", false, true);
        PAUSE_REQUESTS = new ModOptions("pause_requests", false, false);
        EXTRA_DEBUG = new ModOptions("extra_debug", false, false);
        DETECT_AMBIGUOUS_Y = new ModOptions("gui.xaero_wm_detect_ambiguous_y", new CursorBox("gui.xaero_wm_box_detect_ambiguous_y"), false, false);
        UPDATE_NOTIFICATION = new ModOptions("gui.xaero_wm_update_notification", false, false);
        ADJUST_HEIGHT_FOR_SHORT_BLOCKS = new ModOptions("gui.xaero_wm_adjust_height_for_carpetlike_blocks", new CursorBox("gui.xaero_wm_box_adjust_height_for_carpetlike_blocks"), false, false);
        MIN_ZOOM_LOCAL_WAYPOINTS = new ModOptions("gui.xaero_wm_min_zoom_local_waypoints", 0.0, 3.0, 0.01, false, true);
        ARROW_COLOUR = new ModOptions("gui.xaero_wm_arrow_colour", ModSettings.arrowColours.length + 2, new CursorBox("gui.xaero_wm_box_arrow_color"), false, false);
    }

    private ModOptions(String par3Str, boolean ingameOnly, boolean requiresMinimap) {
        this(par3Str, null, ingameOnly, requiresMinimap);
    }

    private ModOptions(String par3Str, CursorBox tooltip, boolean ingameOnly, boolean requiresMinimap) {
        this(par3Str, true, () -> Lists.newArrayList((Object[])new Boolean[]{false, true}), tooltip, ingameOnly, requiresMinimap);
    }

    private ModOptions(String par3Str, int optionCount, boolean ingameOnly, boolean requiresMinimap) {
        this(par3Str, optionCount, null, ingameOnly, requiresMinimap);
    }

    private ModOptions(String par3Str, int optionCount, CursorBox tooltip, boolean ingameOnly, boolean requiresMinimap) {
        this(par3Str, false, () -> {
            List optionsList = IntStream.rangeClosed(0, optionCount - 1).boxed().collect(Collectors.toList());
            return optionsList;
        }, tooltip, ingameOnly, requiresMinimap);
    }

    private <T> ModOptions(String par3Str, boolean isBoolean, Supplier<List<T>> optionsListSupplier, CursorBox tooltip, boolean ingameOnly, boolean requiresMinimap) {
        this.enumString = par3Str;
        this.enumBoolean = isBoolean;
        this.enumDouble = false;
        Supplier<Object> valueGetter = () -> WorldMap.settings.getOptionValue(this);
        Consumer<Object> valueSetter = v -> WorldMap.settings.setOptionValue(this, v);
        this.mcOption = new XaeroCyclingOption<Object>(this, optionsListSupplier.get(), valueGetter, valueSetter, () -> new TextComponent(WorldMap.settings.getOptionValueName(this)));
        this.tooltip = tooltip;
        this.ingameOnly = ingameOnly;
        this.requiresMinimap = requiresMinimap;
    }

    private ModOptions(String p_i45004_3_, double p_i45004_6_, double p_i45004_7_, double p_i45004_8_, boolean ingameOnly, boolean requiresMinimap) {
        this(p_i45004_3_, p_i45004_6_, p_i45004_7_, p_i45004_8_, null, ingameOnly, requiresMinimap);
    }

    private ModOptions(String p_i45004_3_, double p_i45004_6_, double p_i45004_7_, double p_i45004_8_, CursorBox tooltip, boolean ingameOnly, boolean requiresMinimap) {
        this.enumString = p_i45004_3_;
        this.enumBoolean = false;
        this.enumDouble = true;
        this.valueMin = p_i45004_6_;
        this.valueMax = p_i45004_7_;
        this.valueStep = p_i45004_8_;
        this.mcOption = new XaeroDoubleOption(this, p_i45004_6_, p_i45004_7_, (float)p_i45004_8_, gameSettings -> WorldMap.settings.getOptionDoubleValue(this), (gameSettings, option) -> WorldMap.settings.setOptionDoubleValue(this, (double)option), (gameSettings, option) -> new TextComponent(WorldMap.settings.getSliderOptionText(this)));
        this.tooltip = tooltip;
        this.ingameOnly = ingameOnly;
        this.requiresMinimap = requiresMinimap;
    }

    public boolean getEnumDouble() {
        return this.enumDouble;
    }

    public boolean getEnumBoolean() {
        return this.enumBoolean;
    }

    public double getValueMax() {
        return this.valueMax;
    }

    public void setValueMax(float p_148263_1_) {
        this.valueMax = p_148263_1_;
    }

    public double normalizeValue(double p_148266_1_) {
        return Mth.m_14008_((double)((this.snapToStepClamp(p_148266_1_) - this.valueMin) / (this.valueMax - this.valueMin)), (double)0.0, (double)1.0);
    }

    public double denormalizeValue(double p_148262_1_) {
        return this.snapToStepClamp(this.valueMin + (this.valueMax - this.valueMin) * Mth.m_14008_((double)p_148262_1_, (double)0.0, (double)1.0));
    }

    public double snapToStepClamp(double p_148268_1_) {
        p_148268_1_ = this.snapToStep(p_148268_1_);
        return Mth.m_14008_((double)p_148268_1_, (double)this.valueMin, (double)this.valueMax);
    }

    protected double snapToStep(double p_148264_1_) {
        if (this.valueStep > 0.0) {
            p_148264_1_ = this.valueStep * (double)Math.round(p_148264_1_ / this.valueStep);
        }
        return p_148264_1_;
    }

    public String getEnumString() {
        return I18n.m_118938_((String)this.enumString, (Object[])new Object[0]);
    }

    public Option getMcOption() {
        return this.mcOption;
    }

    public CursorBox getTooltip() {
        return this.tooltip;
    }

    public boolean isIngameOnly() {
        return this.ingameOnly;
    }

    public boolean requiresMinimap() {
        return this.requiresMinimap;
    }
}

