/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.client;

import com.mojang.blaze3d.platform.InputConstants;
import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ConfigData;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.client.RadialMenuScreen;
import dev.gigaherz.toolbelt.client.ToolBeltLayer;
import dev.gigaherz.toolbelt.customslots.ExtensionSlotSlot;
import dev.gigaherz.toolbelt.network.OpenBeltSlotInventory;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFW;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="toolbelt", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEvents {
    public static KeyMapping OPEN_TOOL_MENU_KEYBIND;
    public static KeyMapping CYCLE_TOOL_MENU_LEFT_KEYBIND;
    public static KeyMapping CYCLE_TOOL_MENU_RIGHT_KEYBIND;
    public static KeyMapping OPEN_BELT_SLOT_KEYBIND;
    private static boolean toolMenuKeyWasDown;
    public static ModelLayerLocation BELT_LAYER;

    public static void wipeOpen() {
        Minecraft.m_91087_().f_91068_.m_90926_(false);
        while (OPEN_TOOL_MENU_KEYBIND.m_90859_()) {
        }
    }

    public static void initKeybinds() {
        OPEN_TOOL_MENU_KEYBIND = new KeyMapping("key.toolbelt.open", 82, "key.toolbelt.category");
        ClientRegistry.registerKeyBinding((KeyMapping)OPEN_TOOL_MENU_KEYBIND);
        CYCLE_TOOL_MENU_LEFT_KEYBIND = new KeyMapping("key.toolbelt.cycle.left", InputConstants.f_84822_.m_84873_(), "key.toolbelt.category");
        ClientRegistry.registerKeyBinding((KeyMapping)CYCLE_TOOL_MENU_LEFT_KEYBIND);
        CYCLE_TOOL_MENU_RIGHT_KEYBIND = new KeyMapping("key.toolbelt.cycle.right", InputConstants.f_84822_.m_84873_(), "key.toolbelt.category");
        ClientRegistry.registerKeyBinding((KeyMapping)CYCLE_TOOL_MENU_RIGHT_KEYBIND);
        OPEN_BELT_SLOT_KEYBIND = new KeyMapping("key.toolbelt.slot", 86, "key.toolbelt.category");
        ClientRegistry.registerKeyBinding((KeyMapping)OPEN_BELT_SLOT_KEYBIND);
    }

    @SubscribeEvent
    public static void handleKeys(TickEvent.ClientTickEvent ev) {
        if (ev.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ == null) {
            boolean toolMenuKeyIsDown = OPEN_TOOL_MENU_KEYBIND.m_90857_();
            if (toolMenuKeyIsDown && !toolMenuKeyWasDown) {
                while (OPEN_TOOL_MENU_KEYBIND.m_90859_()) {
                    ItemStack inHand;
                    if (mc.f_91080_ != null || !ConfigData.isItemStackAllowed(inHand = mc.f_91074_.m_21205_())) continue;
                    BeltFinder.findBelt((LivingEntity)mc.f_91074_).ifPresent(getter -> mc.m_91152_((Screen)new RadialMenuScreen((BeltFinder.BeltGetter)getter)));
                }
            }
            toolMenuKeyWasDown = toolMenuKeyIsDown;
        } else {
            toolMenuKeyWasDown = true;
        }
        if (ConfigData.customBeltSlotEnabled) {
            while (OPEN_BELT_SLOT_KEYBIND.m_90859_()) {
                if (mc.f_91080_ != null) continue;
                ToolBelt.channel.sendToServer((Object)new OpenBeltSlotInventory());
            }
        }
    }

    public static boolean isKeyDown(KeyMapping keybind) {
        if (keybind.m_90862_()) {
            return false;
        }
        boolean isDown = switch (keybind.getKey().m_84868_()) {
            case InputConstants.Type.KEYSYM -> InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keybind.getKey().m_84873_());
            case InputConstants.Type.MOUSE -> {
                if (GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keybind.getKey().m_84873_()) == 1) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
        return isDown && keybind.getKeyConflictContext().isActive() && keybind.getKeyModifier().isActive(keybind.getKeyConflictContext());
    }

    static {
        toolMenuKeyWasDown = false;
        BELT_LAYER = new ModelLayerLocation(new ResourceLocation("minecraft:player"), "toolbelt_belt");
    }

    @Mod.EventBusSubscriber(modid="toolbelt", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void textureStitch(TextureStitchEvent.Pre event) {
            if (event.getAtlas().m_118330_() == InventoryMenu.f_39692_) {
                event.addSprite(ExtensionSlotSlot.SLOT_BACKGROUND);
            }
        }

        @SubscribeEvent
        public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(BELT_LAYER, ToolBeltLayer.BeltModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void construct(EntityRenderersEvent.AddLayers event) {
            ModBusEvents.addLayerToEntity(event, EntityType.f_20529_);
            ModBusEvents.addLayerToEntity(event, EntityType.f_20501_);
            ModBusEvents.addLayerToEntity(event, EntityType.f_20524_);
            ModBusEvents.addLayerToEntity(event, EntityType.f_20458_);
            ModBusEvents.addLayerToEntity(event, EntityType.f_20562_);
            ModBusEvents.addLayerToEntity(event, EntityType.f_20481_);
            ModBusEvents.addLayerToPlayerSkin(event, "default");
            ModBusEvents.addLayerToPlayerSkin(event, "slim");
        }

        private static void addLayerToPlayerSkin(EntityRenderersEvent.AddLayers event, String skinName) {
            LivingEntityRenderer render = event.getSkin(skinName);
            if (render instanceof LivingEntityRenderer) {
                LivingEntityRenderer livingRenderer = render;
                livingRenderer.m_115326_(new ToolBeltLayer(livingRenderer));
            }
        }

        private static <T extends LivingEntity, M extends HumanoidModel<T>, R extends LivingEntityRenderer<T, M>> void addLayerToEntity(EntityRenderersEvent.AddLayers event, EntityType<? extends T> entityType) {
            LivingEntityRenderer renderer = event.getRenderer(entityType);
            if (renderer != null) {
                renderer.m_115326_(new ToolBeltLayer(renderer));
            }
        }
    }
}

