/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts;

import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.comforts.client.ClientEventHandler;
import top.theillusivec4.comforts.client.renderer.ComfortsBaseTileEntityRenderer;
import top.theillusivec4.comforts.client.renderer.HammockTileEntityRenderer;
import top.theillusivec4.comforts.client.renderer.SleepingBagTileEntityRenderer;
import top.theillusivec4.comforts.common.ComfortsConfig;
import top.theillusivec4.comforts.common.ComfortsRegistry;
import top.theillusivec4.comforts.common.CommonEventHandler;
import top.theillusivec4.comforts.common.block.HammockBlock;
import top.theillusivec4.comforts.common.block.RopeAndNailBlock;
import top.theillusivec4.comforts.common.block.SleepingBagBlock;
import top.theillusivec4.comforts.common.capability.CapabilitySleepData;
import top.theillusivec4.comforts.common.item.ComfortsBaseItem;
import top.theillusivec4.comforts.common.item.HammockItem;
import top.theillusivec4.comforts.common.item.SleepingBagItem;
import top.theillusivec4.comforts.common.network.ComfortsNetwork;
import top.theillusivec4.comforts.common.tileentity.HammockTileEntity;
import top.theillusivec4.comforts.common.tileentity.SleepingBagTileEntity;
import top.theillusivec4.comforts.data.ComfortsLootProvider;

@Mod(value="comforts")
public final class ComfortsMod {
    public static final String MOD_ID = "comforts";
    public static final CreativeModeTab CREATIVE_TAB = new CreativeModeTab(-1, "comforts"){

        @Nonnull
        @OnlyIn(value=Dist.CLIENT)
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ComfortsRegistry.SLEEPING_BAGS.get(DyeColor.RED));
        }
    };
    public static final Logger LOGGER = LogManager.getLogger();

    public ComfortsMod() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::gatherData);
        eventBus.addListener(this::config);
        eventBus.addListener(this::registerCapabilities);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ComfortsConfig.SERVER_SPEC);
    }

    private void config(ModConfigEvent evt) {
        if (evt.getConfig().getModId().equals(MOD_ID)) {
            ComfortsConfig.bake();
        }
    }

    private void gatherData(GatherDataEvent evt) {
        DataGenerator generator = evt.getGenerator();
        if (evt.includeServer()) {
            generator.m_123914_((DataProvider)new ComfortsLootProvider(generator));
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent evt) {
        evt.register(CapabilitySleepData.ISleepData.class);
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new CommonEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CapabilitySleepData.CapabilityEvents());
        ComfortsNetwork.register();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> evt) {
            IForgeRegistry registry = evt.getRegistry();
            Arrays.stream(DyeColor.values()).forEach(color -> {
                SleepingBagBlock sleepingBag = new SleepingBagBlock((DyeColor)color);
                ComfortsRegistry.SLEEPING_BAGS.put((DyeColor)color, (Block)sleepingBag);
                HammockBlock hammock = new HammockBlock((DyeColor)color);
                ComfortsRegistry.HAMMOCKS.put((DyeColor)color, (Block)hammock);
                registry.registerAll((IForgeRegistryEntry[])new Block[]{sleepingBag, hammock});
            });
            registry.register((IForgeRegistryEntry)new RopeAndNailBlock());
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> evt) {
            IForgeRegistry registry = evt.getRegistry();
            ComfortsRegistry.SLEEPING_BAGS.values().forEach(block -> registry.register((IForgeRegistryEntry)new SleepingBagItem((Block)block)));
            ComfortsRegistry.HAMMOCKS.values().forEach(block -> registry.register((IForgeRegistryEntry)new HammockItem((Block)block)));
            registry.register((IForgeRegistryEntry)new ComfortsBaseItem(ComfortsRegistry.ROPE_AND_NAIL));
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<BlockEntityType<?>> evt) {
            BlockEntityType sleepingBag = (BlockEntityType)BlockEntityType.Builder.m_155273_(SleepingBagTileEntity::new, (Block[])ComfortsRegistry.SLEEPING_BAGS.values().toArray(new Block[0])).m_58966_(null).setRegistryName(ComfortsMod.MOD_ID, "sleeping_bag");
            BlockEntityType hammock = (BlockEntityType)BlockEntityType.Builder.m_155273_(HammockTileEntity::new, (Block[])ComfortsRegistry.HAMMOCKS.values().toArray(new Block[0])).m_58966_(null).setRegistryName(ComfortsMod.MOD_ID, "hammock");
            evt.getRegistry().registerAll((IForgeRegistryEntry[])new BlockEntityType[]{sleepingBag, hammock});
        }
    }

    @Mod.EventBusSubscriber(modid="comforts", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientProxy {
        @SubscribeEvent
        public static void setupClient(FMLClientSetupEvent evt) {
            MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
            ItemBlockRenderTypes.setRenderLayer((Block)ComfortsRegistry.ROPE_AND_NAIL, (RenderType)RenderType.m_110466_());
        }

        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers evt) {
            evt.registerBlockEntityRenderer(ComfortsRegistry.SLEEPING_BAG_TE, SleepingBagTileEntityRenderer::new);
            evt.registerBlockEntityRenderer(ComfortsRegistry.HAMMOCK_TE, HammockTileEntityRenderer::new);
        }

        @SubscribeEvent
        public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions evt) {
            evt.registerLayerDefinition(ComfortsBaseTileEntityRenderer.SLEEPING_BAG_HEAD, SleepingBagTileEntityRenderer::createHeadLayer);
            evt.registerLayerDefinition(ComfortsBaseTileEntityRenderer.SLEEPING_BAG_FOOT, SleepingBagTileEntityRenderer::createFootLayer);
            evt.registerLayerDefinition(ComfortsBaseTileEntityRenderer.HAMMOCK_HEAD, HammockTileEntityRenderer::createHeadLayer);
            evt.registerLayerDefinition(ComfortsBaseTileEntityRenderer.HAMMOCK_FOOT, HammockTileEntityRenderer::createFootLayer);
        }

        @SubscribeEvent
        public static void textureStitch(TextureStitchEvent.Pre evt) {
            if (evt.getAtlas().m_118330_() == InventoryMenu.f_39692_) {
                for (DyeColor color : DyeColor.values()) {
                    evt.addSprite(new ResourceLocation(ComfortsMod.MOD_ID, "entity/hammock/" + color.m_41065_()));
                    evt.addSprite(new ResourceLocation(ComfortsMod.MOD_ID, "entity/sleeping_bag/" + color.m_41065_()));
                }
            }
        }
    }
}

