/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.data;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EffectsChangedTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.PlacedBlockTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vectorwing.farmersdelight.common.advancement.CuttingBoardTrigger;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModEffects;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.utility.TextUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class Advancements
extends AdvancementProvider {
    private final Path PATH;
    public static final Logger LOGGER = LogManager.getLogger();

    public Advancements(DataGenerator generatorIn) {
        super(generatorIn);
        this.PATH = generatorIn.m_123916_();
    }

    public void m_6865_(HashCache cache) {
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.m_138327_());
            }
            Path path1 = Advancements.getPath(this.PATH, advancement);
            try {
                DataProvider.m_123920_((Gson)new GsonBuilder().setPrettyPrinting().create(), (HashCache)cache, (JsonElement)advancement.m_138313_().m_138400_(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        new FarmersDelightAdvancements().accept(consumer);
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.m_138327_().m_135827_() + "/advancements/" + advancementIn.m_138327_().m_135815_() + ".json");
    }

    public static class FarmersDelightAdvancements
    implements Consumer<Consumer<Advancement>> {
        @Override
        public void accept(Consumer<Advancement> consumer) {
            Advancement farmersDelight = Advancement.Builder.m_138353_().m_138371_((ItemLike)ModItems.COOKING_POT.get(), (Component)TextUtils.getTranslation("advancement.root", new Object[0]), (Component)TextUtils.getTranslation("advancement.root.desc", new Object[0]), new ResourceLocation("minecraft:textures/block/bricks.png"), FrameType.TASK, false, false, false).m_138386_("seeds", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[0])).m_138389_(consumer, this.getNameId("main/root"));
            Advancement huntAndGather = FarmersDelightAdvancements.getAdvancement(farmersDelight, (ItemLike)ModItems.FLINT_KNIFE.get(), "craft_knife", FrameType.TASK, true, true, false).m_138386_("flint_knife", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.FLINT_KNIFE.get()})).m_138386_("iron_knife", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.IRON_KNIFE.get()})).m_138386_("diamond_knife", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.DIAMOND_KNIFE.get()})).m_138386_("golden_knife", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.GOLDEN_KNIFE.get()})).m_138386_("netherite_knife", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.NETHERITE_KNIFE.get()})).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, this.getNameId("main/craft_knife"));
            Advancement graspingAtStraws = FarmersDelightAdvancements.getAdvancement(huntAndGather, (ItemLike)ModItems.STRAW.get(), "harvest_straw", FrameType.TASK, true, true, false).m_138386_("harvest_straw", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STRAW.get()})).m_138389_(consumer, this.getNameId("main/harvest_straw"));
            Advancement wildButcher = FarmersDelightAdvancements.getAdvancement(huntAndGather, (ItemLike)ModItems.HAM.get(), "get_ham", FrameType.TASK, true, true, false).m_138386_("ham", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.HAM.get()})).m_138389_(consumer, this.getNameId("main/get_ham"));
            Advancement dippingYourRoots = FarmersDelightAdvancements.getAdvancement(graspingAtStraws, (ItemLike)ModItems.RICE_PANICLE.get(), "plant_rice", FrameType.TASK, true, true, false).m_138386_("plant_rice", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)((Block)ModBlocks.RICE_CROP.get()))).m_138389_(consumer, this.getNameId("main/plant_rice"));
            Advancement cropRotation = FarmersDelightAdvancements.getAdvancement(dippingYourRoots, (ItemLike)ModItems.CABBAGE.get(), "plant_all_crops", FrameType.CHALLENGE, true, true, false).m_138386_("wheat", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)Blocks.f_50092_)).m_138386_("beetroot", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)Blocks.f_50444_)).m_138386_("carrot", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)Blocks.f_50249_)).m_138386_("potato", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)Blocks.f_50250_)).m_138386_("brown_mushroom", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)Blocks.f_50072_)).m_138386_("red_mushroom", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)Blocks.f_50073_)).m_138386_("sugar_cane", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)Blocks.f_50130_)).m_138386_("melon", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)Blocks.f_50190_)).m_138386_("pumpkin", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)Blocks.f_50189_)).m_138386_("sweet_berries", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)Blocks.f_50685_)).m_138386_("cocoa", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)Blocks.f_50262_)).m_138386_("cabbage", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)((Block)ModBlocks.CABBAGE_CROP.get()))).m_138386_("tomato", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)((Block)ModBlocks.TOMATO_CROP.get()))).m_138386_("onion", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)((Block)ModBlocks.ONION_CROP.get()))).m_138386_("rice", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)((Block)ModBlocks.RICE_CROP.get()))).m_138386_("nether_wart", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)Blocks.f_50200_)).m_138386_("chorus_flower", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)Blocks.f_50491_)).m_138354_(AdvancementRewards.Builder.m_10005_((int)100)).m_138389_(consumer, this.getNameId("main/plant_all_crops"));
            Advancement plantFood = FarmersDelightAdvancements.getAdvancement(dippingYourRoots, (ItemLike)ModItems.RICH_SOIL.get(), "get_rich_soil", FrameType.GOAL, true, true, false).m_138386_("get_rich_soil", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.RICH_SOIL.get()})).m_138389_(consumer, this.getNameId("main/get_rich_soil"));
            Advancement fungusAmongUs = FarmersDelightAdvancements.getAdvancement(plantFood, (ItemLike)ModItems.RED_MUSHROOM_COLONY.get(), "get_mushroom_colony", FrameType.TASK, true, true, false).m_138386_("brown_mushroom_colony", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BROWN_MUSHROOM_COLONY.get()})).m_138386_("red_mushroom_colony", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.RED_MUSHROOM_COLONY.get()})).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, this.getNameId("main/get_mushroom_colony"));
            Advancement cantTakeTheHeat = FarmersDelightAdvancements.getAdvancement(huntAndGather, (ItemLike)ModItems.NETHERITE_KNIFE.get(), "obtain_netherite_knife", FrameType.CHALLENGE, true, true, false).m_138386_("obtain_netherite_knife", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.NETHERITE_KNIFE.get()})).m_138354_(AdvancementRewards.Builder.m_10005_((int)200)).m_138389_(consumer, this.getNameId("main/obtain_netherite_knife"));
            Advancement bonfireLit = FarmersDelightAdvancements.getAdvancement(farmersDelight, (ItemLike)Blocks.f_50683_, "place_campfire", FrameType.TASK, true, true, false).m_138386_("campfire", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)Blocks.f_50683_)).m_138386_("soul_campfire", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)Blocks.f_50684_)).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, this.getNameId("main/place_campfire"));
            Advancement fireUpTheGrill = FarmersDelightAdvancements.getAdvancement(bonfireLit, (ItemLike)ModItems.STOVE.get(), "place_stove", FrameType.TASK, true, true, false).m_138386_("stove", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)((Block)ModBlocks.STOVE.get()))).m_138389_(consumer, this.getNameId("main/place_stove"));
            Advancement dinnerIsServed = FarmersDelightAdvancements.getAdvancement(fireUpTheGrill, (ItemLike)ModItems.COOKING_POT.get(), "place_cooking_pot", FrameType.GOAL, true, true, false).m_138386_("cooking_pot", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)((Block)ModBlocks.COOKING_POT.get()))).m_138389_(consumer, this.getNameId("main/place_cooking_pot"));
            Advancement portableCooking = FarmersDelightAdvancements.getAdvancement(fireUpTheGrill, (ItemLike)ModItems.SKILLET.get(), "use_skillet", FrameType.TASK, true, true, false).m_138386_("skillet", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.SKILLET.get()))).m_138389_(consumer, this.getNameId("main/use_skillet"));
            Advancement sizzlingHot = FarmersDelightAdvancements.getAdvancement(portableCooking, (ItemLike)ModItems.SKILLET.get(), "place_skillet", FrameType.TASK, true, true, false).m_138386_("skillet", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)((Block)ModBlocks.SKILLET.get()))).m_138389_(consumer, this.getNameId("main/place_skillet"));
            Advancement cupOfHappiness = FarmersDelightAdvancements.getAdvancement(dinnerIsServed, (ItemLike)ModItems.HOT_COCOA.get(), "drink_hot_cocoa", FrameType.TASK, true, true, false).m_138386_("hot_cocoa", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.HOT_COCOA.get()))).m_138389_(consumer, this.getNameId("main/drink_hot_cocoa"));
            Advancement warmAndCozy = FarmersDelightAdvancements.getAdvancement(dinnerIsServed, (ItemLike)ModItems.CHICKEN_SOUP.get(), "eat_comfort_food", FrameType.TASK, true, true, false).m_138386_("comfort", (CriterionTriggerInstance)EffectsChangedTrigger.TriggerInstance.m_26780_((MobEffectsPredicate)MobEffectsPredicate.m_56552_().m_56553_((MobEffect)ModEffects.COMFORT.get()))).m_138389_(consumer, this.getNameId("main/eat_comfort_food"));
            Advancement wellServed = FarmersDelightAdvancements.getAdvancement(warmAndCozy, (ItemLike)ModItems.STEAK_AND_POTATOES.get(), "eat_nourishing_food", FrameType.TASK, true, true, false).m_138386_("nourished", (CriterionTriggerInstance)EffectsChangedTrigger.TriggerInstance.m_26780_((MobEffectsPredicate)MobEffectsPredicate.m_56552_().m_56553_((MobEffect)ModEffects.NOURISHMENT.get()))).m_138389_(consumer, this.getNameId("main/eat_nourishing_food"));
            Advancement gloriousFeast = FarmersDelightAdvancements.getAdvancement(wellServed, (ItemLike)ModItems.ROAST_CHICKEN_BLOCK.get(), "place_feast", FrameType.TASK, true, true, false).m_138386_("roast_chicken", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)((Block)ModBlocks.ROAST_CHICKEN_BLOCK.get()))).m_138386_("stuffed_pumpkin", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)((Block)ModBlocks.STUFFED_PUMPKIN_BLOCK.get()))).m_138386_("honey_glazed_ham", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)((Block)ModBlocks.HONEY_GLAZED_HAM_BLOCK.get()))).m_138386_("shepherds_pie", (CriterionTriggerInstance)PlacedBlockTrigger.TriggerInstance.m_59505_((Block)((Block)ModBlocks.SHEPHERDS_PIE_BLOCK.get()))).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, this.getNameId("main/place_feast"));
            Advancement watchYourFingers = FarmersDelightAdvancements.getAdvancement(fireUpTheGrill, (ItemLike)ModItems.CUTTING_BOARD.get(), "use_cutting_board", FrameType.TASK, true, true, false).m_138386_("cutting_board", (CriterionTriggerInstance)CuttingBoardTrigger.Instance.simple()).m_138389_(consumer, this.getNameId("main/use_cutting_board"));
            Advancement masterChef = FarmersDelightAdvancements.getAdvancement(gloriousFeast, (ItemLike)ModItems.HONEY_GLAZED_HAM.get(), "master_chef", FrameType.CHALLENGE, true, true, false).m_138386_("mixed_salad", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.MIXED_SALAD.get()))).m_138386_("beef_stew", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.BEEF_STEW.get()))).m_138386_("chicken_soup", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.CHICKEN_SOUP.get()))).m_138386_("vegetable_soup", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.VEGETABLE_SOUP.get()))).m_138386_("fish_stew", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.FISH_STEW.get()))).m_138386_("fried_rice", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.FRIED_RICE.get()))).m_138386_("pumpkin_soup", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.PUMPKIN_SOUP.get()))).m_138386_("baked_cod_stew", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.BAKED_COD_STEW.get()))).m_138386_("noodle_soup", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.NOODLE_SOUP.get()))).m_138386_("pasta_with_meatballs", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.PASTA_WITH_MEATBALLS.get()))).m_138386_("pasta_with_mutton_chop", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.PASTA_WITH_MUTTON_CHOP.get()))).m_138386_("roasted_mutton_chops", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.ROASTED_MUTTON_CHOPS.get()))).m_138386_("vegetable_noodles", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.VEGETABLE_NOODLES.get()))).m_138386_("steak_and_potatoes", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.STEAK_AND_POTATOES.get()))).m_138386_("ratatouille", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.RATATOUILLE.get()))).m_138386_("squid_ink_pasta", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.SQUID_INK_PASTA.get()))).m_138386_("grilled_salmon", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.GRILLED_SALMON.get()))).m_138386_("roast_chicken", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.ROAST_CHICKEN.get()))).m_138386_("stuffed_pumpkin", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.STUFFED_PUMPKIN.get()))).m_138386_("honey_glazed_ham", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.HONEY_GLAZED_HAM.get()))).m_138386_("shepherds_pie", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.SHEPHERDS_PIE.get()))).m_138386_("bacon_and_eggs", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)ModItems.BACON_AND_EGGS.get()))).m_138354_(AdvancementRewards.Builder.m_10005_((int)200)).m_138389_(consumer, this.getNameId("main/master_chef"));
        }

        protected static Advancement.Builder getAdvancement(Advancement parent, ItemLike display, String name, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return Advancement.Builder.m_138353_().m_138398_(parent).m_138371_(display, (Component)TextUtils.getTranslation("advancement." + name, new Object[0]), (Component)TextUtils.getTranslation("advancement." + name + ".desc", new Object[0]), null, frame, showToast, announceToChat, hidden);
        }

        private String getNameId(String id) {
            return "farmersdelight:" + id;
        }
    }
}

