/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio.belt;

import artifacts.common.config.ModConfig;
import artifacts.common.init.ModItems;
import artifacts.common.init.ModSoundEvents;
import artifacts.common.item.curio.CurioItem;
import artifacts.common.network.DoubleJumpPacket;
import artifacts.common.network.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CloudInABottleItem
extends CurioItem {
    public CloudInABottleItem() {
        MinecraftForge.EVENT_BUS.register((Object)new DoubleJumpHandler());
        this.addListener(EventPriority.HIGHEST, LivingFallEvent.class, this::onLivingFall);
    }

    public void jump(Player player) {
        player.f_19789_ = 0.0f;
        double upwardsMotion = 0.5;
        if (player.m_21023_(MobEffects.f_19603_)) {
            upwardsMotion += 0.1 * (double)(player.m_21124_(MobEffects.f_19603_).m_19564_() + 1);
        }
        Vec3 motion = player.m_20184_();
        double motionMultiplier = player.m_20142_() ? (Double)ModConfig.server.cloudInABottle.sprintJumpDistanceMultiplier.get() : 0.0;
        float direction = (float)((double)player.m_146908_() * Math.PI / 180.0);
        player.m_20256_(player.m_20184_().m_82520_((double)(-Mth.m_14031_((float)direction)) * motionMultiplier, (upwardsMotion *= player.m_20142_() ? (Double)ModConfig.server.cloudInABottle.sprintJumpHeightMultiplier.get() : 1.0) - motion.f_82480_, (double)Mth.m_14089_((float)direction) * motionMultiplier));
        player.f_19812_ = true;
        ForgeHooks.onLivingJump((LivingEntity)player);
        player.m_36220_(Stats.f_12926_);
        if (player.m_20142_()) {
            player.m_36399_(0.2f);
        } else {
            player.m_36399_(0.05f);
        }
        if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.WHOOPEE_CUSHION.get(), (LivingEntity)player).isPresent()) {
            player.m_5496_((SoundEvent)ModSoundEvents.FART.get(), 1.0f, 0.9f + player.m_21187_().nextFloat() * 0.2f);
        } else {
            player.m_5496_(SoundEvents.f_12640_, 1.0f, 0.9f + player.m_21187_().nextFloat() * 0.2f);
        }
        this.damageEquippedStacks((LivingEntity)player);
    }

    private void onLivingFall(LivingFallEvent event, LivingEntity wearer) {
        event.setDistance(Math.max(0.0f, event.getDistance() - 3.0f));
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11771_, 1.0f, 1.0f);
    }

    private class DoubleJumpHandler {
        @OnlyIn(value=Dist.CLIENT)
        private boolean canDoubleJump;
        @OnlyIn(value=Dist.CLIENT)
        private boolean hasReleasedJumpKey;

        private DoubleJumpHandler() {
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void onClientTick(TickEvent.ClientTickEvent event) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (event.phase == TickEvent.Phase.END && player != null && player.f_108618_ != null) {
                if ((player.m_20096_() || player.m_6147_()) && !player.m_20069_()) {
                    this.hasReleasedJumpKey = false;
                    this.canDoubleJump = true;
                } else if (!player.f_108618_.f_108572_) {
                    this.hasReleasedJumpKey = true;
                } else if (!player.m_150110_().f_35935_ && this.canDoubleJump && this.hasReleasedJumpKey) {
                    this.canDoubleJump = false;
                    if (CloudInABottleItem.this.isEquippedBy((LivingEntity)player)) {
                        NetworkHandler.INSTANCE.sendToServer((Object)new DoubleJumpPacket());
                        CloudInABottleItem.this.jump((Player)player);
                    }
                }
            }
        }
    }
}

