/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.BalmBlocks;
import net.blay09.mods.waystones.block.PortstoneBlock;
import net.blay09.mods.waystones.block.SharestoneBlock;
import net.blay09.mods.waystones.block.WarpPlateBlock;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.item.ModItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;

public class ModBlocks {
    public static final Block waystone = new WaystoneBlock(ModBlocks.defaultProperties());
    public static final Block mossyWaystone = new WaystoneBlock(ModBlocks.defaultProperties());
    public static final Block sandyWaystone = new WaystoneBlock(ModBlocks.defaultProperties());
    public static final Block sharestone = new SharestoneBlock(ModBlocks.defaultProperties(), null);
    public static final Block[] scopedSharestones = new SharestoneBlock[DyeColor.values().length];
    public static final Block warpPlate = new WarpPlateBlock(ModBlocks.defaultProperties());
    public static final Block portstone = new PortstoneBlock(ModBlocks.defaultProperties());

    public static void initialize(BalmBlocks blocks) {
        DyeColor[] colors;
        blocks.register(() -> waystone, () -> ModBlocks.itemBlock(waystone), ModBlocks.id("waystone"));
        blocks.register(() -> mossyWaystone, () -> ModBlocks.itemBlock(mossyWaystone), ModBlocks.id("mossy_waystone"));
        blocks.register(() -> sandyWaystone, () -> ModBlocks.itemBlock(sandyWaystone), ModBlocks.id("sandy_waystone"));
        blocks.register(() -> warpPlate, () -> ModBlocks.itemBlock(warpPlate), ModBlocks.id("warp_plate"));
        blocks.register(() -> sharestone, () -> ModBlocks.itemBlock(sharestone), ModBlocks.id("sharestone"));
        blocks.register(() -> portstone, () -> ModBlocks.itemBlock(portstone), ModBlocks.id("portstone"));
        for (DyeColor color : colors = DyeColor.values()) {
            ModBlocks.scopedSharestones[color.ordinal()] = new SharestoneBlock(ModBlocks.defaultProperties(), color);
            blocks.register(() -> scopedSharestones[color.ordinal()], () -> ModBlocks.itemBlock(scopedSharestones[color.ordinal()]), ModBlocks.id(color.m_7912_() + "_sharestone"));
        }
    }

    private static BlockItem itemBlock(Block block) {
        return new BlockItem(block, Balm.getBlocks().itemProperties(ModItems.creativeModeTab));
    }

    private static ResourceLocation id(String name) {
        return new ResourceLocation("waystones", name);
    }

    private static BlockBehaviour.Properties defaultProperties() {
        return Balm.getBlocks().blockProperties(Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(5.0f, 2000.0f);
    }
}

