/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IEnergyStorageUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IFluidHandlerWrapperUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IInventoryWrapperUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InceptionEnergyStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InceptionFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InceptionInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InceptionUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InceptionWrapperAccessor;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InventoryOrder;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.SubBackpacksHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageFluidHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeAccessModifier;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapperAccessor;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class InceptionUpgradeWrapper
extends UpgradeWrapperBase<InceptionUpgradeWrapper, InceptionUpgradeItem>
implements IInventoryWrapperUpgrade,
IUpgradeAccessModifier,
IFluidHandlerWrapperUpgrade,
IEnergyStorageUpgradeWrapper {
    private SubBackpacksHandler subBackpacksHandler = null;

    public InceptionUpgradeWrapper(IStorageWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
    }

    @Override
    public boolean hideSettingsTab() {
        return Boolean.FALSE.equals(Config.COMMON.inceptionUpgrade.upgradesUseInventoriesOfBackpacksInBackpack.get());
    }

    public InventoryOrder getInventoryOrder() {
        return NBTHelper.getEnumConstant(this.upgrade, "inventoryOrder", InventoryOrder::fromName).orElse(InventoryOrder.MAIN_FIRST);
    }

    public void setInventoryOrder(InventoryOrder inventoryOrder) {
        NBTHelper.setEnumConstant(this.upgrade, "inventoryOrder", inventoryOrder);
        this.save();
        this.storageWrapper.refreshInventoryForUpgradeProcessing();
    }

    @Override
    public IItemHandlerSimpleInserter wrapInventory(IItemHandlerSimpleInserter inventory) {
        if (Boolean.TRUE.equals(Config.COMMON.inceptionUpgrade.upgradesUseInventoriesOfBackpacksInBackpack.get())) {
            this.initSubBackpacksHandler();
            return new InceptionInventoryHandler(inventory, this.getInventoryOrder(), this.subBackpacksHandler);
        }
        return inventory;
    }

    private void initSubBackpacksHandler() {
        this.subBackpacksHandler = new SubBackpacksHandler(this.storageWrapper.getInventoryHandler());
    }

    @Override
    public IUpgradeWrapperAccessor wrapAccessor(IUpgradeWrapperAccessor upgradeWrapperAccessor) {
        if (Boolean.TRUE.equals(Config.COMMON.inceptionUpgrade.upgradesInContainedBackpacksAreFunctional.get())) {
            this.initSubBackpacksHandler();
            return new InceptionWrapperAccessor(this.storageWrapper, this.subBackpacksHandler);
        }
        return upgradeWrapperAccessor;
    }

    @Override
    @Nullable
    public IStorageFluidHandler wrapHandler(@Nullable IStorageFluidHandler fluidHandler, ItemStack backpack) {
        if (Boolean.TRUE.equals(Config.COMMON.inceptionUpgrade.upgradesInContainedBackpacksAreFunctional.get())) {
            this.initSubBackpacksHandler();
            return new InceptionFluidHandler(fluidHandler, backpack, this.getInventoryOrder(), this.subBackpacksHandler);
        }
        return fluidHandler;
    }

    @Override
    @Nullable
    public IEnergyStorage wrapStorage(@Nullable IEnergyStorage energyStorage) {
        if (Boolean.TRUE.equals(Config.COMMON.inceptionUpgrade.upgradesInContainedBackpacksAreFunctional.get())) {
            this.initSubBackpacksHandler();
            return new InceptionEnergyStorage(energyStorage, this.getInventoryOrder(), this.subBackpacksHandler);
        }
        return energyStorage;
    }
}

