/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.UV;

public class GuiHelper {
    public static final ResourceLocation GUI_CONTROLS = SophisticatedCore.getRL("textures/gui/gui_controls.png");
    private static final int GUI_CONTROLS_TEXTURE_WIDTH = 256;
    private static final int GUI_CONTROLS_TEXTURE_HEIGHT = 256;
    public static final TextureBlitData BAR_BACKGROUND_BOTTOM = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 66), Dimension.SQUARE_18);
    public static final TextureBlitData BAR_BACKGROUND_MIDDLE = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 48), Dimension.SQUARE_18);
    public static final TextureBlitData BAR_BACKGROUND_TOP = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 30), Dimension.SQUARE_18);
    public static final ResourceLocation ICONS = SophisticatedCore.getRL("textures/gui/icons.png");
    public static final TextureBlitData CRAFTING_RESULT_SLOT = new TextureBlitData(GUI_CONTROLS, new UV(71, 216), new Dimension(26, 26));
    public static final TextureBlitData DEFAULT_BUTTON_HOVERED_BACKGROUND = new TextureBlitData(GUI_CONTROLS, new UV(47, 0), Dimension.SQUARE_18);
    public static final TextureBlitData DEFAULT_BUTTON_BACKGROUND = new TextureBlitData(GUI_CONTROLS, new UV(29, 0), Dimension.SQUARE_18);
    public static final TextureBlitData SMALL_BUTTON_BACKGROUND = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 18), Dimension.SQUARE_12);
    public static final TextureBlitData SMALL_BUTTON_HOVERED_BACKGROUND = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(41, 18), Dimension.SQUARE_12);
    public static final ResourceLocation SLOTS_BACKGROUND = SophisticatedCore.getRL("textures/gui/slots_background.png");
    private static final Map<Integer, TextureBlitData> SLOTS_BACKGROUNDS = new HashMap<Integer, TextureBlitData>();
    private static final Field TOOLTIP_FONT = ObfuscationReflectionHelper.findField(Screen.class, (String)"tooltipFont");

    private GuiHelper() {
    }

    public static void renderItemInGUI(PoseStack matrixStack, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition) {
        GuiHelper.renderItemInGUI(matrixStack, minecraft, stack, xPosition, yPosition, false);
    }

    public static void renderSlotsBackground(PoseStack matrixStack, int x, int y, int slotWidth, int slotHeight) {
        int key = GuiHelper.getSlotsBackgroundKey(slotWidth, slotHeight);
        GuiHelper.blit(matrixStack, x, y, SLOTS_BACKGROUNDS.computeIfAbsent(key, k -> new TextureBlitData(SLOTS_BACKGROUND, Dimension.SQUARE_256, new UV(0, 0), new Dimension(slotWidth * 18, slotHeight * 18))));
    }

    private static int getSlotsBackgroundKey(int slotWidth, int slotHeight) {
        return slotWidth * 31 + slotHeight;
    }

    public static void renderItemInGUI(PoseStack matrixStack, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition, boolean renderOverlay) {
        GuiHelper.renderItemInGUI(matrixStack, minecraft, stack, xPosition, yPosition, renderOverlay, null);
    }

    public static void renderItemInGUI(PoseStack matrixStack, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition, boolean renderOverlay, @Nullable String countText) {
        ItemRenderer itemRenderer = minecraft.m_91291_();
        float originalZLevel = itemRenderer.f_115093_;
        itemRenderer.f_115093_ += (float)GuiHelper.getZOffset(matrixStack);
        itemRenderer.m_115203_(stack, xPosition, yPosition);
        if (renderOverlay) {
            itemRenderer.m_115174_(minecraft.f_91062_, stack, xPosition, yPosition, countText);
        }
        itemRenderer.f_115093_ = originalZLevel;
    }

    private static int getZOffset(PoseStack matrixStack) {
        Float zOffset = (Float)ObfuscationReflectionHelper.getPrivateValue(Matrix4f.class, (Object)matrixStack.m_85850_().m_85861_(), (String)"f_27614_");
        return zOffset == null ? 0 : zOffset.intValue();
    }

    public static void blit(PoseStack matrixStack, int x, int y, TextureBlitData texData) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texData.getTextureName());
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)(x + texData.getXOffset()), (int)(y + texData.getYOffset()), (float)texData.getU(), (float)texData.getV(), (int)texData.getWidth(), (int)texData.getHeight(), (int)texData.getTextureWidth(), (int)texData.getTextureHeight());
    }

    public static void coloredBlit(Matrix4f matrix, int x, int y, TextureBlitData texData, int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        int xMin = x + texData.getXOffset();
        int yMin = y + texData.getYOffset();
        int xMax = xMin + texData.getWidth();
        int yMax = yMin + texData.getHeight();
        float minU = (float)texData.getU() / (float)texData.getTextureWidth();
        float maxU = minU + (float)texData.getWidth() / (float)texData.getTextureWidth();
        float minV = (float)texData.getV() / (float)texData.getTextureHeight();
        float maxV = minV + (float)texData.getHeight() / (float)texData.getTextureWidth();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferbuilder.m_85982_(matrix, (float)xMin, (float)yMax, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)xMax, (float)yMax, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)xMax, (float)yMin, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)xMin, (float)yMin, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
    }

    public static void renderTooltipBackground(Matrix4f matrix4f, int tooltipWidth, int leftX, int topY, int tooltipHeight, int backgroundColor, int borderColorStart, int borderColorEnd) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 4, leftX + tooltipWidth + 3, topY - 3, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY + tooltipHeight + 3, leftX + tooltipWidth + 3, topY + tooltipHeight + 4, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 3, leftX + tooltipWidth + 3, topY + tooltipHeight + 3, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 4, topY - 3, leftX - 3, topY + tooltipHeight + 3, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX + tooltipWidth + 3, topY - 3, leftX + tooltipWidth + 4, topY + tooltipHeight + 3, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 3 + 1, leftX - 3 + 1, topY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX + tooltipWidth + 2, topY - 3 + 1, leftX + tooltipWidth + 3, topY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 3, leftX + tooltipWidth + 3, topY - 3 + 1, borderColorStart, borderColorStart);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY + tooltipHeight + 2, leftX + tooltipWidth + 3, topY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
        RenderSystem.m_69482_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void writeTooltipLines(List<? extends FormattedText> textLines, Font font, float leftX, int topY, Matrix4f matrix4f, MultiBufferSource.BufferSource renderTypeBuffer, int color) {
        for (int i = 0; i < textLines.size(); ++i) {
            FormattedText line = textLines.get(i);
            if (line != null) {
                font.m_92733_(Language.m_128107_().m_5536_(line), leftX, (float)topY, color, true, matrix4f, (MultiBufferSource)renderTypeBuffer, false, 0, 0xF000F0);
            }
            if (i == 0) {
                topY += 2;
            }
            topY += 10;
        }
    }

    private static void fillGradient(Matrix4f matrix, BufferBuilder builder, int x1, int y1, int x2, int y2, int colorA, int colorB) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colorA & 0xFF) / 255.0f;
        float f4 = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colorB & 0xFF) / 255.0f;
        builder.m_85982_(matrix, (float)x2, (float)y1, 400.0f).m_85950_(f1, f2, f3, f).m_5752_();
        builder.m_85982_(matrix, (float)x1, (float)y1, 400.0f).m_85950_(f1, f2, f3, f).m_5752_();
        builder.m_85982_(matrix, (float)x1, (float)y2, 400.0f).m_85950_(f5, f6, f7, f4).m_5752_();
        builder.m_85982_(matrix, (float)x2, (float)y2, 400.0f).m_85950_(f5, f6, f7, f4).m_5752_();
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, Dimension dimension, Position offset, Component ... tooltip) {
        return GuiHelper.getButtonStateData(uv, dimension, offset, Arrays.asList(tooltip));
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, String tooltip, Dimension dimension) {
        return GuiHelper.getButtonStateData(uv, tooltip, dimension, new Position(0, 0));
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, String tooltip, Dimension dimension, Position offset) {
        return new ToggleButton.StateData(new TextureBlitData(ICONS, offset, Dimension.SQUARE_256, uv, dimension), new Component[]{new TranslatableComponent(tooltip)});
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, Dimension dimension, Position offset, List<Component> tooltip) {
        return new ToggleButton.StateData(new TextureBlitData(ICONS, offset, Dimension.SQUARE_256, uv, dimension), tooltip);
    }

    public static void renderSlotsBackground(PoseStack matrixStack, int x, int y, int slotsInRow, int fullSlotRows, int extraRowSlots) {
        GuiHelper.renderSlotsBackground(matrixStack, x, y, slotsInRow, fullSlotRows);
        if (extraRowSlots > 0) {
            GuiHelper.renderSlotsBackground(matrixStack, x, y + fullSlotRows * 18, extraRowSlots, 1);
        }
    }

    public static void renderTiledFluidTextureAtlas(PoseStack matrixStack, TextureAtlasSprite sprite, int color, int x, int y, int height) {
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)sprite.m_118414_().m_118330_());
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        float u1 = sprite.m_118409_();
        float v1 = sprite.m_118411_();
        int spriteHeight = sprite.m_118408_();
        int spriteWidth = sprite.m_118405_();
        int startY = y;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        do {
            int renderHeight = Math.min(spriteHeight, height);
            height -= renderHeight;
            float v2 = sprite.m_118393_((double)(16.0f * (float)renderHeight / (float)spriteHeight));
            Matrix4f matrix = matrixStack.m_85850_().m_85861_();
            float u2 = sprite.m_118367_((double)(256.0f / (float)spriteWidth));
            builder.m_85982_(matrix, (float)x, (float)startY + (float)renderHeight, 100.0f).m_7421_(u1, v2).m_85950_(red, green, blue, 1.0f).m_5752_();
            builder.m_85982_(matrix, (float)x + 16.0f, (float)startY + (float)renderHeight, 100.0f).m_7421_(u2, v2).m_85950_(red, green, blue, 1.0f).m_5752_();
            builder.m_85982_(matrix, (float)x + 16.0f, (float)startY, 100.0f).m_7421_(u2, v1).m_85950_(red, green, blue, 1.0f).m_5752_();
            builder.m_85982_(matrix, (float)x, (float)startY, 100.0f).m_7421_(u1, v1).m_85950_(red, green, blue, 1.0f).m_5752_();
            startY += renderHeight;
        } while (height > 0);
        builder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)builder);
    }

    public static void renderControlBackground(PoseStack matrixStack, int x, int y, int renderWidth, int renderHeight) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_CONTROLS);
        int u = 29;
        int v = 146;
        int textureBgWidth = 66;
        int textureBgHeight = 56;
        int halfWidth = renderWidth / 2;
        int halfHeight = renderHeight / 2;
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)x, (int)y, (float)u, (float)v, (int)halfWidth, (int)halfHeight, (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)x, (int)(y + halfHeight), (float)u, (float)((float)v + (float)textureBgHeight - (float)halfHeight), (int)halfWidth, (int)halfHeight, (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)(x + halfWidth), (int)y, (float)((float)u + (float)textureBgWidth - (float)halfWidth), (float)v, (int)halfWidth, (int)halfHeight, (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)(x + halfWidth), (int)(y + halfHeight), (float)((float)u + (float)textureBgWidth - (float)halfWidth), (float)((float)v + (float)textureBgHeight - (float)halfHeight), (int)halfWidth, (int)halfHeight, (int)256, (int)256);
    }

    public static void tryRenderGuiItem(ItemRenderer itemRenderer, TextureManager textureManager, @Nullable LivingEntity livingEntity, ItemStack stack, int x, int y, int rotation) {
        if (!stack.m_41619_()) {
            BakedModel bakedmodel = itemRenderer.m_174264_(stack, null, livingEntity, 0);
            itemRenderer.f_115093_ += 50.0f;
            try {
                GuiHelper.renderGuiItem(itemRenderer, textureManager, stack, x, y, bakedmodel, rotation);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Item being rendered");
                crashreportcategory.m_128165_("Item Type", () -> String.valueOf(stack.m_41720_()));
                crashreportcategory.m_128165_("Registry Name", () -> String.valueOf(stack.m_41720_().getRegistryName()));
                crashreportcategory.m_128165_("Item Damage", () -> String.valueOf(stack.m_41773_()));
                crashreportcategory.m_128165_("Item NBT", () -> String.valueOf(stack.m_41783_()));
                crashreportcategory.m_128165_("Item Foil", () -> String.valueOf(stack.m_41790_()));
                throw new ReportedException(crashreport);
            }
            itemRenderer.f_115093_ -= 50.0f;
        }
    }

    private static void renderGuiItem(ItemRenderer itemRenderer, TextureManager textureManager, ItemStack stack, int x, int y, BakedModel bakedModel, int rotation) {
        boolean flag;
        textureManager.m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)x, (double)y, (double)(100.0f + itemRenderer.f_115093_));
        posestack.m_85837_(8.0, 8.0, 0.0);
        if (rotation != 0) {
            posestack.m_85845_(Vector3f.f_122227_.m_122240_((float)rotation));
        }
        posestack.m_85841_(1.0f, -1.0f, 1.0f);
        posestack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.m_157182_();
        PoseStack posestack1 = new PoseStack();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flag = !bakedModel.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        itemRenderer.m_115143_(stack, ItemTransforms.TransformType.GUI, false, posestack1, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        bufferSource.m_109911_();
        RenderSystem.m_69482_();
        if (flag) {
            Lighting.m_84931_();
        }
        posestack.m_85849_();
        RenderSystem.m_157182_();
    }

    @Nullable
    private static Font getTooltipFont(Screen screen) {
        try {
            return (Font)TOOLTIP_FONT.get(screen);
        }
        catch (IllegalAccessException e) {
            SophisticatedCore.LOGGER.error("Unable to get value from field tooltipFont in Screen class: ", (Throwable)e);
            return null;
        }
    }

    public static void renderTooltip(Screen screen, PoseStack poseStack, List<Component> components, int x, int y) {
        List<ClientTooltipComponent> list = GuiHelper.gatherTooltipComponents(components, x, screen.f_96543_, screen.f_96544_, GuiHelper.getTooltipFont(screen), screen.f_96547_);
        screen.m_169383_(poseStack, list, x, y);
    }

    public static List<ClientTooltipComponent> gatherTooltipComponents(List<? extends FormattedText> textElements, int mouseX, int screenWidth, int screenHeight, @Nullable Font forcedFont, Font fallbackFont) {
        Font font = ForgeHooksClient.getTooltipFont((Font)forcedFont, (ItemStack)ItemStack.f_41583_, (Font)fallbackFont);
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        RenderTooltipEvent.GatherComponents event = new RenderTooltipEvent.GatherComponents(ItemStack.f_41583_, screenWidth, screenHeight, elements, -1);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return List.of();
        }
        int tooltipX = mouseX + 12;
        int tooltipTextWidth = event.getTooltipElements().stream().mapToInt(either -> (Integer)either.map(arg_0 -> ((Font)font).m_92852_(arg_0), component -> 0)).max().orElse(0);
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
        }
        if (event.getMaxWidth() > 0 && tooltipTextWidth > event.getMaxWidth()) {
            tooltipTextWidth = event.getMaxWidth();
        }
        int tooltipTextWidthF = tooltipTextWidth;
        return event.getTooltipElements().stream().flatMap(either -> (Stream)either.map(text -> font.m_92923_(text, tooltipTextWidthF).stream().map(ClientTooltipComponent::m_169948_), component -> Stream.of(ClientTooltipComponent.m_169950_((TooltipComponent)component)))).toList();
    }

    public static interface ITooltipRenderPart {
        public static final ITooltipRenderPart EMPTY = new ITooltipRenderPart(){

            @Override
            public int getWidth() {
                return 0;
            }

            @Override
            public int getHeight() {
                return 0;
            }

            @Override
            public void render(PoseStack matrixStack, int leftX, int topY, Font font) {
            }
        };

        public int getWidth();

        public int getHeight();

        public void render(PoseStack var1, int var2, int var3, Font var4);
    }
}

