/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config.sorting;

import java.io.File;
import java.util.Comparator;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.config.sorting.MappedSortingConfig;
import mezz.jei.config.sorting.serializers.SortingSerializers;
import mezz.jei.ingredients.IIngredientListElementInfo;

public class IngredientTypeSortingConfig
extends MappedSortingConfig<IIngredientListElementInfo<?>, String> {
    public IngredientTypeSortingConfig(File file) {
        super(file, SortingSerializers.STRING, IngredientTypeSortingConfig::getIngredientTypeString);
    }

    public static String getIngredientTypeString(IIngredientListElementInfo<?> info) {
        ITypedIngredient<?> typedIngredient = info.getTypedIngredient();
        return IngredientTypeSortingConfig.getIngredientTypeString(typedIngredient.getType());
    }

    public static String getIngredientTypeString(IIngredientType<?> ingredientType) {
        return ingredientType.getIngredientClass().getName();
    }

    @Override
    protected Comparator<String> getDefaultSortOrder() {
        String itemStackIngredientType = IngredientTypeSortingConfig.getIngredientTypeString(VanillaTypes.ITEM);
        Comparator<String> itemStackFirst = Comparator.comparing(s -> s.equals(itemStackIngredientType)).reversed();
        Comparator naturalOrder = Comparator.naturalOrder();
        return itemStackFirst.thenComparing(naturalOrder);
    }
}

