/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnegative;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.gui.ingredients.IngredientLookupState;
import mezz.jei.gui.recipes.FocusedRecipes;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.IRecipeLogicStateListener;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.recipes.FocusGroup;
import mezz.jei.recipes.RecipeTransferManager;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class RecipeGuiLogic
implements IRecipeGuiLogic {
    private final IRecipeManager recipeManager;
    private final RecipeTransferManager recipeTransferManager;
    private final IRecipeLogicStateListener stateListener;
    private final RegisteredIngredients registeredIngredients;
    private final IModIdHelper modIdHelper;
    private boolean initialState = true;
    private IngredientLookupState state;
    private final Stack<IngredientLookupState> history = new Stack();

    public RecipeGuiLogic(IRecipeManager recipeManager, RecipeTransferManager recipeTransferManager, IRecipeLogicStateListener stateListener, RegisteredIngredients registeredIngredients, IModIdHelper modIdHelper) {
        this.recipeManager = recipeManager;
        this.recipeTransferManager = recipeTransferManager;
        this.stateListener = stateListener;
        this.registeredIngredients = registeredIngredients;
        this.modIdHelper = modIdHelper;
        this.state = IngredientLookupState.createWithFocus(recipeManager, FocusGroup.EMPTY);
    }

    @Override
    public boolean setFocus(IFocusGroup focuses) {
        IngredientLookupState state = IngredientLookupState.createWithFocus(this.recipeManager, focuses);
        ImmutableList<IRecipeCategory<?>> recipeCategories = state.getRecipeCategories();
        if (recipeCategories.isEmpty()) {
            return false;
        }
        int recipeCategoryIndex = RecipeGuiLogic.getRecipeCategoryIndexToShowFirst(recipeCategories, this.recipeTransferManager);
        state.setRecipeCategoryIndex(recipeCategoryIndex);
        this.setState(state, true);
        return true;
    }

    @Nonnegative
    private static int getRecipeCategoryIndexToShowFirst(List<IRecipeCategory<?>> recipeCategories, RecipeTransferManager recipeTransferManager) {
        AbstractContainerMenu openContainer;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player != null && (openContainer = player.f_36096_) != null) {
            for (int i = 0; i < recipeCategories.size(); ++i) {
                IRecipeCategory<?> recipeCategory = recipeCategories.get(i);
                IRecipeTransferHandler<AbstractContainerMenu, ?> recipeTransferHandler = recipeTransferManager.getRecipeTransferHandler(openContainer, recipeCategory);
                if (recipeTransferHandler == null) continue;
                return i;
            }
        }
        return 0;
    }

    @Override
    public boolean back() {
        if (this.history.empty()) {
            return false;
        }
        IngredientLookupState state = this.history.pop();
        this.setState(state, false);
        return true;
    }

    @Override
    public void clearHistory() {
        while (!this.history.empty()) {
            this.history.pop();
        }
    }

    private void setState(IngredientLookupState state, boolean saveHistory) {
        if (saveHistory && !this.initialState) {
            this.history.push(this.state);
        }
        this.state = state;
        this.initialState = false;
        this.stateListener.onStateChange();
    }

    @Override
    public boolean setCategoryFocus() {
        IRecipeCategory<?> recipeCategory = this.getSelectedRecipeCategory();
        IngredientLookupState state = IngredientLookupState.createWithFocus(this.recipeManager, FocusGroup.EMPTY);
        state.setRecipeCategory(recipeCategory);
        this.setState(state, true);
        return true;
    }

    @Override
    public boolean setCategoryFocus(List<ResourceLocation> recipeCategoryUids) {
        List<IRecipeCategory<?>> recipeCategories = this.recipeManager.getRecipeCategories(recipeCategoryUids, null, false);
        IngredientLookupState state = IngredientLookupState.createWithCategories(this.recipeManager, recipeCategories);
        if (state.getRecipeCategories().isEmpty()) {
            return false;
        }
        this.setState(state, true);
        return true;
    }

    @Override
    public List<ITypedIngredient<?>> getRecipeCatalysts() {
        IRecipeCategory<?> category = this.getSelectedRecipeCategory();
        return this.getRecipeCatalysts(category);
    }

    @Override
    public List<ITypedIngredient<?>> getRecipeCatalysts(IRecipeCategory<?> recipeCategory) {
        return this.recipeManager.getRecipeCatalystsTyped(recipeCategory, false);
    }

    @Override
    public void setRecipesPerPage(int recipesPerPage) {
        if (this.state.getRecipesPerPage() != recipesPerPage) {
            this.state.setRecipesPerPage(recipesPerPage);
        }
    }

    @Override
    public IRecipeCategory<?> getSelectedRecipeCategory() {
        return this.state.getFocusedRecipes().getRecipeCategory();
    }

    @Override
    public ImmutableList<IRecipeCategory<?>> getRecipeCategories() {
        return this.state.getRecipeCategories();
    }

    @Override
    public List<RecipeLayout<?>> getRecipeLayouts(int posX, int posY, int spacingY) {
        return this.getRecipeLayouts(this.state.getFocusedRecipes(), posX, posY, spacingY);
    }

    private <T> List<RecipeLayout<?>> getRecipeLayouts(FocusedRecipes<T> selectedRecipes, int posX, int posY, int spacingY) {
        int firstRecipeIndex;
        ArrayList recipeLayouts = new ArrayList();
        IRecipeCategory<T> recipeCategory = selectedRecipes.getRecipeCategory();
        List<T> recipes = selectedRecipes.getRecipes();
        int recipeWidgetIndex = 0;
        int recipePosY = posY;
        for (int recipeIndex = firstRecipeIndex = this.state.getRecipeIndex() - this.state.getRecipeIndex() % this.state.getRecipesPerPage(); recipeIndex < recipes.size() && recipeLayouts.size() < this.state.getRecipesPerPage(); ++recipeIndex) {
            int index;
            RecipeLayout<T> recipeLayout;
            T recipe = recipes.get(recipeIndex);
            if ((recipeLayout = RecipeLayout.create(index = recipeWidgetIndex++, recipeCategory, recipe, this.state.getFocuses(), this.registeredIngredients, this.modIdHelper, posX, recipePosY)) == null) {
                recipes.remove(recipeIndex);
                this.recipeManager.hideRecipe(recipe, recipeCategory.getUid());
                --recipeIndex;
                continue;
            }
            recipeLayouts.add(recipeLayout);
            recipePosY += spacingY;
        }
        return recipeLayouts;
    }

    @Override
    public void nextRecipeCategory() {
        this.state.nextRecipeCategory();
        this.stateListener.onStateChange();
    }

    @Override
    public void setRecipeCategory(IRecipeCategory<?> category) {
        if (this.state.setRecipeCategory(category)) {
            this.stateListener.onStateChange();
        }
    }

    @Override
    public boolean hasMultiplePages() {
        List<?> recipes = this.state.getFocusedRecipes().getRecipes();
        return recipes.size() > this.state.getRecipesPerPage();
    }

    @Override
    public void previousRecipeCategory() {
        this.state.previousRecipeCategory();
        this.stateListener.onStateChange();
    }

    @Override
    public void nextPage() {
        int recipeCount = this.recipeCount();
        this.state.setRecipeIndex(this.state.getRecipeIndex() + this.state.getRecipesPerPage());
        if (this.state.getRecipeIndex() >= recipeCount) {
            this.state.setRecipeIndex(0);
        }
        this.stateListener.onStateChange();
    }

    @Override
    public void previousPage() {
        this.state.setRecipeIndex(this.state.getRecipeIndex() - this.state.getRecipesPerPage());
        if (this.state.getRecipeIndex() < 0) {
            int pageCount = this.pageCount(this.state.getRecipesPerPage());
            this.state.setRecipeIndex((pageCount - 1) * this.state.getRecipesPerPage());
        }
        this.stateListener.onStateChange();
    }

    private int pageCount(int recipesPerPage) {
        int recipeCount = this.recipeCount();
        if (recipeCount <= 1) {
            return 1;
        }
        return MathUtil.divideCeil(recipeCount, recipesPerPage);
    }

    private int recipeCount() {
        List<?> recipes = this.state.getFocusedRecipes().getRecipes();
        return recipes.size();
    }

    @Override
    public String getPageString() {
        int pageIndex = MathUtil.divideCeil(this.state.getRecipeIndex() + 1, this.state.getRecipesPerPage());
        return pageIndex + "/" + this.pageCount(this.state.getRecipesPerPage());
    }

    @Override
    public boolean hasMultipleCategories() {
        return this.state.getRecipeCategories().size() > 1;
    }

    @Override
    public boolean hasAllCategories() {
        return this.state.getRecipeCategories().size() == this.recipeManager.getRecipeCategories(List.of(), false).size();
    }
}

