/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IIngredientFilterConfig;
import mezz.jei.config.SearchMode;
import mezz.jei.events.EditModeToggleEvent;
import mezz.jei.events.PlayerJoinedWorldEvent;
import mezz.jei.events.RuntimeEventSubscriptions;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.ingredients.IIngredientListElementInfo;
import mezz.jei.ingredients.IIngredientSorter;
import mezz.jei.ingredients.IngredientListElementInfo;
import mezz.jei.ingredients.IngredientVisibility;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.search.ElementSearch;
import mezz.jei.search.ElementSearchLowMem;
import mezz.jei.search.IElementSearch;
import mezz.jei.search.PrefixInfo;
import mezz.jei.util.LoggedTimer;
import mezz.jei.util.Translator;
import net.minecraft.core.NonNullList;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class IngredientFilter
implements IIngredientGridSource {
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private static final Pattern FILTER_SPLIT_PATTERN = Pattern.compile("(-?\".*?(?:\"|$)|\\S+)");
    private final RegisteredIngredients registeredIngredients;
    private final IIngredientSorter sorter;
    private final IngredientVisibility ingredientVisibility;
    private final boolean debugMode;
    private final IElementSearch elementSearch;
    private final Char2ObjectMap<PrefixInfo> prefixInfos = new Char2ObjectOpenHashMap();
    private final Set<String> modNamesForSorting = new HashSet<String>();
    @Nullable
    private String filterCached;
    private List<ITypedIngredient<?>> ingredientListCached = Collections.emptyList();
    private final List<IIngredientGridSource.Listener> listeners = new ArrayList<IIngredientGridSource.Listener>();

    public IngredientFilter(IClientConfig clientConfig, IIngredientFilterConfig config, RegisteredIngredients registeredIngredients, IIngredientSorter sorter, NonNullList<IIngredientListElement<?>> ingredients, IModIdHelper modIdHelper, IngredientVisibility ingredientVisibility) {
        this.registeredIngredients = registeredIngredients;
        this.sorter = sorter;
        this.ingredientVisibility = ingredientVisibility;
        this.elementSearch = clientConfig.isLowMemorySlowSearchEnabled() ? new ElementSearchLowMem() : new ElementSearch();
        this.debugMode = clientConfig.isDebugModeEnabled();
        this.prefixInfos.put('@', (Object)new PrefixInfo(config::getModNameSearchMode, IIngredientListElementInfo::getModNameStrings));
        this.prefixInfos.put('#', (Object)new PrefixInfo(config::getTooltipSearchMode, e -> e.getTooltipStrings(config, registeredIngredients)));
        this.prefixInfos.put('$', (Object)new PrefixInfo(config::getTagSearchMode, e -> e.getTagStrings(registeredIngredients)));
        this.prefixInfos.put('%', (Object)new PrefixInfo(config::getCreativeTabSearchMode, e -> e.getCreativeTabsStrings(registeredIngredients)));
        this.prefixInfos.put('^', (Object)new PrefixInfo(config::getColorSearchMode, e -> e.getColorStrings(registeredIngredients)));
        this.prefixInfos.put('&', (Object)new PrefixInfo(config::getResourceLocationSearchMode, element -> List.of(element.getResourceLocation().toString())));
        for (PrefixInfo prefixInfo : this.prefixInfos.values()) {
            this.elementSearch.registerPrefix(prefixInfo);
        }
        ingredients.stream().map(i -> IngredientListElementInfo.create(i, registeredIngredients, modIdHelper)).filter(Objects::nonNull).forEach(this::addIngredient);
    }

    public void register(RuntimeEventSubscriptions subscriptions) {
        subscriptions.register(EditModeToggleEvent.class, event -> this.updateHidden());
        subscriptions.register(PlayerJoinedWorldEvent.class, event -> this.updateHidden());
    }

    public <V> void addIngredient(IIngredientListElementInfo<V> info) {
        IIngredientListElement<V> element = info.getElement();
        this.updateHiddenState(element);
        this.elementSearch.add(info);
        String modNameForSorting = info.getModNameForSorting();
        this.modNamesForSorting.add(modNameForSorting);
        this.invalidateCache();
    }

    public void invalidateCache() {
        this.filterCached = null;
        this.sorter.invalidateCache();
    }

    public <V> Optional<IIngredientListElementInfo<V>> searchForMatchingElement(IIngredientHelper<V> ingredientHelper, ITypedIngredient<V> typedIngredient) {
        V ingredient = typedIngredient.getIngredient();
        IIngredientType type = typedIngredient.getType();
        Function<ITypedIngredient, String> uidFunction = i -> ingredientHelper.getUniqueId(i.getIngredient(), UidContext.Ingredient);
        String ingredientUid = uidFunction.apply(typedIngredient);
        String displayName = ingredientHelper.getDisplayName(ingredient);
        String lowercaseDisplayName = Translator.toLowercaseWithLocale(displayName);
        IntSet matchingIndexes = this.elementSearch.getSearchResults(lowercaseDisplayName, PrefixInfo.NO_PREFIX);
        return matchingIndexes.intStream().mapToObj(this.elementSearch::get).map(elementInfo -> IngredientFilter.checkForMatch(elementInfo, type, ingredientUid, uidFunction)).flatMap(Optional::stream).findFirst();
    }

    public void updateHidden() {
        boolean changed = false;
        for (IIngredientListElementInfo<?> info : this.elementSearch.getAllIngredients()) {
            IIngredientListElement<?> element = info.getElement();
            changed |= this.updateHiddenState(element);
        }
        if (changed) {
            this.filterCached = null;
            this.notifyListenersOfChange();
        }
    }

    public <V> boolean updateHiddenState(IIngredientListElement<V> element) {
        ITypedIngredient<V> typedIngredient = element.getTypedIngredient();
        boolean visible = this.ingredientVisibility.isIngredientVisible(typedIngredient);
        if (element.isVisible() != visible) {
            element.setVisible(visible);
            return true;
        }
        return false;
    }

    @Override
    public List<ITypedIngredient<?>> getIngredientList(String filterText) {
        if (!(filterText = filterText.toLowerCase()).equals(this.filterCached)) {
            List<IIngredientListElementInfo<?>> ingredientList = this.getIngredientListUncached(filterText);
            LoggedTimer filterTimer = new LoggedTimer();
            if (this.debugMode) {
                filterTimer.start("Filtering and Sorting: " + filterText);
            }
            this.ingredientListCached = ingredientList.stream().sorted(this.sorter.getComparator(this, this.registeredIngredients)).map(IIngredientListElementInfo::getTypedIngredient).toList();
            if (this.debugMode) {
                filterTimer.stop();
                LogManager.getLogger().info("Filter has " + this.ingredientListCached.size() + " of " + ingredientList.size());
            }
            this.filterCached = filterText;
        }
        return this.ingredientListCached;
    }

    public @Unmodifiable List<IIngredientListElementInfo<?>> getIngredientListPreSort(Comparator<IIngredientListElementInfo<?>> directComparator) {
        List<IIngredientListElementInfo<?>> ingredientList = this.elementSearch.getAllIngredients();
        LoggedTimer filterTimer = new LoggedTimer();
        if (this.debugMode) {
            filterTimer.start("Pre-Sorting.");
        }
        List<IIngredientListElementInfo<?>> fullSortedList = ingredientList.stream().sorted(directComparator).toList();
        if (this.debugMode) {
            filterTimer.stop();
            LogManager.getLogger().info("Sort has " + ingredientList.size());
        }
        return fullSortedList;
    }

    public Set<String> getModNamesForSorting() {
        return Collections.unmodifiableSet(this.modNamesForSorting);
    }

    public <T> List<T> getFilteredIngredients(String filterText, IIngredientType<T> ingredientType) {
        List<ITypedIngredient<?>> ingredientList = this.getIngredientList(filterText);
        return ingredientList.stream().map(i -> i.getIngredient(ingredientType)).flatMap(Optional::stream).toList();
    }

    private List<IIngredientListElementInfo<?>> getIngredientListUncached(String filterText) {
        String[] filters = filterText.split("\\|");
        IntSet matches = null;
        for (String filter : filters) {
            IntSet elements = this.getElements(filter);
            if (elements == null) continue;
            if (matches == null) {
                matches = elements;
                continue;
            }
            matches.addAll((IntCollection)elements);
        }
        if (matches == null) {
            return this.elementSearch.getAllIngredients().parallelStream().filter(info -> {
                IIngredientListElement element = info.getElement();
                return element.isVisible();
            }).toList();
        }
        ArrayList matchingIngredients = new ArrayList();
        int[] matchesList = matches.toIntArray();
        Arrays.sort(matchesList);
        for (int match : matchesList) {
            IIngredientListElementInfo info2 = this.elementSearch.get(match);
            IIngredientListElement element = info2.getElement();
            if (!element.isVisible()) continue;
            matchingIngredients.add(info2);
        }
        return matchingIngredients;
    }

    public <T> List<IIngredientListElementInfo<T>> searchForWildcardMatches(ITypedIngredient<T> typedIngredient, IIngredientHelper<T> ingredientHelper, Function<ITypedIngredient<T>, String> wildcardUidFunction) {
        IIngredientListElementInfo info;
        Optional<IIngredientListElementInfo<T>> match;
        int i;
        IIngredientType<T> ingredientType = typedIngredient.getType();
        Optional<IIngredientListElementInfo<T>> searchResult = this.searchForMatchingElement(ingredientHelper, typedIngredient);
        if (searchResult.isEmpty()) {
            return List.of();
        }
        String wildcardUid = wildcardUidFunction.apply(typedIngredient);
        String itemUid = ingredientHelper.getUniqueId(typedIngredient.getIngredient(), UidContext.Ingredient);
        if (itemUid.equals(wildcardUid)) {
            return List.of(searchResult.get());
        }
        IntOpenHashSet matchingIndexes = new IntOpenHashSet();
        ArrayList<IIngredientListElementInfo<T>> matchingElements = new ArrayList<IIngredientListElementInfo<T>>();
        IIngredientListElementInfo<T> matchingElement = searchResult.get();
        int startingIndex = this.elementSearch.indexOf(matchingElement);
        matchingIndexes.add(startingIndex);
        matchingElements.add(matchingElement);
        for (i = startingIndex - 1; i >= 0 && !matchingIndexes.contains(i) && !(match = IngredientFilter.checkForMatch(info = this.elementSearch.get(i), ingredientType, wildcardUid, wildcardUidFunction)).isEmpty(); --i) {
            matchingIndexes.add(i);
            matchingElements.add(match.get());
        }
        for (i = startingIndex + 1; i < this.elementSearch.size() && !matchingIndexes.contains(i) && !(match = IngredientFilter.checkForMatch(info = this.elementSearch.get(i), ingredientType, wildcardUid, wildcardUidFunction)).isEmpty(); ++i) {
            matchingIndexes.add(i);
            matchingElements.add(match.get());
        }
        return matchingElements;
    }

    private static <T> Optional<IIngredientListElementInfo<T>> checkForMatch(IIngredientListElementInfo<?> info, IIngredientType<T> ingredientType, String uid, Function<ITypedIngredient<T>, String> uidFunction) {
        return IngredientFilter.optionalCast(info, ingredientType).filter(cast -> {
            ITypedIngredient typedIngredient = cast.getTypedIngredient();
            String elementUid = (String)uidFunction.apply(typedIngredient);
            return uid.equals(elementUid);
        });
    }

    private static <T> Optional<IIngredientListElementInfo<T>> optionalCast(IIngredientListElementInfo<?> info, IIngredientType<T> ingredientType) {
        ITypedIngredient<?> typedIngredient = info.getTypedIngredient();
        if (typedIngredient.getType() == ingredientType) {
            IIngredientListElementInfo<?> cast = info;
            return Optional.of(cast);
        }
        return Optional.empty();
    }

    @Nullable
    private IntSet getElements(String filterText) {
        Matcher filterMatcher = FILTER_SPLIT_PATTERN.matcher(filterText);
        IntSet matches = null;
        IntSet removeMatches = null;
        while (filterMatcher.find()) {
            IntSet searchResults;
            String token = filterMatcher.group(1);
            boolean remove = token.startsWith("-");
            if (remove) {
                token = token.substring(1);
            }
            if ((searchResults = this.getSearchResults(token = QUOTE_PATTERN.matcher(token).replaceAll(""))) == null) continue;
            if (remove) {
                if (removeMatches == null) {
                    removeMatches = searchResults;
                    continue;
                }
                removeMatches.addAll((IntCollection)searchResults);
                continue;
            }
            if (!(matches = matches == null ? searchResults : IngredientFilter.intersection(matches, searchResults)).isEmpty()) continue;
            break;
        }
        if (matches != null && removeMatches != null) {
            matches.removeAll(removeMatches);
        }
        return matches;
    }

    @Nullable
    private IntSet getSearchResults(String token) {
        if (token.isEmpty()) {
            return null;
        }
        char firstChar = token.charAt(0);
        PrefixInfo prefixInfo = (PrefixInfo)this.prefixInfos.get(firstChar);
        if (prefixInfo != null && prefixInfo.getMode() != SearchMode.DISABLED) {
            if ((token = token.substring(1)).isEmpty()) {
                return null;
            }
            return this.elementSearch.getSearchResults(token, prefixInfo);
        }
        return this.elementSearch.getSearchResults(token, PrefixInfo.NO_PREFIX);
    }

    private static IntSet intersection(IntSet set1, IntSet set2) {
        if (set1.size() > set2.size()) {
            set2.retainAll((IntCollection)set1);
            return set2;
        }
        set1.retainAll((IntCollection)set2);
        return set1;
    }

    @Override
    public void addListener(IIngredientGridSource.Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListenersOfChange() {
        for (IIngredientGridSource.Listener listener : this.listeners) {
            listener.onChange();
        }
    }
}

