/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.Comparator;
import java.util.List;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.sorting.IngredientTypeSortingConfig;
import mezz.jei.config.sorting.ModNameSortingConfig;
import mezz.jei.ingredients.IIngredientListElementInfo;
import mezz.jei.ingredients.IIngredientSorter;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientSortStage;
import mezz.jei.ingredients.IngredientSorterComparators;
import mezz.jei.ingredients.RegisteredIngredients;

public final class IngredientSorter
implements IIngredientSorter {
    private static final Comparator<IIngredientListElementInfo<?>> PRE_SORTED = Comparator.comparing(IIngredientListElementInfo::getSortedIndex);
    private final IClientConfig clientConfig;
    private final ModNameSortingConfig modNameSortingConfig;
    private final IngredientTypeSortingConfig ingredientTypeSortingConfig;
    private boolean isCacheValid;

    public IngredientSorter(IClientConfig clientConfig, ModNameSortingConfig modNameSortingConfig, IngredientTypeSortingConfig ingredientTypeSortingConfig) {
        this.clientConfig = clientConfig;
        this.modNameSortingConfig = modNameSortingConfig;
        this.ingredientTypeSortingConfig = ingredientTypeSortingConfig;
        this.isCacheValid = false;
    }

    @Override
    public void doPreSort(IngredientFilter ingredientFilter, RegisteredIngredients registeredIngredients) {
        IngredientSorterComparators comparators = new IngredientSorterComparators(ingredientFilter, registeredIngredients, this.modNameSortingConfig, this.ingredientTypeSortingConfig);
        List<IngredientSortStage> ingredientSorterStages = this.clientConfig.getIngredientSorterStages();
        Comparator<IIngredientListElementInfo<?>> completeComparator = comparators.getComparator(ingredientSorterStages);
        List<IIngredientListElementInfo<?>> results = ingredientFilter.getIngredientListPreSort(completeComparator);
        int resultsSize = results.size();
        for (int i = 0; i < resultsSize; ++i) {
            IIngredientListElementInfo<?> element = results.get(i);
            element.setSortedIndex(i);
        }
        this.isCacheValid = true;
    }

    @Override
    public Comparator<IIngredientListElementInfo<?>> getComparator(IngredientFilter ingredientFilter, RegisteredIngredients registeredIngredients) {
        if (!this.isCacheValid) {
            this.doPreSort(ingredientFilter, registeredIngredients);
        }
        return PRE_SORTED;
    }

    @Override
    public void invalidateCache() {
        this.isCacheValid = false;
    }
}

