/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input.mouse.handlers;

import java.util.Optional;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.IngredientBlacklistType;
import mezz.jei.config.KeyBindings;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.input.CombinedRecipeFocusSource;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.input.mouse.handlers.LimitedAreaInputHandler;
import net.minecraft.client.gui.screens.Screen;

public class EditInputHandler
implements IUserInputHandler {
    private final CombinedRecipeFocusSource focusSource;
    private final RegisteredIngredients registeredIngredients;
    private final IngredientFilter ingredientFilter;
    private final IWorldConfig worldConfig;
    private final IEditModeConfig editModeConfig;

    public EditInputHandler(CombinedRecipeFocusSource focusSource, RegisteredIngredients registeredIngredients, IngredientFilter ingredientFilter, IWorldConfig worldConfig, IEditModeConfig editModeConfig) {
        this.focusSource = focusSource;
        this.registeredIngredients = registeredIngredients;
        this.ingredientFilter = ingredientFilter;
        this.worldConfig = worldConfig;
        this.editModeConfig = editModeConfig;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput input) {
        if (!this.worldConfig.isEditModeEnabled()) {
            return Optional.empty();
        }
        if (input.is(KeyBindings.toggleHideIngredient)) {
            return this.handle(input, IngredientBlacklistType.ITEM);
        }
        if (input.is(KeyBindings.toggleWildcardHideIngredient)) {
            return this.handle(input, IngredientBlacklistType.WILDCARD);
        }
        return Optional.empty();
    }

    private Optional<IUserInputHandler> handle(UserInput input, IngredientBlacklistType blacklistType) {
        return this.focusSource.getIngredientUnderMouse(input).map(clicked -> {
            if (!input.isSimulate()) {
                this.execute((IClickedIngredient)clicked, blacklistType);
            }
            return LimitedAreaInputHandler.create(this, clicked.getArea());
        });
    }

    private <V> void execute(IClickedIngredient<V> clicked, IngredientBlacklistType blacklistType) {
        IIngredientHelper<V> ingredientHelper;
        ITypedIngredient<V> typedIngredient = clicked.getValue();
        if (this.editModeConfig.isIngredientOnConfigBlacklist(typedIngredient, ingredientHelper = this.registeredIngredients.getIngredientHelper(typedIngredient.getType()))) {
            this.editModeConfig.removeIngredientFromConfigBlacklist(this.ingredientFilter, typedIngredient, blacklistType, ingredientHelper);
        } else {
            this.editModeConfig.addIngredientToConfigBlacklist(this.ingredientFilter, typedIngredient, blacklistType, ingredientHelper);
        }
    }
}

