/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.anvil;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AnvilRecipeMaker {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ItemStack ENCHANTED_BOOK = new ItemStack((ItemLike)Items.f_42690_);

    private AnvilRecipeMaker() {
    }

    public static List<IJeiAnvilRecipe> getAnvilRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        ArrayList<IJeiAnvilRecipe> recipes = new ArrayList<IJeiAnvilRecipe>();
        Stopwatch sw = Stopwatch.createStarted();
        try {
            AnvilRecipeMaker.getRepairRecipes(recipes, vanillaRecipeFactory);
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to create repair recipes.", (Throwable)e);
        }
        sw.stop();
        LOGGER.debug("Registered vanilla repair recipes in {}", (Object)sw);
        sw.reset();
        sw.start();
        try {
            AnvilRecipeMaker.getBookEnchantmentRecipes(recipes, vanillaRecipeFactory, ingredientManager);
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to create enchantment recipes.", (Throwable)e);
        }
        sw.stop();
        LOGGER.debug("Registered enchantment recipes in {}", (Object)sw);
        return recipes;
    }

    private static void getBookEnchantmentRecipes(List<IJeiAnvilRecipe> recipes, IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        Collection<ItemStack> ingredients = ingredientManager.getAllIngredients(VanillaTypes.ITEM);
        Collection enchantments = ForgeRegistries.ENCHANTMENTS.getValues();
        ingredients.stream().filter(ItemStack::m_41792_).forEach(ingredient -> enchantments.stream().filter(enchantment -> enchantment.m_6081_(ingredient)).forEach(enchantment -> {
            try {
                AnvilRecipeMaker.getBookEnchantmentRecipes(recipes, vanillaRecipeFactory, enchantment, ingredient);
            }
            catch (RuntimeException e) {
                String ingredientInfo = ErrorUtil.getIngredientInfo(ingredient, VanillaTypes.ITEM);
                LOGGER.error("Failed to register book enchantment recipes for ingredient: {}", (Object)ingredientInfo, (Object)e);
            }
        }));
    }

    private static void getBookEnchantmentRecipes(List<IJeiAnvilRecipe> recipes, IVanillaRecipeFactory vanillaRecipeFactory, Enchantment enchantment, ItemStack ingredient) {
        Item item = ingredient.m_41720_();
        ArrayList perLevelBooks = Lists.newArrayList();
        ArrayList perLevelOutputs = Lists.newArrayList();
        for (int level = 1; level <= enchantment.m_6586_(); ++level) {
            Map<Enchantment, Integer> enchMap = Map.of(enchantment, level);
            ItemStack bookEnchant = ENCHANTED_BOOK.m_41777_();
            EnchantmentHelper.m_44865_(enchMap, (ItemStack)bookEnchant);
            if (!item.isBookEnchantable(ingredient, bookEnchant)) continue;
            perLevelBooks.add(bookEnchant);
            ItemStack withEnchant = ingredient.m_41777_();
            EnchantmentHelper.m_44865_(enchMap, (ItemStack)withEnchant);
            perLevelOutputs.add(withEnchant);
        }
        if (!perLevelBooks.isEmpty() && !perLevelOutputs.isEmpty()) {
            IJeiAnvilRecipe anvilRecipe = vanillaRecipeFactory.createAnvilRecipe(ingredient, (List<ItemStack>)perLevelBooks, (List<ItemStack>)perLevelOutputs);
            recipes.add(anvilRecipe);
        }
    }

    private static void getRepairRecipes(List<IJeiAnvilRecipe> recipes, IVanillaRecipeFactory vanillaRecipeFactory) {
        HashMap items = Maps.newHashMap();
        Ingredient repairWoods = Tiers.WOOD.m_6282_();
        items.put(repairWoods, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42420_), new ItemStack((ItemLike)Items.f_42422_), new ItemStack((ItemLike)Items.f_42423_), new ItemStack((ItemLike)Items.f_42421_), new ItemStack((ItemLike)Items.f_42424_)}));
        Ingredient repairShields = Ingredient.m_43911_((Tag)ItemTags.f_13168_);
        items.put(repairShields, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42740_)}));
        items.put(Tiers.STONE.m_6282_(), Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42425_), new ItemStack((ItemLike)Items.f_42427_), new ItemStack((ItemLike)Items.f_42428_), new ItemStack((ItemLike)Items.f_42426_), new ItemStack((ItemLike)Items.f_42429_)}));
        Ingredient repairLeather = ArmorMaterials.LEATHER.m_6230_();
        items.put(repairLeather, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42407_), new ItemStack((ItemLike)Items.f_42408_), new ItemStack((ItemLike)Items.f_42462_), new ItemStack((ItemLike)Items.f_42463_)}));
        Ingredient repairIronItems = Tiers.IRON.m_6282_();
        items.put(repairIronItems, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42383_), new ItemStack((ItemLike)Items.f_42385_), new ItemStack((ItemLike)Items.f_42386_), new ItemStack((ItemLike)Items.f_42384_), new ItemStack((ItemLike)Items.f_42387_)}));
        Ingredient repairIronArmor = ArmorMaterials.IRON.m_6230_();
        items.put(repairIronArmor, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42468_), new ItemStack((ItemLike)Items.f_42469_), new ItemStack((ItemLike)Items.f_42470_), new ItemStack((ItemLike)Items.f_42471_)}));
        Ingredient repairChain = ArmorMaterials.CHAIN.m_6230_();
        items.put(repairChain, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42464_), new ItemStack((ItemLike)Items.f_42465_), new ItemStack((ItemLike)Items.f_42466_), new ItemStack((ItemLike)Items.f_42467_)}));
        Ingredient repairGoldItems = Tiers.GOLD.m_6282_();
        items.put(repairGoldItems, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42430_), new ItemStack((ItemLike)Items.f_42432_), new ItemStack((ItemLike)Items.f_42433_), new ItemStack((ItemLike)Items.f_42431_), new ItemStack((ItemLike)Items.f_42434_)}));
        Ingredient repairGoldArmor = ArmorMaterials.GOLD.m_6230_();
        items.put(repairGoldArmor, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42476_), new ItemStack((ItemLike)Items.f_42477_), new ItemStack((ItemLike)Items.f_42478_), new ItemStack((ItemLike)Items.f_42479_)}));
        Ingredient repairDiamondItems = Tiers.DIAMOND.m_6282_();
        items.put(repairDiamondItems, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42388_), new ItemStack((ItemLike)Items.f_42390_), new ItemStack((ItemLike)Items.f_42391_), new ItemStack((ItemLike)Items.f_42389_), new ItemStack((ItemLike)Items.f_42392_)}));
        Ingredient repairDiamondArmor = ArmorMaterials.DIAMOND.m_6230_();
        items.put(repairDiamondArmor, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42472_), new ItemStack((ItemLike)Items.f_42473_), new ItemStack((ItemLike)Items.f_42474_), new ItemStack((ItemLike)Items.f_42475_)}));
        Ingredient repairNetheriteItems = Tiers.NETHERITE.m_6282_();
        items.put(repairNetheriteItems, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42393_), new ItemStack((ItemLike)Items.f_42396_), new ItemStack((ItemLike)Items.f_42397_), new ItemStack((ItemLike)Items.f_42394_), new ItemStack((ItemLike)Items.f_42395_)}));
        Ingredient repairNetheriteArmor = ArmorMaterials.NETHERITE.m_6230_();
        items.put(repairNetheriteArmor, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42483_), new ItemStack((ItemLike)Items.f_42480_), new ItemStack((ItemLike)Items.f_42482_), new ItemStack((ItemLike)Items.f_42481_)}));
        Ingredient repairElytra = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42714_});
        items.put(repairElytra, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42741_)}));
        Ingredient repairTurtle = ArmorMaterials.TURTLE.m_6230_();
        items.put(repairTurtle, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42354_)}));
        for (Map.Entry entry : items.entrySet()) {
            ArrayList repairMaterials = Lists.newArrayList((Object[])((Ingredient)entry.getKey()).m_43908_());
            for (ItemStack ingredient : (List)entry.getValue()) {
                ItemStack damaged1 = ingredient.m_41777_();
                damaged1.m_41721_(damaged1.m_41776_());
                ItemStack damaged2 = ingredient.m_41777_();
                damaged2.m_41721_(damaged2.m_41776_() * 3 / 4);
                ItemStack damaged3 = ingredient.m_41777_();
                damaged3.m_41721_(damaged3.m_41776_() * 2 / 4);
                if (!repairMaterials.isEmpty()) {
                    IJeiAnvilRecipe repairWithMaterial = vanillaRecipeFactory.createAnvilRecipe(damaged1, (List<ItemStack>)repairMaterials, List.of(damaged2));
                    recipes.add(repairWithMaterial);
                }
                IJeiAnvilRecipe repairWithSame = vanillaRecipeFactory.createAnvilRecipe(damaged2, List.of(damaged2), List.of(damaged3));
                recipes.add(repairWithSame);
            }
        }
    }

    public static int findLevelsCost(ItemStack leftStack, ItemStack rightStack) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return -1;
        }
        Inventory fakeInventory = new Inventory((Player)player);
        try {
            AnvilMenu repair = new AnvilMenu(0, fakeInventory);
            ((Slot)repair.f_38839_.get(0)).m_5852_(leftStack);
            ((Slot)repair.f_38839_.get(1)).m_5852_(rightStack);
            return repair.m_39028_();
        }
        catch (RuntimeException e) {
            String left = ErrorUtil.getItemStackInfo(leftStack);
            String right = ErrorUtil.getItemStackInfo(rightStack);
            LOGGER.error("Could not get anvil level cost for: ({} and {}).", (Object)left, (Object)right, (Object)e);
            return -1;
        }
    }
}

