/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import java.util.HashSet;
import java.util.Set;
import mezz.jei.events.PermanentEventSubscriptions;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.Event;

public class StartEventObserver {
    private static final Set<Class<? extends Event>> requiredEvents = Set.of(TagsUpdatedEvent.class, RecipesUpdatedEvent.class);
    private final Set<Class<? extends Event>> observedEvents = new HashSet<Class<? extends Event>>();
    private final Runnable start;

    public StartEventObserver(Runnable start) {
        this.start = start;
    }

    public void register(PermanentEventSubscriptions subscriptions) {
        requiredEvents.forEach(eventClass -> subscriptions.register(eventClass, this::onEvent));
    }

    private <T extends Event> void onEvent(T event) {
        Class<?> eventClass = event.getClass();
        if (requiredEvents.contains(eventClass)) {
            this.observedEvents.add(eventClass);
        }
        if (this.observedEvents.containsAll(requiredEvents)) {
            this.start.run();
        }
    }

    public void reset() {
        this.observedEvents.clear();
    }
}

