/*
 * Decompiled with CFR 0.152.
 */
package com.tynoxs.buildersdelight.world.inventory;

import com.tynoxs.buildersdelight.BuildersDelight;
import com.tynoxs.buildersdelight.init.ChiselContainerInit;
import com.tynoxs.buildersdelight.item.chisel.FillChisel;
import com.tynoxs.buildersdelight.network.ChiselSlotMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

@Mod.EventBusSubscriber
public class ChiselContainer
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Level world;
    public final Player entity;
    public int x;
    public int y;
    public int z;
    private IItemHandler internal;
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private boolean bound = false;

    public ChiselContainer(int id, Inventory inv, FriendlyByteBuf extraData) {
        super(ChiselContainerInit.CHISEL_CONTAINER, id);
        int si;
        this.entity = inv.f_35978_;
        this.world = inv.f_35978_.f_19853_;
        this.internal = new ItemStackHandler(9);
        BlockPos pos = null;
        if (extraData != null) {
            pos = extraData.m_130135_();
            this.x = pos.m_123341_();
            this.y = pos.m_123342_();
            this.z = pos.m_123343_();
        }
        if (pos != null) {
            if (extraData.readableBytes() == 1) {
                byte hand = extraData.readByte();
                ItemStack itemstack = hand == 0 ? this.entity.m_21205_() : this.entity.m_21206_();
                itemstack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(capability -> {
                    this.internal = capability;
                    this.bound = true;
                });
            } else if (extraData.readableBytes() > 1) {
                extraData.readByte();
                Entity entity = this.world.m_6815_(extraData.m_130242_());
                if (entity != null) {
                    entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(capability -> {
                        this.internal = capability;
                        this.bound = true;
                    });
                }
            } else {
                BlockEntity ent;
                BlockEntity blockEntity = ent = inv.f_35978_ != null ? inv.f_35978_.f_19853_.m_7702_(pos) : null;
                if (ent != null) {
                    ent.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(capability -> {
                        this.internal = capability;
                        this.bound = true;
                    });
                }
            }
        }
        this.customSlots.put(0, this.m_38897_((Slot)new SlotItemHandler(this.internal, 0, 80, 30){}));
        this.customSlots.put(1, this.m_38897_((Slot)new SlotItemHandler(this.internal, 1, 56, 30){

            public void m_142406_(Player entity, ItemStack stack) {
                super.m_142406_(entity, stack);
                ChiselContainer.this.slotChanged(1, 1, 0);
            }

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        }));
        this.customSlots.put(2, this.m_38897_((Slot)new SlotItemHandler(this.internal, 2, 80, 6){

            public void m_142406_(Player entity, ItemStack stack) {
                super.m_142406_(entity, stack);
                ChiselContainer.this.slotChanged(2, 1, 0);
            }

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        }));
        this.customSlots.put(3, this.m_38897_((Slot)new SlotItemHandler(this.internal, 3, 104, 30){

            public void m_142406_(Player entity, ItemStack stack) {
                super.m_142406_(entity, stack);
                ChiselContainer.this.slotChanged(3, 1, 0);
            }

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        }));
        this.customSlots.put(4, this.m_38897_((Slot)new SlotItemHandler(this.internal, 4, 80, 54){

            public void m_142406_(Player entity, ItemStack stack) {
                super.m_142406_(entity, stack);
                ChiselContainer.this.slotChanged(4, 1, 0);
            }

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        }));
        this.customSlots.put(5, this.m_38897_((Slot)new SlotItemHandler(this.internal, 5, 60, 10){

            public void m_142406_(Player entity, ItemStack stack) {
                super.m_142406_(entity, stack);
                ChiselContainer.this.slotChanged(5, 1, 0);
            }

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        }));
        this.customSlots.put(6, this.m_38897_((Slot)new SlotItemHandler(this.internal, 6, 100, 10){

            public void m_142406_(Player entity, ItemStack stack) {
                super.m_142406_(entity, stack);
                ChiselContainer.this.slotChanged(6, 1, 0);
            }

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        }));
        this.customSlots.put(7, this.m_38897_((Slot)new SlotItemHandler(this.internal, 7, 60, 50){

            public void m_142406_(Player entity, ItemStack stack) {
                super.m_142406_(entity, stack);
                ChiselContainer.this.slotChanged(7, 1, 0);
            }

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        }));
        this.customSlots.put(8, this.m_38897_((Slot)new SlotItemHandler(this.internal, 8, 100, 50){

            public void m_142406_(Player entity, ItemStack stack) {
                super.m_142406_(entity, stack);
                ChiselContainer.this.slotChanged(8, 1, 0);
            }

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        }));
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.m_38897_(new Slot((Container)inv, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.m_38897_(new Slot((Container)inv, si, 8 + si * 18, 142));
        }
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 9) {
                if (!this.m_38903_(itemstack1, 9, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (!this.m_38903_(itemstack1, 0, 9, false)) {
                if (index < 36 ? !this.m_38903_(itemstack1, 36, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 9, 36, false)) {
                    return ItemStack.f_41583_;
                }
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean m_38903_(ItemStack itemStack, int i1, int i2, boolean b) {
        boolean flag = false;
        int i = i1;
        if (b) {
            i = i2 - 1;
        }
        if (itemStack.m_41753_()) {
            while (!itemStack.m_41619_() && !(!b ? i >= i2 : i < i1)) {
                ItemStack itemstack;
                Slot slot = (Slot)this.f_38839_.get(i);
                if (slot.m_5857_(itemstack = slot.m_7993_()) && !itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + itemStack.m_41613_();
                    if (j <= (maxSize = Math.min(slot.m_6641_(), itemStack.m_41741_()))) {
                        itemStack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_5852_(itemstack);
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        itemStack.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_5852_(itemstack);
                        flag = true;
                    }
                }
                if (b) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!itemStack.m_41619_()) {
            i = b ? i2 - 1 : i1;
            while (!(!b ? i >= i2 : i < i1)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && slot1.m_5857_(itemStack)) {
                    if (itemStack.m_41613_() > slot1.m_6641_()) {
                        slot1.m_5852_(itemStack.m_41620_(slot1.m_6641_()));
                    } else {
                        slot1.m_5852_(itemStack.m_41620_(itemStack.m_41613_()));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (b) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void m_6877_(Player playerIn) {
        block4: {
            super.m_6877_(playerIn);
            if (this.bound || !(playerIn instanceof ServerPlayer)) break block4;
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            if (!serverPlayer.m_6084_() || serverPlayer.m_9232_()) {
                for (int j = 0; j < this.internal.getSlots(); ++j) {
                    playerIn.m_36176_(this.internal.extractItem(j, this.internal.getStackInSlot(j).m_41613_(), false), false);
                }
            } else {
                for (int i = 0; i < this.internal.getSlots(); ++i) {
                    playerIn.m_150109_().m_150079_(this.internal.extractItem(i, this.internal.getStackInSlot(i).m_41613_(), false));
                }
            }
        }
    }

    private void slotChanged(int slotid, int ctype, int meta) {
        if (this.world != null && this.world.m_5776_()) {
            BuildersDelight.PACKET_HANDLER.sendToServer((Object)new ChiselSlotMessage(slotid, this.x, this.y, this.z, ctype, meta));
            ChiselSlotMessage.handleSlotAction(this.entity, slotid, ctype, meta, this.x, this.y, this.z);
        }
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player entity = event.player;
        if (event.phase == TickEvent.Phase.END && entity.f_36096_ instanceof ChiselContainer) {
            Level world = entity.f_19853_;
            double x = entity.m_20185_();
            double y = entity.m_20186_();
            double z = entity.m_20189_();
            FillChisel.run((Entity)entity);
        }
    }
}

