/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.Properties;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntity;
import net.optifine.RandomEntityContext;
import net.optifine.config.BiomeId;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchBlock;
import net.optifine.config.MatchProfession;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeInt;
import net.optifine.config.RangeListInt;
import net.optifine.config.Weather;
import net.optifine.util.ArrayUtils;
import net.optifine.util.MathUtils;

public class RandomEntityRule<T> {
    private String pathProps = null;
    private acq baseResLoc = null;
    private int index;
    private RandomEntityContext<T> context;
    private int[] textures = null;
    private T[] resources = null;
    private int[] weights = null;
    private BiomeId[] biomes = null;
    private RangeListInt heights = null;
    private RangeListInt healthRange = null;
    private boolean healthPercent = false;
    private NbtTagValue nbtName = null;
    public int[] sumWeights = null;
    public int sumAllWeights = 1;
    private MatchProfession[] professions = null;
    private cen[] colors = null;
    private Boolean baby = null;
    private RangeListInt moonPhases = null;
    private RangeListInt dayTimes = null;
    private Weather[] weatherList = null;
    private RangeListInt sizes = null;
    public NbtTagValue[] nbtTagValues = null;
    public MatchBlock[] blocks = null;

    public RandomEntityRule(Properties props, String pathProps, acq baseResLoc, int index, String valTextures, RandomEntityContext<T> context) {
        String healthStr;
        this.pathProps = pathProps;
        this.baseResLoc = baseResLoc;
        this.index = index;
        this.context = context;
        ConnectedParser cp = context.getConnectedParser();
        this.textures = cp.parseIntList(valTextures);
        this.weights = cp.parseIntList(props.getProperty("weights." + index));
        this.biomes = cp.parseBiomes(props.getProperty("biomes." + index));
        this.heights = cp.parseRangeListIntNeg(props.getProperty("heights." + index));
        if (this.heights == null) {
            this.heights = this.parseMinMaxHeight(props, index);
        }
        if ((healthStr = props.getProperty("health." + index)) != null) {
            this.healthPercent = healthStr.contains("%");
            healthStr = healthStr.replace("%", "");
            this.healthRange = cp.parseRangeListInt(healthStr);
        }
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name." + index));
        this.professions = cp.parseProfessions(props.getProperty("professions." + index));
        this.colors = cp.parseDyeColors(props.getProperty("colors." + index), "color", ConnectedParser.DYE_COLORS_INVALID);
        if (this.colors == null) {
            this.colors = cp.parseDyeColors(props.getProperty("collarColors." + index), "collar color", ConnectedParser.DYE_COLORS_INVALID);
        }
        this.baby = cp.parseBooleanObject(props.getProperty("baby." + index));
        this.moonPhases = cp.parseRangeListInt(props.getProperty("moonPhase." + index));
        this.dayTimes = cp.parseRangeListInt(props.getProperty("dayTime." + index));
        this.weatherList = cp.parseWeather(props.getProperty("weather." + index), "weather." + index, null);
        this.sizes = cp.parseRangeListInt(props.getProperty("sizes." + index));
        this.nbtTagValues = cp.parseNbtTagValues(props, "nbt." + index + ".");
        this.blocks = cp.parseMatchBlocks(props.getProperty("blocks." + index));
    }

    public int getIndex() {
        return this.index;
    }

    private RangeListInt parseMinMaxHeight(Properties props, int index) {
        String minHeightStr = props.getProperty("minHeight." + index);
        String maxHeightStr = props.getProperty("maxHeight." + index);
        if (minHeightStr == null && maxHeightStr == null) {
            return null;
        }
        int minHeight = 0;
        if (minHeightStr != null && (minHeight = Config.parseInt((String)minHeightStr, (int)-1)) < 0) {
            Config.warn((String)("Invalid minHeight: " + minHeightStr));
            return null;
        }
        int maxHeight = 256;
        if (maxHeightStr != null && (maxHeight = Config.parseInt((String)maxHeightStr, (int)-1)) < 0) {
            Config.warn((String)("Invalid maxHeight: " + maxHeightStr));
            return null;
        }
        if (maxHeight < 0) {
            Config.warn((String)("Invalid minHeight, maxHeight: " + minHeightStr + ", " + maxHeightStr));
            return null;
        }
        RangeListInt list = new RangeListInt();
        list.addRange(new RangeInt(minHeight, maxHeight));
        return list;
    }

    public boolean isValid(String path) {
        String resourceName = this.context.getResourceName();
        String resourceNamePlural = this.context.getResourceNamePlural();
        if (this.textures == null || this.textures.length == 0) {
            Config.warn((String)("Invalid " + resourceNamePlural + " for rule: " + this.index));
            return false;
        }
        this.resources = new Object[this.textures.length];
        for (int i = 0; i < this.textures.length; ++i) {
            int index = this.textures[i];
            Object res = this.context.makeResource(this.baseResLoc, index);
            if (res == null) {
                return false;
            }
            this.resources[i] = res;
        }
        if (this.weights != null) {
            if (this.weights.length > this.resources.length) {
                Config.warn((String)("More weights defined than " + resourceNamePlural + ", trimming weights: " + path));
                int[] weights2 = new int[this.resources.length];
                System.arraycopy(this.weights, 0, weights2, 0, weights2.length);
                this.weights = weights2;
            }
            if (this.weights.length < this.resources.length) {
                Config.warn((String)("Less weights defined than " + resourceNamePlural + ", expanding weights: " + path));
                int[] weights2 = new int[this.resources.length];
                System.arraycopy(this.weights, 0, weights2, 0, this.weights.length);
                int avgWeight = MathUtils.getAverage((int[])this.weights);
                for (int i = this.weights.length; i < weights2.length; ++i) {
                    weights2[i] = avgWeight;
                }
                this.weights = weights2;
            }
            this.sumWeights = new int[this.weights.length];
            int sum = 0;
            for (int i = 0; i < this.weights.length; ++i) {
                if (this.weights[i] < 0) {
                    Config.warn((String)("Invalid weight: " + this.weights[i]));
                    return false;
                }
                this.sumWeights[i] = sum += this.weights[i];
            }
            this.sumAllWeights = sum;
            if (this.sumAllWeights <= 0) {
                Config.warn((String)("Invalid sum of all weights: " + sum));
                this.sumAllWeights = 1;
            }
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            Config.warn((String)("Invalid professions or careers: " + path));
            return false;
        }
        if (this.colors == ConnectedParser.DYE_COLORS_INVALID) {
            Config.warn((String)("Invalid colors: " + path));
            return false;
        }
        return true;
    }

    public boolean matches(IRandomEntity randomEntity) {
        dcb blockState;
        qr nbt;
        bfj entity;
        int size;
        Weather weather;
        int dayTime;
        int moonPhase;
        few world;
        bfz livingEntity;
        bfj entity2;
        cen col;
        int level;
        byb entityVillager;
        byc vd;
        bye vp;
        RandomEntity rme;
        bfj entity3;
        String name;
        gu pos;
        if (this.biomes != null && !Matches.biome((cnk)randomEntity.getSpawnBiome(), (BiomeId[])this.biomes)) {
            return false;
        }
        if (this.heights != null && (pos = randomEntity.getSpawnPosition()) != null && !this.heights.isInRange(pos.v())) {
            return false;
        }
        if (this.healthRange != null) {
            int healthMax;
            int health = randomEntity.getHealth();
            if (this.healthPercent && (healthMax = randomEntity.getMaxHealth()) > 0) {
                health = (int)((double)(health * 100) / (double)healthMax);
            }
            if (!this.healthRange.isInRange(health)) {
                return false;
            }
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = randomEntity.getName())) {
            return false;
        }
        if (this.professions != null && randomEntity instanceof RandomEntity && (entity3 = (rme = (RandomEntity)randomEntity).getEntity()) instanceof byb && !MatchProfession.matchesOne((bye)(vp = (vd = (entityVillager = (byb)entity3).gj()).b()), (int)(level = vd.c()), (MatchProfession[])this.professions)) {
            return false;
        }
        if (this.colors != null && (col = randomEntity.getColor()) != null && !Config.equalsOne((Object)col, (Object[])this.colors)) {
            return false;
        }
        if (this.baby != null && randomEntity instanceof RandomEntity && (entity2 = (rme = (RandomEntity)randomEntity).getEntity()) instanceof bfz && (livingEntity = (bfz)entity2).h_() != this.baby.booleanValue()) {
            return false;
        }
        if (this.moonPhases != null && (world = Config.getMinecraft().s) != null && !this.moonPhases.isInRange(moonPhase = world.ao())) {
            return false;
        }
        if (this.dayTimes != null && (world = Config.getMinecraft().s) != null && !this.dayTimes.isInRange(dayTime = (int)(world.W() % 24000L))) {
            return false;
        }
        if (this.weatherList != null && (world = Config.getMinecraft().s) != null && !ArrayUtils.contains((Object[])this.weatherList, (Object)(weather = Weather.getWeather((cmm)world, (float)0.0f)))) {
            return false;
        }
        if (this.sizes != null && randomEntity instanceof RandomEntity && (size = this.getEntitySize(entity = (rme = (RandomEntity)randomEntity).getEntity())) >= 0 && !this.sizes.isInRange(size)) {
            return false;
        }
        if (this.nbtTagValues != null && (nbt = randomEntity.getNbtTag()) != null) {
            for (int i = 0; i < this.nbtTagValues.length; ++i) {
                NbtTagValue ntv = this.nbtTagValues[i];
                if (ntv.matches(nbt)) continue;
                return false;
            }
        }
        return this.blocks == null || (blockState = randomEntity.getBlockState()) == null || Matches.block((dcb)blockState, (MatchBlock[])this.blocks);
    }

    public static cen getEntityColor(bfj entity) {
        if (entity instanceof bso) {
            bso entityWolf = (bso)entity;
            if (!entityWolf.q()) {
                return null;
            }
            return entityWolf.gh();
        }
        if (entity instanceof bro) {
            bro entityCat = (bro)entity;
            if (!entityCat.q()) {
                return null;
            }
            return entityCat.gi();
        }
        if (entity instanceof bsh) {
            bsh entitySheep = (bsh)entity;
            return entitySheep.r();
        }
        if (entity instanceof btn) {
            btn entityLlama = (btn)entity;
            return entityLlama.gl();
        }
        return null;
    }

    public static cen getBlockEntityColor(czn entity) {
        if (entity instanceof czj) {
            czj entityBed = (czj)entity;
            return entityBed.d();
        }
        if (entity instanceof dau) {
            dau entityShulkerBox = (dau)entity;
            return entityShulkerBox.j();
        }
        return null;
    }

    private int getEntitySize(bfj entity) {
        if (entity instanceof bwl) {
            bwl entitySlime = (bwl)entity;
            return entitySlime.ga() - 1;
        }
        if (entity instanceof bwe) {
            bwe entityPhantom = (bwe)entity;
            return entityPhantom.q();
        }
        return -1;
    }

    public T getResource(int randomId, T resDef) {
        if (this.resources == null || this.resources.length == 0) {
            return resDef;
        }
        int index = this.getResourceIndex(randomId);
        return (T)this.resources[index];
    }

    private int getResourceIndex(int randomId) {
        int index = 0;
        if (this.weights == null) {
            index = randomId % this.resources.length;
        } else {
            int randWeight = randomId % this.sumAllWeights;
            for (int i = 0; i < this.sumWeights.length; ++i) {
                if (this.sumWeights[i] <= randWeight) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public T[] getResources() {
        return this.resources;
    }
}

