/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import java.util.Random;
import net.optifine.util.MathUtils;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMath {
    static Random random = new Random(1L);

    public static void main(String[] args) {
        int count = 1;
        TestMath.dbg((String)("Test math: " + count));
        for (int i = 0; i < count; ++i) {
            TestMath.testMatrix4f_mulTranslate();
            TestMath.testMatrix4f_mulScale();
            TestMath.testMatrix4f_mulQuaternion();
            TestMath.testMatrix3f_mulQuaternion();
            TestMath.testVector4f_transform();
            TestMath.testVector3f_transform();
        }
        TestMath.dbg((String)"Done");
    }

    private static void testMatrix4f_mulTranslate() {
        Matrix4f m2 = new Matrix4f();
        MathUtils.setRandom((Matrix4f)m2, (Random)random);
        Matrix4f m22 = MathUtils.copy((Matrix4f)m2);
        float x = random.nextFloat();
        float y2 = random.nextFloat();
        float z = random.nextFloat();
        m2.mul((Matrix4fc)MathUtils.makeTranslate4f((float)x, (float)y2, (float)z));
        MathUtils.mulTranslate((Matrix4f)m22, (float)x, (float)y2, (float)z);
        if (!m22.equals((Object)m2)) {
            TestMath.dbg((String)"*** DIFFERENT ***");
            TestMath.dbg((String)m2.toString());
            TestMath.dbg((String)m22.toString());
        }
    }

    private static void testMatrix4f_mulScale() {
        Matrix4f m2 = new Matrix4f();
        MathUtils.setRandom((Matrix4f)m2, (Random)random);
        Matrix4f m22 = MathUtils.copy((Matrix4f)m2);
        float x = random.nextFloat();
        float y2 = random.nextFloat();
        float z = random.nextFloat();
        m2.mul((Matrix4fc)MathUtils.makeScale4f((float)x, (float)y2, (float)z));
        MathUtils.mulScale((Matrix4f)m22, (float)x, (float)y2, (float)z);
        if (!m22.equals((Object)m2)) {
            TestMath.dbg((String)"*** DIFFERENT ***");
            TestMath.dbg((String)m2.toString());
            TestMath.dbg((String)m22.toString());
        }
    }

    private static void testMatrix4f_mulQuaternion() {
        Matrix4f m2 = new Matrix4f();
        MathUtils.setRandom((Matrix4f)m2, (Random)random);
        Matrix4f m22 = MathUtils.copy((Matrix4f)m2);
        Quaternionf q = new Quaternionf(random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat());
        m2.mul((Matrix4fc)MathUtils.makeMatrix4f((Quaternionf)q));
        MathUtils.mul((Matrix4f)m22, (Quaternionf)q);
        if (!m22.equals((Object)m2)) {
            TestMath.dbg((String)"*** DIFFERENT ***");
            TestMath.dbg((String)m2.toString());
            TestMath.dbg((String)m22.toString());
        }
    }

    private static void testMatrix3f_mulQuaternion() {
        Matrix3f m2 = new Matrix3f();
        MathUtils.setRandom((Matrix3f)m2, (Random)random);
        Matrix3f m22 = MathUtils.copy((Matrix3f)m2);
        Quaternionf q = new Quaternionf(random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat());
        m2.mul((Matrix3fc)MathUtils.makeMatrix3f((Quaternionf)q));
        MathUtils.mul((Matrix3f)m22, (Quaternionf)q);
        if (!m22.equals((Object)m2)) {
            TestMath.dbg((String)"*** DIFFERENT ***");
            TestMath.dbg((String)m2.toString());
            TestMath.dbg((String)m22.toString());
        }
    }

    private static void testVector3f_transform() {
        Vector3f v = new Vector3f(random.nextFloat(), random.nextFloat(), random.nextFloat());
        Vector3f v2 = MathUtils.copy((Vector3f)v);
        Matrix3f m2 = new Matrix3f();
        MathUtils.setRandom((Matrix3f)m2, (Random)random);
        MathUtils.transform((Vector3f)v, (Matrix3f)m2);
        float x = MathUtils.getTransformX((Matrix3f)m2, (float)v2.x(), (float)v2.y(), (float)v2.z());
        float y2 = MathUtils.getTransformY((Matrix3f)m2, (float)v2.x(), (float)v2.y(), (float)v2.z());
        float z = MathUtils.getTransformZ((Matrix3f)m2, (float)v2.x(), (float)v2.y(), (float)v2.z());
        v2 = new Vector3f(x, y2, z);
        if (!v2.equals((Object)v)) {
            TestMath.dbg((String)"*** DIFFERENT ***");
            TestMath.dbg((String)v.toString());
            TestMath.dbg((String)v2.toString());
        }
    }

    private static void testVector4f_transform() {
        Vector4f v = new Vector4f(random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat());
        Vector4f v2 = MathUtils.copy((Vector4f)v);
        Matrix4f m2 = new Matrix4f();
        MathUtils.setRandom((Matrix4f)m2, (Random)random);
        MathUtils.transform((Vector4f)v, (Matrix4f)m2);
        float x = MathUtils.getTransformX((Matrix4f)m2, (float)v2.x(), (float)v2.y(), (float)v2.z(), (float)v2.w());
        float y2 = MathUtils.getTransformY((Matrix4f)m2, (float)v2.x(), (float)v2.y(), (float)v2.z(), (float)v2.w());
        float z = MathUtils.getTransformZ((Matrix4f)m2, (float)v2.x(), (float)v2.y(), (float)v2.z(), (float)v2.w());
        float w = MathUtils.getTransformW((Matrix4f)m2, (float)v2.x(), (float)v2.y(), (float)v2.z(), (float)v2.w());
        v2 = new Vector4f(x, y2, z, w);
        if (!v2.equals((Object)v)) {
            TestMath.dbg((String)"*** DIFFERENT ***");
            TestMath.dbg((String)v.toString());
            TestMath.dbg((String)v2.toString());
        }
    }

    private static void dbg(String str) {
        System.out.println(str);
    }
}

