/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.client.ChunkRenderTypeSet;

/*
 * Exception performing whole class analysis ignored.
 */
public class ChunkRenderTypeSet
implements Iterable<gmj> {
    private static final List<gmj> CHUNK_RENDER_TYPES_LIST = gmj.Q();
    private static final gmj[] CHUNK_RENDER_TYPES = CHUNK_RENDER_TYPES_LIST.toArray(new gmj[0]);
    private static final ChunkRenderTypeSet NONE = new None();
    private static final ChunkRenderTypeSet ALL = new All();
    private final BitSet bits;

    public static ChunkRenderTypeSet none() {
        return NONE;
    }

    public static ChunkRenderTypeSet all() {
        return ALL;
    }

    public static ChunkRenderTypeSet of(gmj ... renderTypes) {
        return ChunkRenderTypeSet.of(Arrays.asList(renderTypes));
    }

    public static ChunkRenderTypeSet of(Collection<gmj> renderTypes) {
        if (renderTypes.isEmpty()) {
            return ChunkRenderTypeSet.none();
        }
        return ChunkRenderTypeSet.of(renderTypes);
    }

    private static ChunkRenderTypeSet of(Iterable<gmj> renderTypes) {
        BitSet bits = new BitSet();
        for (gmj renderType : renderTypes) {
            int index = renderType.getChunkLayerId();
            Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)("Attempted to create chunk render type set with a non-chunk render type: " + String.valueOf(renderType)));
            bits.set(index);
        }
        return new ChunkRenderTypeSet(bits);
    }

    public static ChunkRenderTypeSet union(ChunkRenderTypeSet ... sets) {
        return ChunkRenderTypeSet.union(Arrays.asList(sets));
    }

    public static ChunkRenderTypeSet union(Collection<ChunkRenderTypeSet> sets) {
        if (sets.isEmpty()) {
            return ChunkRenderTypeSet.none();
        }
        return ChunkRenderTypeSet.union(sets);
    }

    public static ChunkRenderTypeSet union(Iterable<ChunkRenderTypeSet> sets) {
        BitSet bits = new BitSet();
        for (ChunkRenderTypeSet set : sets) {
            bits.or(set.bits);
        }
        return new ChunkRenderTypeSet(bits);
    }

    public static ChunkRenderTypeSet intersection(ChunkRenderTypeSet ... sets) {
        return ChunkRenderTypeSet.intersection(Arrays.asList(sets));
    }

    public static ChunkRenderTypeSet intersection(Collection<ChunkRenderTypeSet> sets) {
        if (sets.isEmpty()) {
            return ChunkRenderTypeSet.all();
        }
        return ChunkRenderTypeSet.intersection(sets);
    }

    public static ChunkRenderTypeSet intersection(Iterable<ChunkRenderTypeSet> sets) {
        BitSet bits = new BitSet();
        bits.set(0, CHUNK_RENDER_TYPES.length);
        for (ChunkRenderTypeSet set : sets) {
            bits.and(set.bits);
        }
        return new ChunkRenderTypeSet(bits);
    }

    private ChunkRenderTypeSet(BitSet bits) {
        this.bits = bits;
    }

    public boolean isEmpty() {
        return this.bits.isEmpty();
    }

    public boolean contains(gmj renderType) {
        int id = renderType.getChunkLayerId();
        return id >= 0 && this.bits.get(id);
    }

    @Override
    public Iterator<gmj> iterator() {
        return new IteratorImpl(this);
    }

    public List<gmj> asList() {
        return ImmutableList.copyOf((Iterable)this);
    }
}

